/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.keygen.parser;

import java.io.Serializable;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.util.Option;
import org.joda.time.DateTimeZone;
import org.joda.time.format.DateTimeFormatter;

public abstract class BaseHoodieDateTimeParser
implements Serializable {
    protected final TypedProperties config;
    protected final String configInputDateFormatDelimiter;

    public BaseHoodieDateTimeParser(TypedProperties config) {
        this.config = config;
        this.configInputDateFormatDelimiter = this.initInputDateFormatDelimiter();
    }

    private String initInputDateFormatDelimiter() {
        String inputDateFormatDelimiter = this.config.getString("hoodie.deltastreamer.keygen.timebased.input.dateformat.list.delimiter.regex", ",").trim();
        inputDateFormatDelimiter = inputDateFormatDelimiter.isEmpty() ? "," : inputDateFormatDelimiter;
        return inputDateFormatDelimiter;
    }

    public String getOutputDateFormat() {
        return this.config.getString("hoodie.deltastreamer.keygen.timebased.output.dateformat");
    }

    public abstract Option<DateTimeFormatter> getInputFormatter();

    public abstract DateTimeZone getInputDateTimeZone();

    public abstract DateTimeZone getOutputDateTimeZone();

    public String getConfigInputDateFormatDelimiter() {
        return this.configInputDateFormatDelimiter;
    }
}

