/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket;

import java.util.Comparator;
import java.util.Map;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.BlockCacheKey;
import org.apache.hudi.org.apache.hadoop.hbase.io.hfile.bucket.BucketEntry;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.common.collect.MinMaxPriorityQueue;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CachedEntryQueue {
    private static final Comparator<Map.Entry<BlockCacheKey, BucketEntry>> COMPARATOR = (a, b) -> BucketEntry.COMPARATOR.compare((BucketEntry)a.getValue(), (BucketEntry)b.getValue());
    private MinMaxPriorityQueue<Map.Entry<BlockCacheKey, BucketEntry>> queue;
    private long cacheSize;
    private long maxSize;

    public CachedEntryQueue(long maxSize, long blockSize) {
        int initialSize = (int)(maxSize / blockSize);
        if (initialSize == 0) {
            ++initialSize;
        }
        this.queue = MinMaxPriorityQueue.orderedBy(COMPARATOR).expectedSize(initialSize).create();
        this.cacheSize = 0L;
        this.maxSize = maxSize;
    }

    public void add(Map.Entry<BlockCacheKey, BucketEntry> entry) {
        if (this.cacheSize < this.maxSize) {
            this.queue.add(entry);
            this.cacheSize += (long)entry.getValue().getLength();
        } else {
            BucketEntry head = this.queue.peek().getValue();
            if (BucketEntry.COMPARATOR.compare(entry.getValue(), head) > 0) {
                this.cacheSize += (long)entry.getValue().getLength();
                this.cacheSize -= (long)head.getLength();
                if (this.cacheSize > this.maxSize) {
                    this.queue.poll();
                } else {
                    this.cacheSize += (long)head.getLength();
                }
                this.queue.add(entry);
            }
        }
    }

    public Map.Entry<BlockCacheKey, BucketEntry> poll() {
        return this.queue.poll();
    }

    public Map.Entry<BlockCacheKey, BucketEntry> pollLast() {
        return this.queue.pollLast();
    }
}

