/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import java.io.Closeable;
import java.util.List;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class MemStoreSnapshot
implements Closeable {
    private final long id;
    private final int cellsCount;
    private final MemStoreSize memStoreSize;
    private final TimeRangeTracker timeRangeTracker;
    private final List<KeyValueScanner> scanners;
    private final boolean tagsPresent;

    public MemStoreSnapshot(long id, ImmutableSegment snapshot) {
        this.id = id;
        this.cellsCount = snapshot.getCellsCount();
        this.memStoreSize = snapshot.getMemStoreSize();
        this.timeRangeTracker = snapshot.getTimeRangeTracker();
        this.scanners = snapshot.getSnapshotScanners();
        this.tagsPresent = snapshot.isTagsPresent();
    }

    public long getId() {
        return this.id;
    }

    public int getCellsCount() {
        return this.cellsCount;
    }

    public long getDataSize() {
        return this.memStoreSize.getDataSize();
    }

    public MemStoreSize getMemStoreSize() {
        return this.memStoreSize;
    }

    public TimeRangeTracker getTimeRangeTracker() {
        return this.timeRangeTracker;
    }

    public List<KeyValueScanner> getScanners() {
        return this.scanners;
    }

    public boolean isTagsPresent() {
        return this.tagsPresent;
    }

    @Override
    public void close() {
        if (this.scanners != null) {
            for (KeyValueScanner scanner : this.scanners) {
                scanner.close();
            }
        }
    }
}

