/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.jetty.client;

import org.apache.hudi.org.apache.jetty.client.HttpClient;
import org.apache.hudi.org.apache.jetty.client.HttpRedirector;
import org.apache.hudi.org.apache.jetty.client.ProtocolHandler;
import org.apache.hudi.org.apache.jetty.client.api.Request;
import org.apache.hudi.org.apache.jetty.client.api.Response;
import org.apache.hudi.org.apache.jetty.client.api.Result;
import org.apache.hudi.org.apache.jetty.http.HttpField;
import org.apache.hudi.org.apache.jetty.http.HttpHeader;

public class RedirectProtocolHandler
extends Response.Listener.Adapter
implements ProtocolHandler {
    public static final String NAME = "redirect";
    private final HttpRedirector redirector;

    public RedirectProtocolHandler(HttpClient client) {
        this.redirector = new HttpRedirector(client);
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean accept(Request request, Response response) {
        return this.redirector.isRedirect(response) && request.isFollowRedirects();
    }

    @Override
    public Response.Listener getResponseListener() {
        return this;
    }

    @Override
    public boolean onHeader(Response response, HttpField field) {
        return field.getHeader() != HttpHeader.CONTENT_ENCODING;
    }

    @Override
    public void onComplete(Result result) {
        Request request = result.getRequest();
        Response response = result.getResponse();
        if (result.isSucceeded()) {
            this.redirector.redirect(request, response, null);
        } else {
            this.redirector.fail(request, response, result.getFailure());
        }
    }
}

