/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.openjdk.jol.layouters;

import java.util.TreeSet;
import org.apache.hudi.org.openjdk.jol.datamodel.DataModel;
import org.apache.hudi.org.openjdk.jol.info.ClassData;
import org.apache.hudi.org.openjdk.jol.info.ClassLayout;
import org.apache.hudi.org.openjdk.jol.info.FieldData;
import org.apache.hudi.org.openjdk.jol.info.FieldLayout;
import org.apache.hudi.org.openjdk.jol.layouters.Layouter;

public class RawLayouter
implements Layouter {
    private final DataModel model;

    public RawLayouter(DataModel model) {
        this.model = model;
    }

    @Override
    public ClassLayout layout(ClassData data) {
        TreeSet<FieldLayout> result = new TreeSet<FieldLayout>();
        if (data.isArray()) {
            int base = this.model.arrayHeaderSize();
            int scale = this.model.sizeOf(data.arrayComponentType());
            long instanceSize = (long)base + data.arrayLength() * (long)scale;
            result.add(new FieldLayout(FieldData.create(data.arrayClass(), "<elements>", data.arrayComponentType()), base, (long)scale * data.arrayLength()));
            return ClassLayout.create(data, result, this.model, instanceSize, false);
        }
        int offset = this.model.headerSize();
        for (FieldData f : data.fields()) {
            int size = this.model.sizeOf(f.typeClass());
            result.add(new FieldLayout(f, offset, size));
            offset += size;
        }
        if (result.isEmpty()) {
            return ClassLayout.create(data, result, this.model, this.model.headerSize(), false);
        }
        FieldLayout f = (FieldLayout)result.last();
        return ClassLayout.create(data, result, this.model, f.offset() + f.size(), false);
    }

    public String toString() {
        return "Raw data (" + this.model + ")";
    }
}

