/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.bulk.sort;

import java.util.Arrays;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.table.api.TableConfig;
import org.apache.flink.table.data.RowData;
import org.apache.flink.table.planner.codegen.sort.SortCodeGenerator;
import org.apache.flink.table.planner.plan.nodes.exec.spec.SortSpec;
import org.apache.flink.table.types.logical.RowType;
import org.apache.hudi.adapter.SortCodeGeneratorAdapter;
import org.apache.hudi.sink.bulk.sort.SortOperator;

public class SortOperatorGen {
    private final int[] sortIndices;
    private final RowType rowType;
    private final TableConfig tableConfig = new TableConfig();

    public SortOperatorGen(RowType rowType, String[] sortFields) {
        this.sortIndices = Arrays.stream(sortFields).mapToInt(arg_0 -> ((RowType)rowType).getFieldIndex(arg_0)).toArray();
        this.rowType = rowType;
    }

    public OneInputStreamOperator<RowData, RowData> createSortOperator() {
        SortCodeGenerator codeGen = this.createSortCodeGenerator();
        return new SortOperator(codeGen.generateNormalizedKeyComputer("SortComputer"), codeGen.generateRecordComparator("SortComparator"));
    }

    public SortCodeGenerator createSortCodeGenerator() {
        SortSpec.SortSpecBuilder builder = SortSpec.builder();
        for (int sortIndex : this.sortIndices) {
            builder.addField(sortIndex, true, true);
        }
        return new SortCodeGeneratorAdapter(this.tableConfig, this.rowType, builder.build());
    }
}

