/*
 * Decompiled with CFR 0.152.
 */
package org.davidmoten.hilbert;

import com.github.davidmoten.guavamini.Preconditions;
import com.github.davidmoten.guavamini.annotations.VisibleForTesting;
import java.util.Arrays;
import java.util.function.Consumer;

final class Box {
    final long[] a;
    final long[] b;

    Box(long[] a, long[] b) {
        Preconditions.checkArgument(a.length == b.length);
        this.a = a;
        this.b = b;
    }

    int dimensions() {
        return this.a.length;
    }

    public String toString() {
        return "Box [" + Arrays.toString(this.a) + ", " + Arrays.toString(this.b) + "]";
    }

    void visitCells(Consumer<? super long[]> visitor) {
        long[] mins = Box.mins(this.a, this.b);
        long[] maxes = Box.maxes(this.a, this.b);
        long[] x = Arrays.copyOf(mins, mins.length);
        while (true) {
            visitor.accept((long[])x);
            if (Box.equals(x, maxes)) break;
            Box.addOne(x, mins, maxes);
        }
    }

    void visitPerimeter(Consumer<? super long[]> visitor) {
        long[] mins = Box.mins(this.a, this.b);
        long[] maxes = Box.maxes(this.a, this.b);
        for (int specialIndex = this.dimensions() - 1; specialIndex >= 0; --specialIndex) {
            long[] x = Arrays.copyOf(mins, mins.length);
            Box.visitPerimeter(mins, maxes, x, specialIndex, visitor);
            if (mins[specialIndex] == maxes[specialIndex]) break;
            long[] y = Arrays.copyOf(mins, mins.length);
            y[specialIndex] = maxes[specialIndex];
            Box.visitPerimeter(mins, maxes, y, specialIndex, visitor);
        }
    }

    @VisibleForTesting
    static void visitPerimeter(long[] mins, long[] maxes, long[] x, int specialIndex, Consumer<? super long[]> visitor) {
        int i;
        long[] y = Arrays.copyOf(x, x.length);
        for (i = specialIndex + 1; i < y.length; ++i) {
            if (mins[i] >= maxes[i] - 1L) {
                return;
            }
            y[i] = mins[i] + 1L;
        }
        visitor.accept((long[])y);
        while (true) {
            for (i = y.length - 1; i >= 0; --i) {
                if (i > specialIndex) {
                    if (y[i] == maxes[i] - 1L) {
                        y[i] = mins[i] + 1L;
                        continue;
                    }
                    int n = i;
                    y[n] = y[n] + 1L;
                    break;
                }
                if (i < specialIndex) {
                    if (y[i] == maxes[i]) {
                        if (i == 0) {
                            return;
                        }
                        y[i] = mins[i];
                        continue;
                    }
                    int n = i;
                    y[n] = y[n] + 1L;
                    break;
                }
                if (i != specialIndex || i != 0) continue;
                return;
            }
            visitor.accept((long[])y);
        }
    }

    @VisibleForTesting
    static void addOne(long[] x, long[] mins, long[] maxes) {
        for (int i = x.length - 1; i >= 0; --i) {
            if (x[i] != maxes[i]) {
                int n = i;
                x[n] = x[n] + 1L;
                break;
            }
            x[i] = mins[i];
        }
    }

    @VisibleForTesting
    static boolean equals(long[] a, long[] b) {
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    private static long[] mins(long[] a, long[] b) {
        long[] c = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = Math.min(a[i], b[i]);
        }
        return c;
    }

    private static long[] maxes(long[] a, long[] b) {
        long[] c = new long[a.length];
        for (int i = 0; i < a.length; ++i) {
            c[i] = Math.max(a[i], b[i]);
        }
        return c;
    }

    boolean contains(long[] point) {
        Preconditions.checkArgument(this.a.length == point.length);
        for (int i = 0; i < this.a.length; ++i) {
            if (point[i] >= Math.min(this.a[i], this.b[i]) && point[i] <= Math.max(this.a[i], this.b[i])) continue;
            return false;
        }
        return true;
    }
}

