/*
 * Decompiled with CFR 0.152.
 */
package io.javalin.jetty;

import io.javalin.core.JavalinConfig;
import io.javalin.core.security.RouteRole;
import io.javalin.http.Context;
import io.javalin.http.JavalinServlet;
import io.javalin.http.util.ContextUtil;
import io.javalin.websocket.WsConfig;
import io.javalin.websocket.WsConnection;
import io.javalin.websocket.WsEntry;
import io.javalin.websocket.WsExceptionMapper;
import io.javalin.websocket.WsHandlerType;
import io.javalin.websocket.WsPathMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.apache.hudi.javax.servlet.ServletRequest;
import org.apache.hudi.javax.servlet.ServletResponse;
import org.apache.hudi.javax.servlet.http.HttpServletRequest;
import org.apache.hudi.javax.servlet.http.HttpServletResponse;
import org.apache.hudi.org.apache.jetty.websocket.servlet.ServletUpgradeRequest;
import org.apache.hudi.org.apache.jetty.websocket.servlet.ServletUpgradeResponse;
import org.apache.hudi.org.apache.jetty.websocket.servlet.WebSocketServlet;
import org.apache.hudi.org.apache.jetty.websocket.servlet.WebSocketServletFactory;
import org.jetbrains.annotations.NotNull;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u001c0\u001bJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\u00122\u0006\u0010$\u001a\u00020%H\u0016J\u0018\u0010&\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0014J\u0018\u0010+\u001a\u00020\u00122\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020*H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006,"}, d2={"Lio/javalin/jetty/JavalinJettyServlet;", "Lorg/apache/hudi/org/apache/jetty/websocket/servlet/WebSocketServlet;", "config", "Lio/javalin/core/JavalinConfig;", "httpServlet", "Lio/javalin/http/JavalinServlet;", "(Lio/javalin/core/JavalinConfig;Lio/javalin/http/JavalinServlet;)V", "getConfig", "()Lio/javalin/core/JavalinConfig;", "wsExceptionMapper", "Lio/javalin/websocket/WsExceptionMapper;", "getWsExceptionMapper", "()Lio/javalin/websocket/WsExceptionMapper;", "wsPathMatcher", "Lio/javalin/websocket/WsPathMatcher;", "getWsPathMatcher", "()Lio/javalin/websocket/WsPathMatcher;", "addHandler", "", "handlerType", "Lio/javalin/websocket/WsHandlerType;", "path", "", "ws", "Ljava/util/function/Consumer;", "Lio/javalin/websocket/WsConfig;", "roles", "", "Lio/javalin/core/security/RouteRole;", "allowedByAccessManager", "", "entry", "Lio/javalin/websocket/WsEntry;", "ctx", "Lio/javalin/http/Context;", "configure", "factory", "Lorg/apache/hudi/org/apache/jetty/websocket/servlet/WebSocketServletFactory;", "service", "req", "Lorg/apache/hudi/javax/servlet/http/HttpServletRequest;", "res", "Lorg/apache/hudi/javax/servlet/http/HttpServletResponse;", "setWsProtocolHeader", "javalin"})
public final class JavalinJettyServlet
extends WebSocketServlet {
    @NotNull
    private final JavalinConfig config;
    @NotNull
    private final JavalinServlet httpServlet;
    @NotNull
    private final WsExceptionMapper wsExceptionMapper;
    @NotNull
    private final WsPathMatcher wsPathMatcher;

    public JavalinJettyServlet(@NotNull JavalinConfig config, @NotNull JavalinServlet httpServlet) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(httpServlet, "httpServlet");
        this.config = config;
        this.httpServlet = httpServlet;
        this.wsExceptionMapper = new WsExceptionMapper();
        this.wsPathMatcher = new WsPathMatcher();
    }

    @NotNull
    public final JavalinConfig getConfig() {
        return this.config;
    }

    @NotNull
    public final WsExceptionMapper getWsExceptionMapper() {
        return this.wsExceptionMapper;
    }

    @NotNull
    public final WsPathMatcher getWsPathMatcher() {
        return this.wsPathMatcher;
    }

    /*
     * WARNING - void declaration
     */
    public final void addHandler(@NotNull WsHandlerType handlerType, @NotNull String path, @NotNull Consumer<WsConfig> ws, @NotNull Set<? extends RouteRole> roles) {
        void $this$addHandler_u24lambda_u2d0;
        Intrinsics.checkNotNullParameter((Object)handlerType, "handlerType");
        Intrinsics.checkNotNullParameter(path, "path");
        Intrinsics.checkNotNullParameter(ws, "ws");
        Intrinsics.checkNotNullParameter(roles, "roles");
        WsConfig wsConfig = new WsConfig();
        boolean bl = false;
        boolean bl2 = false;
        WsConfig wsConfig2 = wsConfig;
        boolean bl3 = this.config.ignoreTrailingSlashes;
        String string = path;
        WsHandlerType wsHandlerType = handlerType;
        WsPathMatcher wsPathMatcher = this.wsPathMatcher;
        boolean bl4 = false;
        ws.accept((WsConfig)$this$addHandler_u24lambda_u2d0);
        Unit unit = Unit.INSTANCE;
        Set<? extends RouteRole> set = roles;
        WsConfig wsConfig3 = wsConfig;
        boolean bl5 = bl3;
        String string2 = string;
        WsHandlerType wsHandlerType2 = wsHandlerType;
        wsPathMatcher.add(new WsEntry(wsHandlerType2, string2, bl5, wsConfig3, set));
    }

    @Override
    public void configure(@NotNull WebSocketServletFactory factory) {
        Intrinsics.checkNotNullParameter(factory, "factory");
        Consumer<WebSocketServletFactory> consumer = this.config.inner.wsFactoryConfig;
        if (consumer != null) {
            consumer.accept(factory);
        }
        factory.setCreator((arg_0, arg_1) -> JavalinJettyServlet.configure$lambda-2(this, arg_0, arg_1));
    }

    @Override
    protected void service(@NotNull HttpServletRequest req, @NotNull HttpServletResponse res) {
        Intrinsics.checkNotNullParameter(req, "req");
        Intrinsics.checkNotNullParameter(res, "res");
        if (req.getHeader("Sec-WebSocket-Key") == null) {
            this.httpServlet.service((ServletRequest)req, (ServletResponse)res);
            return;
        }
        String string = req.getRequestURI();
        Intrinsics.checkNotNullExpressionValue(string, "req.requestURI");
        String string2 = string;
        string = req.getContextPath();
        Intrinsics.checkNotNullExpressionValue(string, "req.contextPath");
        String requestUri = StringsKt.removePrefix(string2, (CharSequence)string);
        WsEntry wsEntry = this.wsPathMatcher.findEndpointHandlerEntry(requestUri);
        if (wsEntry == null) {
            res.sendError(404, "WebSocket handler not found");
            return;
        }
        WsEntry entry = wsEntry;
        Object object = this.config.inner.appAttributes;
        Intrinsics.checkNotNullExpressionValue(object, "config.inner.appAttributes");
        object = new Context(req, res, (Map<String, ? extends Object>)object);
        boolean bl = false;
        boolean bl2 = false;
        Object $this$service_u24lambda_u2d3 = object;
        boolean bl3 = false;
        ((Context)$this$service_u24lambda_u2d3).setPathParamMap$javalin(entry.extractPathParams(requestUri));
        ((Context)$this$service_u24lambda_u2d3).setMatchedPath$javalin(entry.getPath());
        Object upgradeContext = object;
        if (!this.allowedByAccessManager(entry, (Context)upgradeContext)) {
            res.sendError(401, "Unauthorized");
            return;
        }
        req.setAttribute("javalin-ws-upgrade-context", upgradeContext);
        this.setWsProtocolHeader(req, res);
        super.service(req, res);
    }

    private final boolean allowedByAccessManager(WsEntry entry, Context ctx) {
        boolean bl;
        try {
            this.config.inner.accessManager.manage(JavalinJettyServlet::allowedByAccessManager$lambda-4, ctx, entry.getRoles());
            bl = Intrinsics.areEqual(ctx.attribute("javalin-ws-upgrade-allowed"), true);
        }
        catch (Exception e) {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private final void setWsProtocolHeader(HttpServletRequest req, HttpServletResponse res) {
        Iterator iterator2;
        block5: {
            void $this$mapTo$iv$iv;
            String string = req.getHeader("Sec-WebSocket-Protocol");
            if (string == null) {
                return;
            }
            String wsProtocolHeader = string;
            Object object = new char[]{','};
            Iterable $this$map$iv = StringsKt.split$default((CharSequence)wsProtocolHeader, object, false, 0, 6, null);
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string2 = (String)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void var15_18 = it;
                boolean bl2 = false;
                void v0 = var15_18;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.CharSequence");
                }
                String string3 = ((Object)StringsKt.trim((CharSequence)v0)).toString();
                collection.add(string3);
            }
            object = (List)destination$iv$iv;
            boolean bl = false;
            object2 = object;
            boolean bl3 = false;
            Iterator iterator3 = object2.iterator();
            while (iterator3.hasNext()) {
                Iterator iterator4 = iterator3.next();
                String it = (String)((Object)iterator4);
                boolean bl4 = false;
                CharSequence charSequence = it;
                boolean bl5 = false;
                boolean bl6 = !StringsKt.isBlank(charSequence);
                if (!bl6) continue;
                iterator2 = iterator4;
                break block5;
            }
            iterator2 = null;
        }
        String string = (String)((Object)iterator2);
        if (string == null) {
            return;
        }
        String firstProtocol = string;
        res.setHeader("Sec-WebSocket-Protocol", firstProtocol);
    }

    /*
     * WARNING - void declaration
     */
    private static final Object configure$lambda-2(JavalinJettyServlet this$0, ServletUpgradeRequest req, ServletUpgradeResponse $noName_1) {
        Map map;
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Object object = req.getHttpServletRequest().getAttribute("javalin-ws-upgrade-context");
        if (object == null) {
            throw new NullPointerException("null cannot be cast to non-null type io.javalin.http.Context");
        }
        Context preUpgradeContext = (Context)object;
        Object object2 = object = req.getHttpServletRequest();
        Intrinsics.checkNotNullExpressionValue(object, "req.httpServletRequest");
        object2.setAttribute("javalin-ws-upgrade-context", ContextUtil.INSTANCE.changeBaseRequest(preUpgradeContext, (HttpServletRequest)object));
        HttpServletRequest httpServletRequest = req.getHttpServletRequest();
        String string = "javalin-ws-upgrade-http-session";
        object = req.getSession();
        if (object == null) {
            map = null;
        } else {
            Enumeration<String> enumeration = object.getAttributeNames();
            if (enumeration == null) {
                map = null;
            } else {
                Object object3 = enumeration;
                boolean bl = false;
                Sequence<String> sequence = SequencesKt.asSequence(CollectionsKt.iterator(object3));
                if (sequence == null) {
                    map = null;
                } else {
                    Map map2;
                    void $this$associateWith$iv;
                    object3 = sequence;
                    String string2 = string;
                    HttpServletRequest httpServletRequest2 = httpServletRequest;
                    boolean $i$f$associateWith = false;
                    LinkedHashMap result$iv = new LinkedHashMap();
                    void $this$associateWithTo$iv$iv = $this$associateWith$iv;
                    boolean $i$f$associateWithTo = false;
                    for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
                        void it;
                        String string3 = (String)element$iv$iv;
                        Object t = element$iv$iv;
                        map2 = result$iv;
                        boolean bl2 = false;
                        Object object4 = req.getSession().getAttribute((String)it);
                        map2.put(t, object4);
                    }
                    map2 = result$iv;
                    httpServletRequest = httpServletRequest2;
                    string = string2;
                    map = map2;
                }
            }
        }
        httpServletRequest.setAttribute(string, map);
        return new WsConnection(this$0.getWsPathMatcher(), this$0.getWsExceptionMapper(), this$0.getConfig().inner.wsLogger);
    }

    private static final void allowedByAccessManager$lambda-4(Context it) {
        Intrinsics.checkNotNullParameter(it, "it");
        it.attribute("javalin-ws-upgrade-allowed", true);
    }
}

