/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.avro.model;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.nio.ByteBuffer;
import java.util.ConcurrentModificationException;
import java.util.List;
import org.apache.hudi.avro.model.HoodieIndexPartitionInfo;
import org.apache.hudi.org.apache.avro.AvroMissingFieldException;
import org.apache.hudi.org.apache.avro.AvroRuntimeException;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.data.RecordBuilder;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.io.DatumReader;
import org.apache.hudi.org.apache.avro.io.DatumWriter;
import org.apache.hudi.org.apache.avro.io.Encoder;
import org.apache.hudi.org.apache.avro.io.ResolvingDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageDecoder;
import org.apache.hudi.org.apache.avro.message.BinaryMessageEncoder;
import org.apache.hudi.org.apache.avro.message.SchemaStore;
import org.apache.hudi.org.apache.avro.specific.AvroGenerated;
import org.apache.hudi.org.apache.avro.specific.SpecificData;
import org.apache.hudi.org.apache.avro.specific.SpecificRecord;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBase;
import org.apache.hudi.org.apache.avro.specific.SpecificRecordBuilderBase;

@AvroGenerated
public class HoodieIndexCommitMetadata
extends SpecificRecordBase
implements SpecificRecord {
    private static final long serialVersionUID = -1542844827266137726L;
    public static final Schema SCHEMA$ = new Schema.Parser().parse("{\"type\":\"record\",\"name\":\"HoodieIndexCommitMetadata\",\"namespace\":\"org.apache.hudi.avro.model\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"doc\":\"This field replaces the field filesToBeDeletedPerPartition\",\"default\":1},{\"name\":\"operationType\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"doc\":\"This field replaces the field filesToBeDeletedPerPartition\",\"default\":null},{\"name\":\"indexPartitionInfos\",\"type\":[\"null\",{\"type\":\"array\",\"items\":{\"type\":\"record\",\"name\":\"HoodieIndexPartitionInfo\",\"fields\":[{\"name\":\"version\",\"type\":[\"int\",\"null\"],\"default\":1},{\"name\":\"metadataPartitionPath\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null},{\"name\":\"indexUptoInstant\",\"type\":[\"null\",{\"type\":\"string\",\"avro.java.string\":\"String\"}],\"default\":null}]}}],\"doc\":\"This field contains the info for each partition that got indexed\",\"default\":null}]}");
    private static SpecificData MODEL$ = new SpecificData();
    private static final BinaryMessageEncoder<HoodieIndexCommitMetadata> ENCODER = new BinaryMessageEncoder(MODEL$, SCHEMA$);
    private static final BinaryMessageDecoder<HoodieIndexCommitMetadata> DECODER = new BinaryMessageDecoder(MODEL$, SCHEMA$);
    private Integer version;
    private String operationType;
    private List<HoodieIndexPartitionInfo> indexPartitionInfos;
    private static final DatumWriter<HoodieIndexCommitMetadata> WRITER$ = MODEL$.createDatumWriter(SCHEMA$);
    private static final DatumReader<HoodieIndexCommitMetadata> READER$ = MODEL$.createDatumReader(SCHEMA$);

    public static Schema getClassSchema() {
        return SCHEMA$;
    }

    public static BinaryMessageEncoder<HoodieIndexCommitMetadata> getEncoder() {
        return ENCODER;
    }

    public static BinaryMessageDecoder<HoodieIndexCommitMetadata> getDecoder() {
        return DECODER;
    }

    public static BinaryMessageDecoder<HoodieIndexCommitMetadata> createDecoder(SchemaStore resolver2) {
        return new BinaryMessageDecoder<HoodieIndexCommitMetadata>(MODEL$, SCHEMA$, resolver2);
    }

    public ByteBuffer toByteBuffer() throws IOException {
        return ENCODER.encode(this);
    }

    public static HoodieIndexCommitMetadata fromByteBuffer(ByteBuffer b) throws IOException {
        return (HoodieIndexCommitMetadata)DECODER.decode(b);
    }

    public HoodieIndexCommitMetadata() {
    }

    public HoodieIndexCommitMetadata(Integer version, String operationType, List<HoodieIndexPartitionInfo> indexPartitionInfos) {
        this.version = version;
        this.operationType = operationType;
        this.indexPartitionInfos = indexPartitionInfos;
    }

    @Override
    public SpecificData getSpecificData() {
        return MODEL$;
    }

    @Override
    public Schema getSchema() {
        return SCHEMA$;
    }

    @Override
    public Object get(int field$) {
        switch (field$) {
            case 0: {
                return this.version;
            }
            case 1: {
                return this.operationType;
            }
            case 2: {
                return this.indexPartitionInfos;
            }
        }
        throw new IndexOutOfBoundsException("Invalid index: " + field$);
    }

    @Override
    public void put(int field$, Object value$) {
        switch (field$) {
            case 0: {
                this.version = (Integer)value$;
                break;
            }
            case 1: {
                this.operationType = value$ != null ? value$.toString() : null;
                break;
            }
            case 2: {
                this.indexPartitionInfos = (List)value$;
                break;
            }
            default: {
                throw new IndexOutOfBoundsException("Invalid index: " + field$);
            }
        }
    }

    public Integer getVersion() {
        return this.version;
    }

    public void setVersion(Integer value) {
        this.version = value;
    }

    public String getOperationType() {
        return this.operationType;
    }

    public void setOperationType(String value) {
        this.operationType = value;
    }

    public List<HoodieIndexPartitionInfo> getIndexPartitionInfos() {
        return this.indexPartitionInfos;
    }

    public void setIndexPartitionInfos(List<HoodieIndexPartitionInfo> value) {
        this.indexPartitionInfos = value;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newBuilder(Builder other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    public static Builder newBuilder(HoodieIndexCommitMetadata other) {
        if (other == null) {
            return new Builder();
        }
        return new Builder(other);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        WRITER$.write(this, SpecificData.getEncoder(out));
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException {
        READER$.read(this, SpecificData.getDecoder(in));
    }

    @Override
    protected boolean hasCustomCoders() {
        return true;
    }

    @Override
    public void customEncode(Encoder out) throws IOException {
        if (this.version == null) {
            out.writeIndex(1);
            out.writeNull();
        } else {
            out.writeIndex(0);
            out.writeInt(this.version);
        }
        if (this.operationType == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            out.writeString(this.operationType);
        }
        if (this.indexPartitionInfos == null) {
            out.writeIndex(0);
            out.writeNull();
        } else {
            out.writeIndex(1);
            long size0 = this.indexPartitionInfos.size();
            out.writeArrayStart();
            out.setItemCount(size0);
            long actualSize0 = 0L;
            for (HoodieIndexPartitionInfo e0 : this.indexPartitionInfos) {
                ++actualSize0;
                out.startItem();
                e0.customEncode(out);
            }
            out.writeArrayEnd();
            if (actualSize0 != size0) {
                throw new ConcurrentModificationException("Array-size written was " + size0 + ", but element count was " + actualSize0 + ".");
            }
        }
    }

    @Override
    public void customDecode(ResolvingDecoder in) throws IOException {
        Schema.Field[] fieldOrder = in.readFieldOrderIfDiff();
        if (fieldOrder == null) {
            if (in.readIndex() != 0) {
                in.readNull();
                this.version = null;
            } else {
                this.version = in.readInt();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.operationType = null;
            } else {
                this.operationType = in.readString();
            }
            if (in.readIndex() != 1) {
                in.readNull();
                this.indexPartitionInfos = null;
            } else {
                GenericData.Array ga0;
                long size0 = in.readArrayStart();
                List<HoodieIndexPartitionInfo> a0 = this.indexPartitionInfos;
                if (a0 == null) {
                    this.indexPartitionInfos = a0 = new GenericData.Array<HoodieIndexPartitionInfo>((int)size0, SCHEMA$.getField("indexPartitionInfos").schema().getTypes().get(1));
                } else {
                    a0.clear();
                }
                GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                while (0L < size0) {
                    while (size0 != 0L) {
                        HoodieIndexPartitionInfo e0;
                        HoodieIndexPartitionInfo hoodieIndexPartitionInfo = e0 = ga0 != null ? (HoodieIndexPartitionInfo)ga0.peek() : null;
                        if (e0 == null) {
                            e0 = new HoodieIndexPartitionInfo();
                        }
                        e0.customDecode(in);
                        a0.add(e0);
                        --size0;
                    }
                    size0 = in.arrayNext();
                }
            }
        } else {
            block7: for (int i = 0; i < 3; ++i) {
                switch (fieldOrder[i].pos()) {
                    case 0: {
                        if (in.readIndex() != 0) {
                            in.readNull();
                            this.version = null;
                            continue block7;
                        }
                        this.version = in.readInt();
                        continue block7;
                    }
                    case 1: {
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.operationType = null;
                            continue block7;
                        }
                        this.operationType = in.readString();
                        continue block7;
                    }
                    case 2: {
                        GenericData.Array ga0;
                        if (in.readIndex() != 1) {
                            in.readNull();
                            this.indexPartitionInfos = null;
                            continue block7;
                        }
                        long size0 = in.readArrayStart();
                        List<HoodieIndexPartitionInfo> a0 = this.indexPartitionInfos;
                        if (a0 == null) {
                            this.indexPartitionInfos = a0 = new GenericData.Array<HoodieIndexPartitionInfo>((int)size0, SCHEMA$.getField("indexPartitionInfos").schema().getTypes().get(1));
                        } else {
                            a0.clear();
                        }
                        GenericData.Array array = ga0 = a0 instanceof GenericData.Array ? (GenericData.Array)a0 : null;
                        while (0L < size0) {
                            while (size0 != 0L) {
                                HoodieIndexPartitionInfo e0;
                                HoodieIndexPartitionInfo hoodieIndexPartitionInfo = e0 = ga0 != null ? (HoodieIndexPartitionInfo)ga0.peek() : null;
                                if (e0 == null) {
                                    e0 = new HoodieIndexPartitionInfo();
                                }
                                e0.customDecode(in);
                                a0.add(e0);
                                --size0;
                            }
                            size0 = in.arrayNext();
                        }
                        continue block7;
                    }
                    default: {
                        throw new IOException("Corrupt ResolvingDecoder.");
                    }
                }
            }
        }
    }

    @AvroGenerated
    public static class Builder
    extends SpecificRecordBuilderBase<HoodieIndexCommitMetadata>
    implements RecordBuilder<HoodieIndexCommitMetadata> {
        private Integer version;
        private String operationType;
        private List<HoodieIndexPartitionInfo> indexPartitionInfos;

        private Builder() {
            super(SCHEMA$);
        }

        private Builder(Builder other) {
            super(other);
            if (Builder.isValidValue(this.fields()[0], other.version)) {
                this.version = this.data().deepCopy(this.fields()[0].schema(), other.version);
                this.fieldSetFlags()[0] = other.fieldSetFlags()[0];
            }
            if (Builder.isValidValue(this.fields()[1], other.operationType)) {
                this.operationType = this.data().deepCopy(this.fields()[1].schema(), other.operationType);
                this.fieldSetFlags()[1] = other.fieldSetFlags()[1];
            }
            if (Builder.isValidValue(this.fields()[2], other.indexPartitionInfos)) {
                this.indexPartitionInfos = this.data().deepCopy(this.fields()[2].schema(), other.indexPartitionInfos);
                this.fieldSetFlags()[2] = other.fieldSetFlags()[2];
            }
        }

        private Builder(HoodieIndexCommitMetadata other) {
            super(SCHEMA$);
            if (Builder.isValidValue(this.fields()[0], other.version)) {
                this.version = this.data().deepCopy(this.fields()[0].schema(), other.version);
                this.fieldSetFlags()[0] = true;
            }
            if (Builder.isValidValue(this.fields()[1], other.operationType)) {
                this.operationType = this.data().deepCopy(this.fields()[1].schema(), other.operationType);
                this.fieldSetFlags()[1] = true;
            }
            if (Builder.isValidValue(this.fields()[2], other.indexPartitionInfos)) {
                this.indexPartitionInfos = this.data().deepCopy(this.fields()[2].schema(), other.indexPartitionInfos);
                this.fieldSetFlags()[2] = true;
            }
        }

        public Integer getVersion() {
            return this.version;
        }

        public Builder setVersion(Integer value) {
            this.validate(this.fields()[0], value);
            this.version = value;
            this.fieldSetFlags()[0] = true;
            return this;
        }

        public boolean hasVersion() {
            return this.fieldSetFlags()[0];
        }

        public Builder clearVersion() {
            this.version = null;
            this.fieldSetFlags()[0] = false;
            return this;
        }

        public String getOperationType() {
            return this.operationType;
        }

        public Builder setOperationType(String value) {
            this.validate(this.fields()[1], value);
            this.operationType = value;
            this.fieldSetFlags()[1] = true;
            return this;
        }

        public boolean hasOperationType() {
            return this.fieldSetFlags()[1];
        }

        public Builder clearOperationType() {
            this.operationType = null;
            this.fieldSetFlags()[1] = false;
            return this;
        }

        public List<HoodieIndexPartitionInfo> getIndexPartitionInfos() {
            return this.indexPartitionInfos;
        }

        public Builder setIndexPartitionInfos(List<HoodieIndexPartitionInfo> value) {
            this.validate(this.fields()[2], value);
            this.indexPartitionInfos = value;
            this.fieldSetFlags()[2] = true;
            return this;
        }

        public boolean hasIndexPartitionInfos() {
            return this.fieldSetFlags()[2];
        }

        public Builder clearIndexPartitionInfos() {
            this.indexPartitionInfos = null;
            this.fieldSetFlags()[2] = false;
            return this;
        }

        @Override
        public HoodieIndexCommitMetadata build() {
            try {
                HoodieIndexCommitMetadata record = new HoodieIndexCommitMetadata();
                record.version = this.fieldSetFlags()[0] ? this.version : (Integer)this.defaultValue(this.fields()[0]);
                record.operationType = this.fieldSetFlags()[1] ? this.operationType : (String)this.defaultValue(this.fields()[1]);
                record.indexPartitionInfos = this.fieldSetFlags()[2] ? this.indexPartitionInfos : (List)this.defaultValue(this.fields()[2]);
                return record;
            }
            catch (AvroMissingFieldException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AvroRuntimeException(e);
            }
        }
    }
}

