/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.com.fasterxml.jackson.databind.node;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.hudi.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.BigIntegerNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.BinaryNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.BooleanNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.DecimalNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.DoubleNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.FloatNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.IntNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.JsonNodeCreator;
import org.apache.hudi.com.fasterxml.jackson.databind.node.LongNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.NullNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.NumericNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.POJONode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.ShortNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.TextNode;
import org.apache.hudi.com.fasterxml.jackson.databind.node.ValueNode;
import org.apache.hudi.com.fasterxml.jackson.databind.util.RawValue;

public class JsonNodeFactory
implements Serializable,
JsonNodeCreator {
    private static final long serialVersionUID = 1L;
    private final boolean _cfgBigDecimalExact;
    private static final JsonNodeFactory decimalsNormalized = new JsonNodeFactory(false);
    private static final JsonNodeFactory decimalsAsIs = new JsonNodeFactory(true);
    public static final JsonNodeFactory instance = decimalsNormalized;

    public JsonNodeFactory(boolean bigDecimalExact) {
        this._cfgBigDecimalExact = bigDecimalExact;
    }

    protected JsonNodeFactory() {
        this(false);
    }

    public static JsonNodeFactory withExactBigDecimals(boolean bigDecimalExact) {
        return bigDecimalExact ? decimalsAsIs : decimalsNormalized;
    }

    @Override
    public BooleanNode booleanNode(boolean v) {
        return v ? BooleanNode.getTrue() : BooleanNode.getFalse();
    }

    @Override
    public NullNode nullNode() {
        return NullNode.getInstance();
    }

    @Override
    public NumericNode numberNode(byte v) {
        return IntNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Byte value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value.intValue());
    }

    @Override
    public NumericNode numberNode(short v) {
        return ShortNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Short value) {
        return value == null ? this.nullNode() : ShortNode.valueOf(value);
    }

    @Override
    public NumericNode numberNode(int v) {
        return IntNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Integer value) {
        return value == null ? this.nullNode() : IntNode.valueOf(value);
    }

    @Override
    public NumericNode numberNode(long v) {
        return LongNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Long value) {
        if (value == null) {
            return this.nullNode();
        }
        return LongNode.valueOf(value);
    }

    @Override
    public NumericNode numberNode(BigInteger v) {
        return BigIntegerNode.valueOf(v);
    }

    @Override
    public NumericNode numberNode(float v) {
        return FloatNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Float value) {
        return value == null ? this.nullNode() : FloatNode.valueOf(value.floatValue());
    }

    @Override
    public NumericNode numberNode(double v) {
        return DoubleNode.valueOf(v);
    }

    @Override
    public ValueNode numberNode(Double value) {
        return value == null ? this.nullNode() : DoubleNode.valueOf(value);
    }

    @Override
    public NumericNode numberNode(BigDecimal v) {
        if (this._cfgBigDecimalExact) {
            return DecimalNode.valueOf(v);
        }
        return v.compareTo(BigDecimal.ZERO) == 0 ? DecimalNode.ZERO : DecimalNode.valueOf(v.stripTrailingZeros());
    }

    @Override
    public TextNode textNode(String text) {
        return TextNode.valueOf(text);
    }

    @Override
    public BinaryNode binaryNode(byte[] data) {
        return BinaryNode.valueOf(data);
    }

    @Override
    public BinaryNode binaryNode(byte[] data, int offset, int length) {
        return BinaryNode.valueOf(data, offset, length);
    }

    @Override
    public ArrayNode arrayNode() {
        return new ArrayNode(this);
    }

    @Override
    public ObjectNode objectNode() {
        return new ObjectNode(this);
    }

    @Override
    public ValueNode pojoNode(Object pojo) {
        return new POJONode(pojo);
    }

    @Override
    public ValueNode rawValueNode(RawValue value) {
        return new POJONode(value);
    }

    protected boolean _inIntRange(long l) {
        int i = (int)l;
        long l2 = i;
        return l2 == l;
    }
}

