/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.execution;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.config.TypedProperties;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.common.util.queue.HoodieConsumer;
import org.apache.hudi.execution.HoodieLazyInsertIterable;
import org.apache.hudi.io.HoodieWriteHandle;

public class ExplicitWriteHandler<T>
implements HoodieConsumer<HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord>, List<WriteStatus>> {
    private final List<WriteStatus> statuses = new ArrayList<WriteStatus>();
    private HoodieWriteHandle handle;

    public ExplicitWriteHandler(HoodieWriteHandle handle2) {
        this.handle = handle2;
    }

    @Override
    public void consume(HoodieLazyInsertIterable.HoodieInsertValueGenResult<HoodieRecord> genResult) {
        HoodieRecord insertPayload = genResult.getResult();
        this.handle.write(insertPayload, genResult.schema, new TypedProperties(genResult.props));
    }

    @Override
    public List<WriteStatus> finish() {
        this.closeOpenHandle();
        ValidationUtils.checkState(this.statuses.size() > 0);
        return this.statuses;
    }

    private void closeOpenHandle() {
        this.statuses.addAll(this.handle.close());
    }
}

