/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io.encoding;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.BufferedDataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.DataBlockEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.EncodingState;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultDecodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockDefaultEncodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.HFileBlockEncodingContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.encoding.NoneEncoder;
import org.apache.hudi.org.apache.hadoop.hbase.nio.ByteBuff;
import org.apache.hudi.org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class CopyKeyDataBlockEncoder
extends BufferedDataBlockEncoder {
    @Override
    public void startBlockEncoding(HFileBlockEncodingContext blkEncodingCtx, DataOutputStream out) throws IOException {
        if (blkEncodingCtx.getClass() != HFileBlockDefaultEncodingContext.class) {
            throw new IOException(this.getClass().getName() + " only accepts " + HFileBlockDefaultEncodingContext.class.getName() + " as the encoding context.");
        }
        HFileBlockDefaultEncodingContext encodingCtx = (HFileBlockDefaultEncodingContext)blkEncodingCtx;
        encodingCtx.prepareEncoding(out);
        NoneEncoder encoder = new NoneEncoder(out, encodingCtx);
        CopyKeyEncodingState state = new CopyKeyEncodingState();
        state.encoder = encoder;
        blkEncodingCtx.setEncodingState(state);
    }

    @Override
    public int internalEncode(Cell cell, HFileBlockDefaultEncodingContext encodingContext, DataOutputStream out) throws IOException {
        CopyKeyEncodingState state = (CopyKeyEncodingState)encodingContext.getEncodingState();
        NoneEncoder encoder = state.encoder;
        return encoder.write(cell);
    }

    @Override
    public Cell getFirstKeyCellInBlock(ByteBuff block) {
        int keyLength = block.getIntAfterPosition(4);
        int pos = 12;
        ByteBuffer key = block.asSubByteBuffer(pos + keyLength).duplicate();
        return this.createFirstKeyCell(key, keyLength);
    }

    public String toString() {
        return CopyKeyDataBlockEncoder.class.getSimpleName();
    }

    @Override
    public DataBlockEncoder.EncodedSeeker createSeeker(HFileBlockDecodingContext decodingCtx) {
        return new SeekerStateBufferedEncodedSeeker(decodingCtx);
    }

    @Override
    protected ByteBuffer internalDecodeKeyValues(DataInputStream source, int allocateHeaderLength, int skipLastBytes, HFileBlockDefaultDecodingContext decodingCtx) throws IOException {
        int decompressedSize = source.readInt();
        ByteBuffer buffer = ByteBuffer.allocate(decompressedSize + allocateHeaderLength);
        buffer.position(allocateHeaderLength);
        ByteBufferUtils.copyFromStreamToBuffer(buffer, source, decompressedSize);
        return buffer;
    }

    private static class SeekerStateBufferedEncodedSeeker
    extends BufferedDataBlockEncoder.BufferedEncodedSeeker<BufferedDataBlockEncoder.SeekerState> {
        private SeekerStateBufferedEncodedSeeker(HFileBlockDecodingContext decodingCtx) {
            super(decodingCtx);
        }

        @Override
        protected void decodeNext() {
            this.current.keyLength = this.currentBuffer.getInt();
            this.current.valueLength = this.currentBuffer.getInt();
            this.current.ensureSpaceForKey();
            this.currentBuffer.get(this.current.keyBuffer, 0, this.current.keyLength);
            this.current.valueOffset = this.currentBuffer.position();
            this.currentBuffer.skip(this.current.valueLength);
            if (this.includesTags()) {
                this.current.tagsLength = (this.currentBuffer.get() & 0xFF) << 8 ^ this.currentBuffer.get() & 0xFF;
                this.currentBuffer.skip(this.current.tagsLength);
            }
            this.current.memstoreTS = this.includesMvcc() ? ByteBufferUtils.readVLong(this.currentBuffer) : 0L;
            this.current.nextKvOffset = this.currentBuffer.position();
        }

        @Override
        protected void decodeFirst() {
            this.currentBuffer.skip(4);
            this.current.lastCommonPrefix = 0;
            this.decodeNext();
        }
    }

    private static class CopyKeyEncodingState
    extends EncodingState {
        NoneEncoder encoder = null;

        private CopyKeyEncodingState() {
        }
    }
}

