/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.RpcCallback;
import com.google.protobuf.RpcController;
import com.google.protobuf.Service;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.io.InterruptedIOException;
import org.apache.hadoop.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.UnknownProtocolException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.ServerRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.RequestConverter;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.ClientProtos;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.HBaseProtos;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.ByteString;
import org.apache.hudi.org.apache.hbase.thirdparty.com.google.protobuf.UnsafeByteOperations;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public final class CoprocessorRpcUtils {
    private static final Logger LOG = LoggerFactory.getLogger(CoprocessorRpcUtils.class);
    private static final String hbaseServicePackage;

    private CoprocessorRpcUtils() {
    }

    public static String getServiceName(Descriptors.ServiceDescriptor service) {
        if (service.getFullName().startsWith(hbaseServicePackage)) {
            return service.getName();
        }
        return service.getFullName();
    }

    public static ClientProtos.CoprocessorServiceRequest getCoprocessorServiceRequest(Descriptors.MethodDescriptor method, Message request) {
        return CoprocessorRpcUtils.getCoprocessorServiceRequest(method, request, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY);
    }

    public static ClientProtos.CoprocessorServiceRequest getCoprocessorServiceRequest(Descriptors.MethodDescriptor method, Message request, byte[] row, byte[] regionName) {
        return ClientProtos.CoprocessorServiceRequest.newBuilder().setCall(CoprocessorRpcUtils.getCoprocessorServiceCall(method, request, row)).setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName)).build();
    }

    private static ClientProtos.CoprocessorServiceCall getCoprocessorServiceCall(Descriptors.MethodDescriptor method, Message request, byte[] row) {
        return ClientProtos.CoprocessorServiceCall.newBuilder().setRow(UnsafeByteOperations.unsafeWrap(row)).setServiceName(CoprocessorRpcUtils.getServiceName(method.getService())).setMethodName(method.getName()).setRequest(UnsafeByteOperations.unsafeWrap(request.toByteArray())).build();
    }

    public static Descriptors.MethodDescriptor getMethodDescriptor(String methodName, Descriptors.ServiceDescriptor serviceDesc) throws UnknownProtocolException {
        Descriptors.MethodDescriptor methodDesc = serviceDesc.findMethodByName(methodName);
        if (methodDesc == null) {
            throw new UnknownProtocolException("Unknown method " + methodName + " called on service " + serviceDesc.getFullName());
        }
        return methodDesc;
    }

    public static Message getRequest(Service service, Descriptors.MethodDescriptor methodDesc, ByteString shadedRequest) throws IOException {
        Message.Builder builderForType = service.getRequestPrototype(methodDesc).newBuilderForType();
        ProtobufUtil.mergeFrom(builderForType, shadedRequest.toByteArray());
        return builderForType.build();
    }

    public static Message getResponse(ClientProtos.CoprocessorServiceResponse result, Message responsePrototype) throws IOException {
        Message response;
        if (result.getValue().hasValue()) {
            Message.Builder builder = responsePrototype.newBuilderForType();
            builder.mergeFrom(result.getValue().getValue().newInput());
            response = builder.build();
        } else {
            response = responsePrototype.getDefaultInstanceForType();
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Master Result is value=" + response);
        }
        return response;
    }

    public static ClientProtos.CoprocessorServiceResponse getResponse(Message result, byte[] regionName) {
        ClientProtos.CoprocessorServiceResponse.Builder builder = ClientProtos.CoprocessorServiceResponse.newBuilder();
        builder.setRegion(RequestConverter.buildRegionSpecifier(HBaseProtos.RegionSpecifier.RegionSpecifierType.REGION_NAME, regionName));
        builder.setValue(builder.getValueBuilder().setName(result.getClass().getName()).setValue(ByteString.copyFrom(result.toByteArray())));
        return builder.build();
    }

    public static void setControllerException(RpcController controller, IOException ioe) {
        if (controller == null) {
            return;
        }
        if (controller instanceof ServerRpcController) {
            ((ServerRpcController)controller).setFailedOn(ioe);
        } else {
            controller.setFailed(StringUtils.stringifyException((Throwable)ioe));
        }
    }

    @Nullable
    public static IOException getControllerException(RpcController controller) throws IOException {
        if (controller == null || !controller.failed()) {
            return null;
        }
        if (controller instanceof ServerRpcController) {
            return ((ServerRpcController)controller).getFailedOn();
        }
        return new DoNotRetryIOException(controller.errorText());
    }

    static {
        Descriptors.ServiceDescriptor clientService = ClientProtos.ClientService.getDescriptor();
        hbaseServicePackage = clientService.getFullName().substring(0, clientService.getFullName().lastIndexOf(clientService.getName()));
    }

    @InterfaceAudience.Private
    public static class BlockingRpcCallback<R>
    implements RpcCallback<R> {
        private R result;
        private boolean resultSet = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(R parameter) {
            BlockingRpcCallback blockingRpcCallback = this;
            synchronized (blockingRpcCallback) {
                this.result = parameter;
                this.resultSet = true;
                this.notifyAll();
            }
        }

        public synchronized R get() throws IOException {
            while (!this.resultSet) {
                try {
                    this.wait();
                }
                catch (InterruptedException ie) {
                    InterruptedIOException exception = new InterruptedIOException(ie.getMessage());
                    exception.initCause(ie);
                    throw exception;
                }
            }
            return this.result;
        }
    }
}

