/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.util.WindowMovingAverage;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
public class WeightedMovingAverage
extends WindowMovingAverage {
    private int[] coefficient;
    private int denominator;

    public WeightedMovingAverage(String label) {
        this(label, 5);
    }

    public WeightedMovingAverage(String label, int size) {
        super(label, size);
        int length = this.getNumberOfStatistics();
        this.denominator = length * (length + 1) / 2;
        this.coefficient = new int[length];
        for (int i = 0; i < length; ++i) {
            this.coefficient[i] = i + 1;
        }
    }

    @Override
    public double getAverageTime() {
        if (!this.enoughStatistics()) {
            return super.getAverageTime();
        }
        double average = 0.0;
        int coIndex = 0;
        int length = this.getNumberOfStatistics();
        int tmIndex = (this.getMostRecentPosistion() + 1) % length;
        while (coIndex < length) {
            average += (double)((long)this.coefficient[coIndex] * this.getStatisticsAtIndex(tmIndex));
            ++coIndex;
            ++tmIndex;
            tmIndex %= length;
        }
        return average / (double)this.denominator;
    }
}

