/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.sink.event;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.flink.runtime.operators.coordination.OperatorEvent;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.common.util.ValidationUtils;

public class WriteMetadataEvent
implements OperatorEvent {
    private static final long serialVersionUID = 1L;
    public static final String BOOTSTRAP_INSTANT = "";
    private List<WriteStatus> writeStatuses;
    private int taskID;
    private String instantTime;
    private boolean lastBatch;
    private boolean endInput;
    private boolean bootstrap;

    private WriteMetadataEvent(int taskID, String instantTime, List<WriteStatus> writeStatuses, boolean lastBatch, boolean endInput, boolean bootstrap) {
        this.taskID = taskID;
        this.instantTime = instantTime;
        this.writeStatuses = new ArrayList<WriteStatus>(writeStatuses);
        this.lastBatch = lastBatch;
        this.endInput = endInput;
        this.bootstrap = bootstrap;
    }

    public WriteMetadataEvent() {
    }

    public static Builder builder() {
        return new Builder();
    }

    public List<WriteStatus> getWriteStatuses() {
        return this.writeStatuses;
    }

    public void setWriteStatuses(List<WriteStatus> writeStatuses) {
        this.writeStatuses = writeStatuses;
    }

    public int getTaskID() {
        return this.taskID;
    }

    public void setTaskID(int taskID) {
        this.taskID = taskID;
    }

    public String getInstantTime() {
        return this.instantTime;
    }

    public void setInstantTime(String instantTime) {
        this.instantTime = instantTime;
    }

    public boolean isEndInput() {
        return this.endInput;
    }

    public void setEndInput(boolean endInput) {
        this.endInput = endInput;
    }

    public boolean isBootstrap() {
        return this.bootstrap;
    }

    public void setBootstrap(boolean bootstrap) {
        this.bootstrap = bootstrap;
    }

    public boolean isLastBatch() {
        return this.lastBatch;
    }

    public void setLastBatch(boolean lastBatch) {
        this.lastBatch = lastBatch;
    }

    public void mergeWith(WriteMetadataEvent other) {
        ValidationUtils.checkArgument(this.taskID == other.taskID);
        this.instantTime = other.instantTime;
        this.lastBatch |= other.lastBatch;
        ArrayList<WriteStatus> statusList = new ArrayList<WriteStatus>();
        statusList.addAll(this.writeStatuses);
        statusList.addAll(other.writeStatuses);
        this.writeStatuses = statusList;
    }

    public boolean isReady(String currentInstant) {
        return this.lastBatch && this.instantTime.equals(currentInstant);
    }

    public String toString() {
        return "WriteMetadataEvent{writeStatusesSize=" + this.writeStatuses.size() + ", taskID=" + this.taskID + ", instantTime='" + this.instantTime + '\'' + ", lastBatch=" + this.lastBatch + ", endInput=" + this.endInput + ", bootstrap=" + this.bootstrap + '}';
    }

    public static WriteMetadataEvent emptyBootstrap(int taskId) {
        return WriteMetadataEvent.builder().taskID(taskId).instantTime(BOOTSTRAP_INSTANT).writeStatus(Collections.emptyList()).bootstrap(true).build();
    }

    public static class Builder {
        private List<WriteStatus> writeStatus;
        private Integer taskID;
        private String instantTime;
        private boolean lastBatch = false;
        private boolean endInput = false;
        private boolean bootstrap = false;

        public WriteMetadataEvent build() {
            Objects.requireNonNull(this.taskID);
            Objects.requireNonNull(this.instantTime);
            Objects.requireNonNull(this.writeStatus);
            return new WriteMetadataEvent(this.taskID, this.instantTime, this.writeStatus, this.lastBatch, this.endInput, this.bootstrap);
        }

        public Builder taskID(int taskID) {
            this.taskID = taskID;
            return this;
        }

        public Builder instantTime(String instantTime) {
            this.instantTime = instantTime;
            return this;
        }

        public Builder writeStatus(List<WriteStatus> writeStatus) {
            this.writeStatus = writeStatus;
            return this;
        }

        public Builder lastBatch(boolean lastBatch) {
            this.lastBatch = lastBatch;
            return this;
        }

        public Builder endInput(boolean endInput) {
            this.endInput = endInput;
            return this;
        }

        public Builder bootstrap(boolean bootstrap) {
            this.bootstrap = bootstrap;
            return this;
        }
    }
}

