/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.table.log.block;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.avro.HoodieAvroWriteSupport;
import org.apache.hudi.common.fs.inline.InLineFSUtils;
import org.apache.hudi.common.fs.inline.InLineFileSystem;
import org.apache.hudi.common.table.log.block.HoodieDataBlock;
import org.apache.hudi.common.table.log.block.HoodieLogBlock;
import org.apache.hudi.common.util.ClosableIterator;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.ParquetReaderIterator;
import org.apache.hudi.io.storage.HoodieParquetConfig;
import org.apache.hudi.io.storage.HoodieParquetStreamWriter;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.IndexedRecord;
import org.apache.hudi.org.apache.parquet.avro.AvroParquetReader;
import org.apache.hudi.org.apache.parquet.avro.AvroReadSupport;
import org.apache.hudi.org.apache.parquet.avro.AvroSchemaConverter;
import org.apache.hudi.org.apache.parquet.hadoop.ParquetReader;
import org.apache.hudi.org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.hudi.org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.hudi.org.apache.parquet.io.InputFile;

public class HoodieParquetDataBlock
extends HoodieDataBlock {
    private final Option<CompressionCodecName> compressionCodecName;

    public HoodieParquetDataBlock(FSDataInputStream inputStream, Option<byte[]> content, boolean readBlockLazily, HoodieLogBlock.HoodieLogBlockContentLocation logBlockContentLocation, Option<Schema> readerSchema, Map<HoodieLogBlock.HeaderMetadataType, String> header, Map<HoodieLogBlock.HeaderMetadataType, String> footer, String keyField) {
        super(content, inputStream, readBlockLazily, Option.of(logBlockContentLocation), readerSchema, header, footer, keyField, false);
        this.compressionCodecName = Option.empty();
    }

    public HoodieParquetDataBlock(@Nonnull List<IndexedRecord> records, @Nonnull Map<HoodieLogBlock.HeaderMetadataType, String> header, @Nonnull String keyField, @Nonnull CompressionCodecName compressionCodecName) {
        super(records, header, new HashMap<HoodieLogBlock.HeaderMetadataType, String>(), keyField);
        this.compressionCodecName = Option.of(compressionCodecName);
    }

    @Override
    public HoodieLogBlock.HoodieLogBlockType getBlockType() {
        return HoodieLogBlock.HoodieLogBlockType.PARQUET_DATA_BLOCK;
    }

    @Override
    protected byte[] serializeRecords(List<IndexedRecord> records) throws IOException {
        if (records.size() == 0) {
            return new byte[0];
        }
        Schema writerSchema = new Schema.Parser().parse(super.getLogBlockHeader().get((Object)HoodieLogBlock.HeaderMetadataType.SCHEMA));
        HoodieAvroWriteSupport writeSupport = new HoodieAvroWriteSupport(new AvroSchemaConverter().convert(writerSchema), writerSchema, Option.empty());
        HoodieParquetConfig<HoodieAvroWriteSupport> avroParquetConfig = new HoodieParquetConfig<HoodieAvroWriteSupport>(writeSupport, this.compressionCodecName.get(), 0x8000000, 0x100000, 0x40000000L, new Configuration(), Double.parseDouble(String.valueOf(0.1)));
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try (FSDataOutputStream outputStream = new FSDataOutputStream((OutputStream)baos);
             HoodieParquetStreamWriter<IndexedRecord> parquetWriter = new HoodieParquetStreamWriter<IndexedRecord>(outputStream, avroParquetConfig);){
            for (IndexedRecord record : records) {
                String recordKey = this.getRecordKey(record).orElse(null);
                parquetWriter.writeAvro(recordKey, record);
            }
            outputStream.flush();
        }
        return baos.toByteArray();
    }

    public static ClosableIterator<IndexedRecord> getProjectedParquetRecordsIterator(Configuration conf, Schema readerSchema, InputFile inputFile) throws IOException {
        AvroReadSupport.setAvroReadSchema(conf, readerSchema);
        AvroReadSupport.setRequestedProjection(conf, readerSchema);
        ParquetReader reader = AvroParquetReader.builder(inputFile).withConf(conf).build();
        return new ParquetReaderIterator<IndexedRecord>(reader);
    }

    @Override
    protected ClosableIterator<IndexedRecord> readRecordsFromBlockPayload() throws IOException {
        HoodieLogBlock.HoodieLogBlockContentLocation blockContentLoc = this.getBlockContentLocation().get();
        Configuration inlineConf = new Configuration(blockContentLoc.getHadoopConf());
        inlineConf.set("fs.inlinefs.impl", InLineFileSystem.class.getName());
        Path inlineLogFilePath = InLineFSUtils.getInlineFilePath(blockContentLoc.getLogFile().getPath(), blockContentLoc.getLogFile().getPath().getFileSystem(inlineConf).getScheme(), blockContentLoc.getContentPositionInLogFile(), blockContentLoc.getBlockSize());
        return HoodieParquetDataBlock.getProjectedParquetRecordsIterator(inlineConf, this.readerSchema, HadoopInputFile.fromPath(inlineLogFilePath, inlineConf));
    }

    @Override
    protected ClosableIterator<IndexedRecord> deserializeRecords(byte[] content) {
        throw new UnsupportedOperationException("Should not be invoked");
    }
}

