/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.sql.Date;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.avro.Conversions;
import org.apache.hudi.org.apache.avro.JsonProperties;
import org.apache.hudi.org.apache.avro.LogicalType;
import org.apache.hudi.org.apache.avro.LogicalTypes;
import org.apache.hudi.org.apache.avro.Schema;
import org.apache.hudi.org.apache.avro.generic.GenericData;
import org.apache.hudi.org.apache.avro.util.Utf8;
import org.apache.orc.TypeDescription;
import org.apache.orc.storage.common.type.HiveDecimal;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.ColumnVector;
import org.apache.orc.storage.ql.exec.vector.DecimalColumnVector;
import org.apache.orc.storage.ql.exec.vector.DoubleColumnVector;
import org.apache.orc.storage.ql.exec.vector.ListColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.MapColumnVector;
import org.apache.orc.storage.ql.exec.vector.StructColumnVector;
import org.apache.orc.storage.ql.exec.vector.TimestampColumnVector;
import org.apache.orc.storage.ql.exec.vector.UnionColumnVector;
import org.apache.orc.storage.serde2.io.DateWritable;

public class AvroOrcUtils {
    private static final int MICROS_PER_MILLI = 1000;
    private static final int NANOS_PER_MICRO = 1000;

    public static void addToVector(TypeDescription type, ColumnVector colVector, Schema avroSchema, Object value, int vectorPos) {
        int currentVecLength = colVector.isNull.length;
        if (vectorPos >= currentVecLength) {
            colVector.ensureSize(2 * currentVecLength, true);
        }
        if (value == null) {
            colVector.isNull[vectorPos] = true;
            colVector.noNulls = false;
            return;
        }
        if (avroSchema.getType().equals((Object)Schema.Type.UNION)) {
            avroSchema = AvroOrcUtils.getActualSchemaType(avroSchema);
        }
        LogicalType logicalType = avroSchema != null ? avroSchema.getLogicalType() : null;
        switch (type.getCategory()) {
            case BOOLEAN: {
                LongColumnVector boolVec = (LongColumnVector)colVector;
                boolVec.vector[vectorPos] = (Boolean)value != false ? 1L : 0L;
                break;
            }
            case BYTE: {
                LongColumnVector byteColVec = (LongColumnVector)colVector;
                byteColVec.vector[vectorPos] = ((Byte)value).byteValue();
                break;
            }
            case SHORT: {
                LongColumnVector shortColVec = (LongColumnVector)colVector;
                shortColVec.vector[vectorPos] = ((Short)value).shortValue();
                break;
            }
            case INT: {
                LongColumnVector intColVec = (LongColumnVector)colVector;
                intColVec.vector[vectorPos] = ((Integer)value).intValue();
                break;
            }
            case LONG: {
                LongColumnVector longColVec = (LongColumnVector)colVector;
                longColVec.vector[vectorPos] = (Long)value;
                break;
            }
            case FLOAT: {
                DoubleColumnVector floatColVec = (DoubleColumnVector)colVector;
                floatColVec.vector[vectorPos] = ((Float)value).floatValue();
                break;
            }
            case DOUBLE: {
                DoubleColumnVector doubleColVec = (DoubleColumnVector)colVector;
                doubleColVec.vector[vectorPos] = (Double)value;
                break;
            }
            case VARCHAR: 
            case CHAR: 
            case STRING: {
                BytesColumnVector bytesColVec = (BytesColumnVector)colVector;
                byte[] bytes = null;
                if (value instanceof String) {
                    bytes = ((String)value).getBytes(StandardCharsets.UTF_8);
                } else if (value instanceof Utf8) {
                    Utf8 utf8 = (Utf8)value;
                    bytes = utf8.getBytes();
                } else if (value instanceof GenericData.EnumSymbol) {
                    bytes = ((GenericData.EnumSymbol)value).toString().getBytes(StandardCharsets.UTF_8);
                } else {
                    throw new IllegalStateException(String.format("Unrecognized type for Avro %s field value, which has type %s, value %s", type.getCategory().getName(), value.getClass().getName(), value.toString()));
                }
                if (bytes == null) {
                    bytesColVec.isNull[vectorPos] = true;
                    bytesColVec.noNulls = false;
                    break;
                }
                bytesColVec.setRef(vectorPos, bytes, 0, bytes.length);
                break;
            }
            case DATE: {
                int daysSinceEpoch;
                LongColumnVector dateColVec = (LongColumnVector)colVector;
                if (logicalType instanceof LogicalTypes.Date) {
                    daysSinceEpoch = (Integer)value;
                } else if (value instanceof Date) {
                    daysSinceEpoch = DateWritable.dateToDays((Date)((Date)value));
                } else if (value instanceof java.util.Date) {
                    daysSinceEpoch = DateWritable.millisToDays((long)((java.util.Date)value).getTime());
                } else {
                    throw new IllegalStateException(String.format("Unrecognized type for Avro DATE field value, which has type %s, value %s", value.getClass().getName(), value.toString()));
                }
                dateColVec.vector[vectorPos] = daysSinceEpoch;
                break;
            }
            case TIMESTAMP: {
                long time;
                TimestampColumnVector tsColVec = (TimestampColumnVector)colVector;
                int nanos = 0;
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    time = (Long)value;
                } else if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    long logicalTsValue = (Long)value;
                    time = logicalTsValue / 1000L;
                    nanos = 1000 * (int)(logicalTsValue % 1000L);
                } else if (value instanceof Timestamp) {
                    Timestamp tsValue = (Timestamp)value;
                    time = tsValue.getTime();
                    nanos = tsValue.getNanos();
                } else if (value instanceof Date) {
                    Date sqlDateValue = (Date)value;
                    time = sqlDateValue.getTime();
                } else if (value instanceof java.util.Date) {
                    java.util.Date dateValue = (java.util.Date)value;
                    time = dateValue.getTime();
                } else {
                    throw new IllegalStateException(String.format("Unrecognized type for Avro TIMESTAMP field value, which has type %s, value %s", value.getClass().getName(), value.toString()));
                }
                tsColVec.time[vectorPos] = time;
                tsColVec.nanos[vectorPos] = nanos;
                break;
            }
            case BINARY: {
                byte[] binaryBytes;
                BytesColumnVector binaryColVec = (BytesColumnVector)colVector;
                if (value instanceof GenericData.Fixed) {
                    binaryBytes = ((GenericData.Fixed)value).bytes();
                } else if (value instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)value;
                    binaryBytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(binaryBytes);
                } else if (value instanceof byte[]) {
                    binaryBytes = (byte[])value;
                } else {
                    throw new IllegalStateException(String.format("Unrecognized type for Avro BINARY field value, which has type %s, value %s", value.getClass().getName(), value.toString()));
                }
                binaryColVec.setRef(vectorPos, binaryBytes, 0, binaryBytes.length);
                break;
            }
            case DECIMAL: {
                HiveDecimal decimalValue;
                DecimalColumnVector decimalColVec = (DecimalColumnVector)colVector;
                if (value instanceof BigDecimal) {
                    BigDecimal decimal = (BigDecimal)value;
                    decimalValue = HiveDecimal.create((BigDecimal)decimal);
                } else if (value instanceof ByteBuffer) {
                    ByteBuffer byteBuffer = (ByteBuffer)value;
                    byte[] decimalBytes = new byte[byteBuffer.remaining()];
                    byteBuffer.get(decimalBytes);
                    BigInteger bigInt = new BigInteger(decimalBytes);
                    int scale = type.getScale();
                    BigDecimal bigDecVal = new BigDecimal(bigInt, scale);
                    decimalValue = HiveDecimal.create((BigDecimal)bigDecVal);
                    if (decimalValue == null && decimalBytes.length > 0) {
                        throw new IllegalStateException("Unexpected read null HiveDecimal from bytes (base-64 encoded): " + Base64.getEncoder().encodeToString(decimalBytes));
                    }
                } else if (value instanceof GenericData.Fixed) {
                    BigDecimal decimal = new Conversions.DecimalConversion().fromFixed((GenericData.Fixed)value, avroSchema, logicalType);
                    decimalValue = HiveDecimal.create((BigDecimal)decimal);
                } else {
                    throw new IllegalStateException(String.format("Unexpected type for decimal (%s), cannot convert from Avro value", value.getClass().getCanonicalName()));
                }
                if (decimalValue == null) {
                    decimalColVec.isNull[vectorPos] = true;
                    decimalColVec.noNulls = false;
                    break;
                }
                decimalColVec.set(vectorPos, decimalValue);
                break;
            }
            case LIST: {
                List list = (List)value;
                ListColumnVector listColVec = (ListColumnVector)colVector;
                listColVec.offsets[vectorPos] = listColVec.childCount;
                listColVec.lengths[vectorPos] = list.size();
                TypeDescription listType = (TypeDescription)type.getChildren().get(0);
                for (Object listItem : list) {
                    AvroOrcUtils.addToVector(listType, listColVec.child, avroSchema.getElementType(), listItem, listColVec.childCount++);
                }
                break;
            }
            case MAP: {
                Map mapValue = (Map)value;
                MapColumnVector mapColumnVector = (MapColumnVector)colVector;
                mapColumnVector.offsets[vectorPos] = mapColumnVector.childCount;
                mapColumnVector.lengths[vectorPos] = mapValue.size();
                Schema keySchema = Schema.create(Schema.Type.STRING);
                for (Map.Entry entry : mapValue.entrySet()) {
                    AvroOrcUtils.addToVector((TypeDescription)type.getChildren().get(0), mapColumnVector.keys, keySchema, entry.getKey(), mapColumnVector.childCount);
                    AvroOrcUtils.addToVector((TypeDescription)type.getChildren().get(1), mapColumnVector.values, avroSchema.getValueType(), entry.getValue(), mapColumnVector.childCount);
                    ++mapColumnVector.childCount;
                }
                break;
            }
            case STRUCT: {
                StructColumnVector structColVec = (StructColumnVector)colVector;
                GenericData.Record record = (GenericData.Record)value;
                for (int i = 0; i < type.getFieldNames().size(); ++i) {
                    String fieldName = (String)type.getFieldNames().get(i);
                    Object fieldValue = record.get(fieldName);
                    TypeDescription fieldType = (TypeDescription)type.getChildren().get(i);
                    AvroOrcUtils.addToVector(fieldType, structColVec.fields[i], avroSchema.getFields().get(i).schema(), fieldValue, vectorPos);
                }
                break;
            }
            case UNION: {
                UnionColumnVector unionColVec = (UnionColumnVector)colVector;
                List childTypes = type.getChildren();
                boolean added = AvroOrcUtils.addUnionValue(unionColVec, childTypes, avroSchema, value, vectorPos);
                if (added) break;
                throw new IllegalStateException(String.format("Failed to add value %s to union with type %s", value == null ? "null" : value.toString(), type.toString()));
            }
            default: {
                throw new IllegalArgumentException("Invalid TypeDescription " + type.toString() + ".");
            }
        }
    }

    public static boolean addUnionValue(UnionColumnVector unionVector, List<TypeDescription> unionChildTypes, Schema avroSchema, Object value, int vectorPos) {
        int matchIndex = -1;
        TypeDescription matchType = null;
        byte[] matchValue = null;
        for (int t = 0; t < unionChildTypes.size(); ++t) {
            TypeDescription childType = unionChildTypes.get(t);
            boolean matches = false;
            switch (childType.getCategory()) {
                case BOOLEAN: {
                    matches = value instanceof Boolean;
                    break;
                }
                case BYTE: {
                    matches = value instanceof Byte;
                    break;
                }
                case SHORT: {
                    matches = value instanceof Short;
                    break;
                }
                case INT: {
                    matches = value instanceof Integer;
                    break;
                }
                case LONG: {
                    matches = value instanceof Long;
                    break;
                }
                case FLOAT: {
                    matches = value instanceof Float;
                    break;
                }
                case DOUBLE: {
                    matches = value instanceof Double;
                    break;
                }
                case VARCHAR: 
                case CHAR: 
                case STRING: {
                    if (value instanceof String) {
                        matches = true;
                        matchValue = ((String)value).getBytes(StandardCharsets.UTF_8);
                        break;
                    }
                    if (!(value instanceof Utf8)) break;
                    matches = true;
                    matchValue = ((Utf8)value).getBytes();
                    break;
                }
                case DATE: {
                    matches = value instanceof java.util.Date;
                    break;
                }
                case TIMESTAMP: {
                    matches = value instanceof Timestamp;
                    break;
                }
                case BINARY: {
                    matches = value instanceof byte[] || value instanceof GenericData.Fixed;
                    break;
                }
                case DECIMAL: {
                    matches = value instanceof BigDecimal;
                    break;
                }
                case LIST: {
                    matches = value instanceof List;
                    break;
                }
                case MAP: {
                    matches = value instanceof Map;
                    break;
                }
                case STRUCT: {
                    throw new UnsupportedOperationException("Cannot handle STRUCT within UNION.");
                }
                case UNION: {
                    List children = childType.getChildren();
                    if (value == null) {
                        matches = children == null || children.size() == 0;
                        break;
                    }
                    matches = AvroOrcUtils.addUnionValue(unionVector, children, avroSchema, value, vectorPos);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Invalid TypeDescription " + childType.getCategory().toString() + ".");
                }
            }
            if (!matches) continue;
            matchIndex = t;
            matchType = childType;
            break;
        }
        if (value == null && matchValue != null) {
            value = matchValue;
        }
        if (matchIndex >= 0) {
            unionVector.tags[vectorPos] = matchIndex;
            if (value == null) {
                unionVector.isNull[vectorPos] = true;
                unionVector.noNulls = false;
            } else {
                AvroOrcUtils.addToVector(matchType, unionVector.fields[matchIndex], avroSchema.getTypes().get(matchIndex), value, vectorPos);
            }
            return true;
        }
        return false;
    }

    public static Object readFromVector(TypeDescription type, ColumnVector colVector, Schema avroSchema, int vectorPos) {
        if (colVector.isRepeating) {
            vectorPos = 0;
        }
        if (colVector.isNull[vectorPos]) {
            return null;
        }
        if (avroSchema.getType().equals((Object)Schema.Type.UNION)) {
            avroSchema = AvroOrcUtils.getActualSchemaType(avroSchema);
        }
        LogicalType logicalType = avroSchema != null ? avroSchema.getLogicalType() : null;
        switch (type.getCategory()) {
            case BOOLEAN: {
                return ((LongColumnVector)colVector).vector[vectorPos] != 0L;
            }
            case BYTE: {
                return (byte)((LongColumnVector)colVector).vector[vectorPos];
            }
            case SHORT: {
                return (short)((LongColumnVector)colVector).vector[vectorPos];
            }
            case INT: {
                return (int)((LongColumnVector)colVector).vector[vectorPos];
            }
            case LONG: {
                return ((LongColumnVector)colVector).vector[vectorPos];
            }
            case FLOAT: {
                return Float.valueOf((float)((DoubleColumnVector)colVector).vector[vectorPos]);
            }
            case DOUBLE: {
                return ((DoubleColumnVector)colVector).vector[vectorPos];
            }
            case VARCHAR: 
            case CHAR: {
                int maxLength = type.getMaxLength();
                String result = ((BytesColumnVector)colVector).toString(vectorPos);
                if (result.length() <= maxLength) {
                    return result;
                }
                throw new HoodieIOException("CHAR/VARCHAR has length " + result.length() + " greater than Max Length allowed");
            }
            case STRING: {
                String stringType = avroSchema.getProp("avro.java.string");
                if (stringType == null || !stringType.equals((Object)GenericData.StringType.String)) {
                    int stringLength = ((BytesColumnVector)colVector).length[vectorPos];
                    int stringOffset = ((BytesColumnVector)colVector).start[vectorPos];
                    byte[] stringBytes = new byte[stringLength];
                    System.arraycopy(((BytesColumnVector)colVector).vector[vectorPos], stringOffset, stringBytes, 0, stringLength);
                    return new Utf8(stringBytes);
                }
                return ((BytesColumnVector)colVector).toString(vectorPos);
            }
            case DATE: {
                return (int)((LongColumnVector)colVector).vector[vectorPos];
            }
            case TIMESTAMP: {
                long time = ((TimestampColumnVector)colVector).time[vectorPos];
                int nanos = ((TimestampColumnVector)colVector).nanos[vectorPos];
                if (logicalType instanceof LogicalTypes.TimestampMillis) {
                    return time;
                }
                if (logicalType instanceof LogicalTypes.TimestampMicros) {
                    return time * 1000L + (long)(nanos / 1000);
                }
                return ((TimestampColumnVector)colVector).getTimestampAsLong(vectorPos);
            }
            case BINARY: {
                int binaryLength = ((BytesColumnVector)colVector).length[vectorPos];
                int binaryOffset = ((BytesColumnVector)colVector).start[vectorPos];
                byte[] binaryBytes = new byte[binaryLength];
                System.arraycopy(((BytesColumnVector)colVector).vector[vectorPos], binaryOffset, binaryBytes, 0, binaryLength);
                return ByteBuffer.wrap(binaryBytes);
            }
            case DECIMAL: {
                BigDecimal bigDecimal = ((DecimalColumnVector)colVector).vector[vectorPos].getHiveDecimal().bigDecimalValue().setScale(((LogicalTypes.Decimal)logicalType).getScale());
                Schema.Type baseType = avroSchema.getType();
                if (baseType.equals((Object)Schema.Type.FIXED)) {
                    return new Conversions.DecimalConversion().toFixed(bigDecimal, avroSchema, logicalType);
                }
                if (baseType.equals((Object)Schema.Type.BYTES)) {
                    return bigDecimal.unscaledValue().toByteArray();
                }
                throw new HoodieIOException(baseType.getName() + "is not a valid type for LogicalTypes.DECIMAL.");
            }
            case LIST: {
                ArrayList<Object> list = new ArrayList<Object>();
                ListColumnVector listVector = (ListColumnVector)colVector;
                int listLength = (int)listVector.lengths[vectorPos];
                int listOffset = (int)listVector.offsets[vectorPos];
                list.ensureCapacity(listLength);
                TypeDescription childType = (TypeDescription)type.getChildren().get(0);
                for (int i = 0; i < listLength; ++i) {
                    list.add(AvroOrcUtils.readFromVector(childType, listVector.child, avroSchema.getElementType(), listOffset + i));
                }
                return list;
            }
            case MAP: {
                HashMap<String, Object> map = new HashMap<String, Object>();
                MapColumnVector mapVector = (MapColumnVector)colVector;
                int mapLength = (int)mapVector.lengths[vectorPos];
                int mapOffset = (int)mapVector.offsets[vectorPos];
                Schema keySchema = Schema.create(Schema.Type.STRING);
                for (int i = 0; i < mapLength; ++i) {
                    map.put(AvroOrcUtils.readFromVector((TypeDescription)type.getChildren().get(0), mapVector.keys, keySchema, i + mapOffset).toString(), AvroOrcUtils.readFromVector((TypeDescription)type.getChildren().get(1), mapVector.values, avroSchema.getValueType(), i + mapOffset));
                }
                return map;
            }
            case STRUCT: {
                StructColumnVector structVector = (StructColumnVector)colVector;
                List children = type.getChildren();
                GenericData.Record record = new GenericData.Record(avroSchema);
                for (int i = 0; i < children.size(); ++i) {
                    record.put(i, AvroOrcUtils.readFromVector((TypeDescription)children.get(i), structVector.fields[i], avroSchema.getFields().get(i).schema(), vectorPos));
                }
                return record;
            }
            case UNION: {
                UnionColumnVector unionVector = (UnionColumnVector)colVector;
                int tag = unionVector.tags[vectorPos];
                ColumnVector fieldVector = unionVector.fields[tag];
                return AvroOrcUtils.readFromVector((TypeDescription)type.getChildren().get(tag), fieldVector, avroSchema.getTypes().get(tag), vectorPos);
            }
        }
        throw new HoodieIOException("Unrecognized TypeDescription " + type.toString());
    }

    public static TypeDescription createOrcSchema(Schema avroSchema) {
        LogicalType logicalType = avroSchema.getLogicalType();
        if (logicalType != null) {
            if (logicalType instanceof LogicalTypes.Decimal) {
                return TypeDescription.createDecimal().withPrecision(((LogicalTypes.Decimal)logicalType).getPrecision()).withScale(((LogicalTypes.Decimal)logicalType).getScale());
            }
            if (logicalType instanceof LogicalTypes.Date) {
                return TypeDescription.createDate();
            }
            if (logicalType instanceof LogicalTypes.TimeMillis) {
                return TypeDescription.createInt();
            }
            if (logicalType instanceof LogicalTypes.TimeMicros) {
                return TypeDescription.createLong();
            }
            if (logicalType instanceof LogicalTypes.TimestampMillis) {
                return TypeDescription.createTimestamp();
            }
            if (logicalType instanceof LogicalTypes.TimestampMicros) {
                return TypeDescription.createTimestamp();
            }
        }
        Schema.Type type = avroSchema.getType();
        switch (type) {
            case NULL: {
                TypeDescription nullUnion = TypeDescription.createUnion();
                return nullUnion;
            }
            case LONG: {
                return TypeDescription.createLong();
            }
            case INT: {
                return TypeDescription.createInt();
            }
            case BYTES: {
                return TypeDescription.createBinary();
            }
            case ARRAY: {
                return TypeDescription.createList((TypeDescription)AvroOrcUtils.createOrcSchema(avroSchema.getElementType()));
            }
            case RECORD: {
                TypeDescription recordStruct = TypeDescription.createStruct();
                for (Schema.Field field : avroSchema.getFields()) {
                    Schema fieldSchema = field.schema();
                    TypeDescription fieldType = AvroOrcUtils.createOrcSchema(fieldSchema);
                    if (fieldType == null) continue;
                    recordStruct.addField(field.name(), fieldType);
                }
                return recordStruct;
            }
            case MAP: {
                return TypeDescription.createMap((TypeDescription)TypeDescription.createString(), (TypeDescription)AvroOrcUtils.createOrcSchema(avroSchema.getValueType()));
            }
            case UNION: {
                List nonNullMembers = avroSchema.getTypes().stream().filter(schema -> !Schema.Type.NULL.equals((Object)schema.getType())).collect(Collectors.toList());
                if (nonNullMembers.isEmpty()) {
                    return TypeDescription.createUnion();
                }
                if (nonNullMembers.size() == 1) {
                    return AvroOrcUtils.createOrcSchema((Schema)nonNullMembers.get(0));
                }
                TypeDescription union = TypeDescription.createUnion();
                for (Schema childSchema : nonNullMembers) {
                    union.addUnionChild(AvroOrcUtils.createOrcSchema(childSchema));
                }
                return union;
            }
            case STRING: {
                return TypeDescription.createString();
            }
            case FLOAT: {
                return TypeDescription.createFloat();
            }
            case DOUBLE: {
                return TypeDescription.createDouble();
            }
            case BOOLEAN: {
                return TypeDescription.createBoolean();
            }
            case ENUM: {
                return TypeDescription.createString();
            }
            case FIXED: {
                return TypeDescription.createBinary();
            }
        }
        throw new IllegalStateException(String.format("Unrecognized Avro type: %s", type.getName()));
    }

    public static Schema createAvroSchema(TypeDescription orcSchema) {
        switch (orcSchema.getCategory()) {
            case BOOLEAN: {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case BYTE: {
                return Schema.create(Schema.Type.INT);
            }
            case SHORT: {
                return Schema.create(Schema.Type.INT);
            }
            case INT: {
                return Schema.create(Schema.Type.INT);
            }
            case LONG: {
                return Schema.create(Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create(Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create(Schema.Type.DOUBLE);
            }
            case VARCHAR: 
            case CHAR: 
            case STRING: {
                return Schema.create(Schema.Type.STRING);
            }
            case DATE: {
                Schema date = Schema.create(Schema.Type.INT);
                LogicalTypes.date().addToSchema(date);
                return date;
            }
            case TIMESTAMP: {
                Schema timestamp = Schema.create(Schema.Type.LONG);
                LogicalTypes.timestampMillis().addToSchema(timestamp);
                return timestamp;
            }
            case BINARY: {
                return Schema.create(Schema.Type.BYTES);
            }
            case DECIMAL: {
                Schema decimal = Schema.create(Schema.Type.BYTES);
                LogicalTypes.decimal(orcSchema.getPrecision(), orcSchema.getScale()).addToSchema(decimal);
                return decimal;
            }
            case LIST: {
                return Schema.createArray(AvroOrcUtils.createAvroSchema((TypeDescription)orcSchema.getChildren().get(0)));
            }
            case MAP: {
                return Schema.createMap(AvroOrcUtils.createAvroSchema((TypeDescription)orcSchema.getChildren().get(1)));
            }
            case STRUCT: {
                ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
                for (int i = 0; i < orcSchema.getChildren().size(); ++i) {
                    TypeDescription childType = (TypeDescription)orcSchema.getChildren().get(i);
                    String childName = (String)orcSchema.getFieldNames().get(i);
                    childFields.add(new Schema.Field(childName, AvroOrcUtils.createAvroSchema(childType), "", null));
                }
                return Schema.createRecord(childFields);
            }
            case UNION: {
                return Schema.createUnion(orcSchema.getChildren().stream().map(AvroOrcUtils::createAvroSchema).collect(Collectors.toList()));
            }
        }
        throw new IllegalStateException(String.format("Unrecognized ORC type: %s", orcSchema.getCategory().getName()));
    }

    private static Schema getActualSchemaType(Schema unionSchema) {
        List<Schema> nonNullMembers = unionSchema.getTypes().stream().filter(schema -> !Schema.Type.NULL.equals((Object)schema.getType())).collect(Collectors.toList());
        if (nonNullMembers.isEmpty()) {
            return Schema.create(Schema.Type.NULL);
        }
        if (nonNullMembers.size() == 1) {
            return nonNullMembers.get(0);
        }
        return Schema.createUnion(nonNullMembers);
    }

    public static Schema createAvroSchemaWithDefaultValue(TypeDescription orcSchema, String recordName, String namespace, boolean nullable) {
        Schema avroSchema = AvroOrcUtils.createAvroSchemaWithNamespace(orcSchema, recordName, namespace);
        ArrayList<Schema.Field> fields = new ArrayList<Schema.Field>();
        List<Schema.Field> fieldList = avroSchema.getFields();
        for (Schema.Field field : fieldList) {
            Schema fieldSchema = field.schema();
            Schema nullableSchema = Schema.createUnion(Schema.create(Schema.Type.NULL), fieldSchema);
            if (nullable) {
                fields.add(new Schema.Field(field.name(), nullableSchema, null, JsonProperties.NULL_VALUE));
                continue;
            }
            fields.add(new Schema.Field(field.name(), fieldSchema, null, (Object)null));
        }
        Schema schema = Schema.createRecord(recordName, null, null, false);
        schema.setFields(fields);
        return schema;
    }

    private static Schema createAvroSchemaWithNamespace(TypeDescription orcSchema, String recordName, String namespace) {
        switch (orcSchema.getCategory()) {
            case BOOLEAN: {
                return Schema.create(Schema.Type.BOOLEAN);
            }
            case BYTE: {
                return Schema.create(Schema.Type.INT);
            }
            case SHORT: {
                return Schema.create(Schema.Type.INT);
            }
            case INT: {
                return Schema.create(Schema.Type.INT);
            }
            case LONG: {
                return Schema.create(Schema.Type.LONG);
            }
            case FLOAT: {
                return Schema.create(Schema.Type.FLOAT);
            }
            case DOUBLE: {
                return Schema.create(Schema.Type.DOUBLE);
            }
            case VARCHAR: 
            case CHAR: 
            case STRING: {
                return Schema.create(Schema.Type.STRING);
            }
            case DATE: {
                Schema date = Schema.create(Schema.Type.INT);
                LogicalTypes.date().addToSchema(date);
                return date;
            }
            case TIMESTAMP: {
                Schema timestamp = Schema.create(Schema.Type.LONG);
                LogicalTypes.timestampMillis().addToSchema(timestamp);
                return timestamp;
            }
            case BINARY: {
                return Schema.create(Schema.Type.BYTES);
            }
            case DECIMAL: {
                Schema decimal = Schema.create(Schema.Type.BYTES);
                LogicalTypes.decimal(orcSchema.getPrecision(), orcSchema.getScale()).addToSchema(decimal);
                return decimal;
            }
            case LIST: {
                return Schema.createArray(AvroOrcUtils.createAvroSchemaWithNamespace((TypeDescription)orcSchema.getChildren().get(0), recordName, ""));
            }
            case MAP: {
                return Schema.createMap(AvroOrcUtils.createAvroSchemaWithNamespace((TypeDescription)orcSchema.getChildren().get(1), recordName, ""));
            }
            case STRUCT: {
                ArrayList<Schema.Field> childFields = new ArrayList<Schema.Field>();
                for (int i = 0; i < orcSchema.getChildren().size(); ++i) {
                    TypeDescription childType = (TypeDescription)orcSchema.getChildren().get(i);
                    String childName = (String)orcSchema.getFieldNames().get(i);
                    childFields.add(new Schema.Field(childName, AvroOrcUtils.createAvroSchemaWithNamespace(childType, childName, ""), null, null));
                }
                return Schema.createRecord(recordName, null, namespace, false, childFields);
            }
        }
        throw new IllegalStateException(String.format("Unrecognized ORC type: %s", orcSchema.getCategory().getName()));
    }
}

