/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util;

import java.util.ArrayDeque;
import java.util.Deque;
import org.apache.hudi.exception.HoodieException;

public class HoodieTimer {
    private final Deque<TimeInfo> timeInfoDeque = new ArrayDeque<TimeInfo>();

    @Deprecated
    public HoodieTimer() {
        this(false);
    }

    private HoodieTimer(boolean shouldStart) {
        if (shouldStart) {
            this.startTimer();
        }
    }

    public HoodieTimer startTimer() {
        this.timeInfoDeque.push(new TimeInfo(System.currentTimeMillis()));
        return this;
    }

    public long endTimer() {
        if (this.timeInfoDeque.isEmpty()) {
            throw new HoodieException("Timer was not started");
        }
        return this.timeInfoDeque.pop().stop();
    }

    public static HoodieTimer start() {
        return new HoodieTimer(true);
    }

    public static HoodieTimer create() {
        return new HoodieTimer(false);
    }

    static class TimeInfo {
        long startTime;
        boolean isRunning;

        public TimeInfo(long startTime) {
            this.startTime = startTime;
            this.isRunning = true;
        }

        public long getStartTime() {
            return this.startTime;
        }

        public boolean isRunning() {
            return this.isRunning;
        }

        public long stop() {
            this.isRunning = false;
            return System.currentTimeMillis() - this.startTime;
        }
    }
}

