/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import org.apache.hudi.common.util.Base64CodecUtil;
import org.apache.hudi.common.util.hash.HashID;
import org.apache.hudi.common.util.hash.HoodieIndexID;

public class FileIndexID
extends HoodieIndexID {
    private static final HoodieIndexID.Type TYPE = HoodieIndexID.Type.FILE;
    private static final HashID.Size ID_FILE_HASH_SIZE = HashID.Size.BITS_128;
    private final String fileName;
    private final byte[] hash;

    public FileIndexID(String fileName) {
        this.fileName = fileName;
        this.hash = HashID.hash(fileName, ID_FILE_HASH_SIZE);
    }

    @Override
    public String getName() {
        return this.fileName;
    }

    @Override
    public int bits() {
        return ID_FILE_HASH_SIZE.byteSize();
    }

    @Override
    public byte[] asBytes() {
        return this.hash;
    }

    @Override
    public String asBase64EncodedString() {
        return Base64CodecUtil.encode(this.hash);
    }

    @Override
    public String toString() {
        return new String(this.hash);
    }

    @Override
    protected HoodieIndexID.Type getType() {
        return TYPE;
    }
}

