/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.client;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.hudi.org.apache.hadoop.hbase.CallQueueTooBigException;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.NotServingRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotEnabledException;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.client.AsyncConnectionImpl;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionUtils;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionOfflineException;
import org.apache.hudi.org.apache.hadoop.hbase.client.RetriesExhaustedException;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.ScannerResetException;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.HBaseRpcController;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.FutureUtils;
import org.apache.hudi.org.apache.hbase.thirdparty.io.netty.util.Timer;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public abstract class AsyncRpcRetryingCaller<T> {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncRpcRetryingCaller.class);
    private final Timer retryTimer;
    private final int priority;
    private final long startNs;
    private final long pauseNs;
    private final long pauseForCQTBENs;
    private int tries = 1;
    private final int maxAttempts;
    private final int startLogErrorsCnt;
    private final List<RetriesExhaustedException.ThrowableWithExtraContext> exceptions;
    private final long rpcTimeoutNs;
    protected final long operationTimeoutNs;
    protected final AsyncConnectionImpl conn;
    protected final CompletableFuture<T> future;
    protected final HBaseRpcController controller;

    public AsyncRpcRetryingCaller(Timer retryTimer, AsyncConnectionImpl conn, int priority, long pauseNs, long pauseForCQTBENs, int maxAttempts, long operationTimeoutNs, long rpcTimeoutNs, int startLogErrorsCnt) {
        this.retryTimer = retryTimer;
        this.conn = conn;
        this.priority = priority;
        this.pauseNs = pauseNs;
        this.pauseForCQTBENs = pauseForCQTBENs;
        this.maxAttempts = maxAttempts;
        this.operationTimeoutNs = operationTimeoutNs;
        this.rpcTimeoutNs = rpcTimeoutNs;
        this.startLogErrorsCnt = startLogErrorsCnt;
        this.future = new CompletableFuture();
        this.controller = conn.rpcControllerFactory.newController();
        this.controller.setPriority(priority);
        this.exceptions = new ArrayList<RetriesExhaustedException.ThrowableWithExtraContext>();
        this.startNs = System.nanoTime();
    }

    private long elapsedMs() {
        return TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - this.startNs);
    }

    protected final long remainingTimeNs() {
        return this.operationTimeoutNs - (System.nanoTime() - this.startNs);
    }

    protected final void completeExceptionally() {
        this.future.completeExceptionally(new RetriesExhaustedException(this.tries - 1, this.exceptions));
    }

    protected final void resetCallTimeout() {
        long callTimeoutNs;
        if (this.operationTimeoutNs > 0L) {
            callTimeoutNs = this.remainingTimeNs();
            if (callTimeoutNs <= 0L) {
                this.completeExceptionally();
                return;
            }
            callTimeoutNs = Math.min(callTimeoutNs, this.rpcTimeoutNs);
        } else {
            callTimeoutNs = this.rpcTimeoutNs;
        }
        ConnectionUtils.resetController(this.controller, callTimeoutNs, this.priority);
    }

    private void tryScheduleRetry(Throwable error) {
        long delayNs;
        long pauseNsToUse;
        long l = pauseNsToUse = error instanceof CallQueueTooBigException ? this.pauseForCQTBENs : this.pauseNs;
        if (this.operationTimeoutNs > 0L) {
            long maxDelayNs = this.remainingTimeNs() - ConnectionUtils.SLEEP_DELTA_NS;
            if (maxDelayNs <= 0L) {
                this.completeExceptionally();
                return;
            }
            delayNs = Math.min(maxDelayNs, ConnectionUtils.getPauseTime(pauseNsToUse, this.tries - 1));
        } else {
            delayNs = ConnectionUtils.getPauseTime(pauseNsToUse, this.tries - 1);
        }
        ++this.tries;
        this.retryTimer.newTimeout(t -> this.doCall(), delayNs, TimeUnit.NANOSECONDS);
    }

    protected Optional<TableName> getTableName() {
        return Optional.empty();
    }

    protected final void onError(Throwable t, Supplier<String> errMsg, Consumer<Throwable> updateCachedLocation) {
        if (this.future.isDone()) {
            LOG.debug("The future is already done, canceled={}, give up retrying", (Object)this.future.isCancelled());
            return;
        }
        Throwable error = ConnectionUtils.translateException(t);
        if (error instanceof DoNotRetryIOException && !(error instanceof ScannerResetException)) {
            this.future.completeExceptionally(error);
            return;
        }
        if (this.tries > this.startLogErrorsCnt) {
            LOG.warn(errMsg.get() + ", tries = " + this.tries + ", maxAttempts = " + this.maxAttempts + ", timeout = " + TimeUnit.NANOSECONDS.toMillis(this.operationTimeoutNs) + " ms, time elapsed = " + this.elapsedMs() + " ms", error);
        }
        updateCachedLocation.accept(error);
        RetriesExhaustedException.ThrowableWithExtraContext qt = new RetriesExhaustedException.ThrowableWithExtraContext(error, EnvironmentEdgeManager.currentTime(), "");
        this.exceptions.add(qt);
        if (this.tries >= this.maxAttempts) {
            this.completeExceptionally();
            return;
        }
        if (error instanceof NotServingRegionException || error instanceof RegionOfflineException) {
            Optional<TableName> tableName = this.getTableName();
            if (tableName.isPresent()) {
                FutureUtils.addListener(this.conn.getAdmin().isTableDisabled(tableName.get()), (disabled, e) -> {
                    if (e != null) {
                        if (e instanceof TableNotFoundException) {
                            this.future.completeExceptionally((Throwable)e);
                        } else {
                            this.tryScheduleRetry(error);
                        }
                        return;
                    }
                    if (disabled.booleanValue()) {
                        this.future.completeExceptionally(new TableNotEnabledException((TableName)tableName.get()));
                    } else {
                        this.tryScheduleRetry(error);
                    }
                });
            } else {
                this.tryScheduleRetry(error);
            }
        } else {
            this.tryScheduleRetry(error);
        }
    }

    protected abstract void doCall();

    CompletableFuture<T> call() {
        this.doCall();
        return this.future;
    }
}

