/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.assignment;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.DoNotRetryIOException;
import org.apache.hudi.org.apache.hadoop.hbase.HBaseIOException;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.PleaseHoldException;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.UnknownRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.DoNotRetryRegionException;
import org.apache.hudi.org.apache.hadoop.hbase.client.MasterSwitchType;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionInfoBuilder;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionReplicaUtil;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionStatesCount;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.TableState;
import org.apache.hudi.org.apache.hadoop.hbase.exceptions.UnexpectedStateException;
import org.apache.hudi.org.apache.hadoop.hbase.favored.FavoredNodesManager;
import org.apache.hudi.org.apache.hadoop.hbase.favored.FavoredNodesPromoter;
import org.apache.hudi.org.apache.hadoop.hbase.master.LoadBalancer;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.MetricsAssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionPlan;
import org.apache.hudi.org.apache.hadoop.hbase.master.RegionState;
import org.apache.hudi.org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.TableStateManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.MergeTableRegionsProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.RegionStateNode;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.RegionStateStore;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.RegionStates;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.ServerState;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.ServerStateNode;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.SplitTableRegionProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.assignment.TransitRegionStateProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.balancer.FavoredStochasticBalancer;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.HBCKServerCrashProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureEnv;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.MasterProcedureScheduler;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ProcedureSyncWait;
import org.apache.hudi.org.apache.hadoop.hbase.master.procedure.ServerCrashProcedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.AbstractProcedureScheduler;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.Procedure;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureEvent;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureExecutor;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.ProcedureInMemoryChore;
import org.apache.hudi.org.apache.hadoop.hbase.procedure2.util.StringUtils;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.shaded.protobuf.generated.RegionServerStatusProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.EnvironmentEdgeManager;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;
import org.apache.hudi.org.apache.hadoop.hbase.util.VersionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.MetaTableLocator;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.ZKWatcher;
import org.apache.yetus.audience.InterfaceAudience;
import org.apache.zookeeper.KeeperException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class AssignmentManager {
    private static final Logger LOG = LoggerFactory.getLogger(AssignmentManager.class);
    public static final String BOOTSTRAP_THREAD_POOL_SIZE_CONF_KEY = "hbase.assignment.bootstrap.thread.pool.size";
    public static final String ASSIGN_DISPATCH_WAIT_MSEC_CONF_KEY = "hbase.assignment.dispatch.wait.msec";
    private static final int DEFAULT_ASSIGN_DISPATCH_WAIT_MSEC = 150;
    public static final String ASSIGN_DISPATCH_WAITQ_MAX_CONF_KEY = "hbase.assignment.dispatch.wait.queue.max.size";
    private static final int DEFAULT_ASSIGN_DISPATCH_WAITQ_MAX = 100;
    public static final String RIT_CHORE_INTERVAL_MSEC_CONF_KEY = "hbase.assignment.rit.chore.interval.msec";
    private static final int DEFAULT_RIT_CHORE_INTERVAL_MSEC = 60000;
    public static final String DEAD_REGION_METRIC_CHORE_INTERVAL_MSEC_CONF_KEY = "hbase.assignment.dead.region.metric.chore.interval.msec";
    private static final int DEFAULT_DEAD_REGION_METRIC_CHORE_INTERVAL_MSEC = 120000;
    public static final String ASSIGN_MAX_ATTEMPTS = "hbase.assignment.maximum.attempts";
    private static final int DEFAULT_ASSIGN_MAX_ATTEMPTS = Integer.MAX_VALUE;
    public static final String ASSIGN_RETRY_IMMEDIATELY_MAX_ATTEMPTS = "hbase.assignment.retry.immediately.maximum.attempts";
    private static final int DEFAULT_ASSIGN_RETRY_IMMEDIATELY_MAX_ATTEMPTS = 3;
    public static final String METRICS_RIT_STUCK_WARNING_THRESHOLD = "hbase.metrics.rit.stuck.warning.threshold";
    private static final int DEFAULT_RIT_STUCK_WARNING_THRESHOLD = 60000;
    public static final String UNEXPECTED_STATE_REGION = "Unexpected state for ";
    private final ProcedureEvent<?> metaAssignEvent = new ProcedureEvent((Object)"meta assign");
    private final ProcedureEvent<?> metaLoadEvent = new ProcedureEvent((Object)"meta load");
    private final MetricsAssignmentManager metrics;
    private final RegionInTransitionChore ritChore;
    private final DeadServerMetricRegionChore deadMetricChore;
    private final MasterServices master;
    private final AtomicBoolean running = new AtomicBoolean(false);
    private final RegionStates regionStates = new RegionStates();
    private final RegionStateStore regionStateStore;
    private final String minVersionToMoveSysTables;
    private static final String MIN_VERSION_MOVE_SYS_TABLES_CONFIG = "hbase.min.version.move.system.tables";
    private static final String DEFAULT_MIN_VERSION_MOVE_SYS_TABLES_CONFIG = "";
    private final Map<ServerName, Set<byte[]>> rsReports = new HashMap<ServerName, Set<byte[]>>();
    private final boolean shouldAssignRegionsWithFavoredNodes;
    private final int assignDispatchWaitQueueMaxSize;
    private final int assignDispatchWaitMillis;
    private final int assignMaxAttempts;
    private final int assignRetryImmediatelyMaxAttempts;
    private final Object checkIfShouldMoveSystemRegionLock = new Object();
    private Thread assignThread;
    private static final Set<RegionInfo> META_REGION_SET = Collections.singleton(RegionInfoBuilder.FIRST_META_REGIONINFO);
    private static final RegionState.State[] STATES_EXPECTED_ON_OPEN = new RegionState.State[]{RegionState.State.OPENING, RegionState.State.OPEN};
    private static final RegionState.State[] STATES_EXPECTED_ON_CLOSING = new RegionState.State[]{RegionState.State.OPEN, RegionState.State.CLOSING, RegionState.State.SPLITTING, RegionState.State.MERGING};
    private static final RegionState.State[] STATES_EXPECTED_ON_CLOSED = new RegionState.State[]{RegionState.State.CLOSING, RegionState.State.CLOSED};
    private static final RegionState.State[] STATES_EXPECTED_ON_ASSIGN = new RegionState.State[]{RegionState.State.CLOSED, RegionState.State.OFFLINE};
    private static final RegionState.State[] STATES_EXPECTED_ON_UNASSIGN_OR_MOVE = new RegionState.State[]{RegionState.State.OPEN};
    private final ArrayList<RegionStateNode> pendingAssignQueue = new ArrayList();
    private final ReentrantLock assignQueueLock = new ReentrantLock();
    private final Condition assignQueueFullCond = this.assignQueueLock.newCondition();

    public AssignmentManager(MasterServices master) {
        this(master, new RegionStateStore(master));
    }

    AssignmentManager(MasterServices master, RegionStateStore stateStore) {
        this.master = master;
        this.regionStateStore = stateStore;
        this.metrics = new MetricsAssignmentManager();
        Configuration conf = master.getConfiguration();
        this.shouldAssignRegionsWithFavoredNodes = FavoredStochasticBalancer.class.isAssignableFrom(conf.getClass("hbase.master.loadbalancer.class", Object.class));
        this.assignDispatchWaitMillis = conf.getInt(ASSIGN_DISPATCH_WAIT_MSEC_CONF_KEY, 150);
        this.assignDispatchWaitQueueMaxSize = conf.getInt(ASSIGN_DISPATCH_WAITQ_MAX_CONF_KEY, 100);
        this.assignMaxAttempts = Math.max(1, conf.getInt(ASSIGN_MAX_ATTEMPTS, Integer.MAX_VALUE));
        this.assignRetryImmediatelyMaxAttempts = conf.getInt(ASSIGN_RETRY_IMMEDIATELY_MAX_ATTEMPTS, 3);
        int ritChoreInterval = conf.getInt(RIT_CHORE_INTERVAL_MSEC_CONF_KEY, 60000);
        this.ritChore = new RegionInTransitionChore(ritChoreInterval);
        int deadRegionChoreInterval = conf.getInt(DEAD_REGION_METRIC_CHORE_INTERVAL_MSEC_CONF_KEY, 120000);
        this.deadMetricChore = deadRegionChoreInterval > 0 ? new DeadServerMetricRegionChore(deadRegionChoreInterval) : null;
        this.minVersionToMoveSysTables = conf.get(MIN_VERSION_MOVE_SYS_TABLES_CONFIG, DEFAULT_MIN_VERSION_MOVE_SYS_TABLES_CONFIG);
    }

    public void start() throws IOException, KeeperException {
        if (!this.running.compareAndSet(false, true)) {
            return;
        }
        LOG.trace("Starting assignment manager");
        this.startAssignmentThread();
        ZKWatcher zkw = this.master.getZooKeeper();
        if (zkw == null) {
            return;
        }
        List metaZNodes = zkw.getMetaReplicaNodes();
        LOG.debug("hbase:meta replica znodes: {}", (Object)metaZNodes);
        for (String metaZNode : metaZNodes) {
            int replicaId = zkw.getZNodePaths().getMetaReplicaIdFromZNode(metaZNode);
            RegionState regionState = MetaTableLocator.getMetaRegionState((ZKWatcher)zkw, (int)replicaId);
            RegionStateNode regionNode = this.regionStates.getOrCreateRegionStateNode(regionState.getRegion());
            regionNode.setRegionLocation(regionState.getServerName());
            regionNode.setState(regionState.getState(), new RegionState.State[0]);
            if (regionNode.getProcedure() != null) {
                regionNode.getProcedure().stateLoaded(this, regionNode);
            }
            if (regionState.getServerName() != null) {
                this.regionStates.addRegionToServer(regionNode);
            }
            if (RegionReplicaUtil.isDefaultReplica(replicaId)) {
                this.setMetaAssigned(regionState.getRegion(), regionState.getState() == RegionState.State.OPEN);
            }
            LOG.debug("Loaded hbase:meta {}", (Object)regionNode);
        }
    }

    public void setupRIT(List<TransitRegionStateProcedure> procs) {
        procs.forEach(proc -> {
            RegionInfo regionInfo = proc.getRegion();
            RegionStateNode regionNode = this.regionStates.getOrCreateRegionStateNode(regionInfo);
            TransitRegionStateProcedure existingProc = regionNode.getProcedure();
            if (existingProc != null) {
                if (existingProc.getProcId() < proc.getProcId()) {
                    regionNode.unsetProcedure(existingProc);
                } else {
                    return;
                }
            }
            LOG.info("Attach {} to {} to restore RIT", proc, (Object)regionNode);
            regionNode.setProcedure((TransitRegionStateProcedure)proc);
        });
    }

    public void stop() {
        boolean hasProcExecutor;
        if (!this.running.compareAndSet(true, false)) {
            return;
        }
        LOG.info("Stopping assignment manager");
        boolean bl = hasProcExecutor = this.master.getMasterProcedureExecutor() != null;
        if (hasProcExecutor) {
            this.master.getMasterProcedureExecutor().removeChore((ProcedureInMemoryChore)this.ritChore);
            if (this.deadMetricChore != null) {
                this.master.getMasterProcedureExecutor().removeChore((ProcedureInMemoryChore)this.deadMetricChore);
            }
        }
        this.stopAssignmentThread();
        this.regionStates.clear();
        if (hasProcExecutor) {
            this.metaLoadEvent.suspend();
            for (RegionInfo hri : this.getMetaRegionSet()) {
                this.setMetaAssigned(hri, false);
            }
        }
    }

    public boolean isRunning() {
        return this.running.get();
    }

    public Configuration getConfiguration() {
        return this.master.getConfiguration();
    }

    public MetricsAssignmentManager getAssignmentManagerMetrics() {
        return this.metrics;
    }

    private LoadBalancer getBalancer() {
        return this.master.getLoadBalancer();
    }

    private MasterProcedureEnv getProcedureEnvironment() {
        return (MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment();
    }

    private MasterProcedureScheduler getProcedureScheduler() {
        return this.getProcedureEnvironment().getProcedureScheduler();
    }

    int getAssignMaxAttempts() {
        return this.assignMaxAttempts;
    }

    int getAssignRetryImmediatelyMaxAttempts() {
        return this.assignRetryImmediatelyMaxAttempts;
    }

    public RegionStates getRegionStates() {
        return this.regionStates;
    }

    public List<RegionInfo> getRegionsOnServer(ServerName serverName) {
        ServerStateNode serverInfo = this.regionStates.getServerNode(serverName);
        if (serverInfo == null) {
            return Collections.emptyList();
        }
        return serverInfo.getRegionInfoList();
    }

    public RegionStateStore getRegionStateStore() {
        return this.regionStateStore;
    }

    public List<ServerName> getFavoredNodes(RegionInfo regionInfo) {
        return this.shouldAssignRegionsWithFavoredNodes ? ((FavoredStochasticBalancer)this.getBalancer()).getFavoredNodes(regionInfo) : ServerName.EMPTY_SERVER_LIST;
    }

    private TableStateManager getTableStateManager() {
        return this.master.getTableStateManager();
    }

    private boolean isTableEnabled(TableName tableName) {
        return this.getTableStateManager().isTableState(tableName, TableState.State.ENABLED);
    }

    private boolean isTableDisabled(TableName tableName) {
        return this.getTableStateManager().isTableState(tableName, TableState.State.DISABLED, TableState.State.DISABLING);
    }

    private boolean isMetaRegion(RegionInfo regionInfo) {
        return regionInfo.isMetaRegion();
    }

    public boolean isMetaRegion(byte[] regionName) {
        return this.getMetaRegionFromName(regionName) != null;
    }

    public RegionInfo getMetaRegionFromName(byte[] regionName) {
        for (RegionInfo hri : this.getMetaRegionSet()) {
            if (!Bytes.equals(hri.getRegionName(), regionName)) continue;
            return hri;
        }
        return null;
    }

    public boolean isCarryingMeta(ServerName serverName) {
        return this.isCarryingRegion(serverName, RegionInfoBuilder.FIRST_META_REGIONINFO);
    }

    private boolean isCarryingRegion(ServerName serverName, RegionInfo regionInfo) {
        RegionStateNode node = this.regionStates.getRegionStateNode(regionInfo);
        return node != null && serverName.equals(node.getRegionLocation());
    }

    private RegionInfo getMetaForRegion(RegionInfo regionInfo) {
        return RegionInfoBuilder.FIRST_META_REGIONINFO;
    }

    public Set<RegionInfo> getMetaRegionSet() {
        return META_REGION_SET;
    }

    public boolean isMetaAssigned() {
        return this.metaAssignEvent.isReady();
    }

    public boolean isMetaRegionInTransition() {
        return !this.isMetaAssigned();
    }

    public boolean waitMetaAssigned(Procedure<?> proc, RegionInfo regionInfo) {
        return this.getMetaAssignEvent(this.getMetaForRegion(regionInfo)).suspendIfNotReady(proc);
    }

    private void setMetaAssigned(RegionInfo metaRegionInfo, boolean assigned) {
        assert (this.isMetaRegion(metaRegionInfo)) : "unexpected non-meta region " + metaRegionInfo;
        ProcedureEvent<?> metaAssignEvent = this.getMetaAssignEvent(metaRegionInfo);
        if (assigned) {
            metaAssignEvent.wake((AbstractProcedureScheduler)this.getProcedureScheduler());
        } else {
            metaAssignEvent.suspend();
        }
    }

    private ProcedureEvent<?> getMetaAssignEvent(RegionInfo metaRegionInfo) {
        assert (this.isMetaRegion(metaRegionInfo)) : "unexpected non-meta region " + metaRegionInfo;
        return this.metaAssignEvent;
    }

    public boolean waitMetaLoaded(Procedure<?> proc) {
        return this.metaLoadEvent.suspendIfNotReady(proc);
    }

    public void wakeMetaLoadedEvent() {
        this.metaLoadEvent.wake((AbstractProcedureScheduler)this.getProcedureScheduler());
        assert (this.isMetaLoaded()) : "expected meta to be loaded";
    }

    public boolean isMetaLoaded() {
        return this.metaLoadEvent.isReady();
    }

    public void checkIfShouldMoveSystemRegionAsync() {
        if (this.master.getServerManager().countOfRegionServers() <= 1) {
            return;
        }
        new Thread(() -> {
            try {
                Object object = this.checkIfShouldMoveSystemRegionLock;
                synchronized (object) {
                    ArrayList<RegionPlan> plans = new ArrayList<RegionPlan>();
                    for (ServerName server : this.getExcludedServersForSystemTable()) {
                        if (this.master.getServerManager().isServerDead(server)) continue;
                        List<RegionInfo> regionsShouldMove = this.getSystemTables(server);
                        if (!regionsShouldMove.isEmpty()) {
                            for (RegionInfo regionInfo : regionsShouldMove) {
                                RegionPlan plan = new RegionPlan(regionInfo, server, null);
                                if (regionInfo.isMetaRegion()) {
                                    LOG.info("Async MOVE of {} to newer Server={}", (Object)regionInfo.getEncodedName(), (Object)server);
                                    this.moveAsync(plan);
                                    continue;
                                }
                                plans.add(plan);
                            }
                        }
                        for (RegionPlan plan : plans) {
                            LOG.info("Async MOVE of {} to newer Server={}", (Object)plan.getRegionInfo().getEncodedName(), (Object)server);
                            this.moveAsync(plan);
                        }
                    }
                }
            }
            catch (Throwable t) {
                LOG.error(t.toString(), t);
            }
        }).start();
    }

    private List<RegionInfo> getSystemTables(ServerName serverName) {
        ServerStateNode serverNode = this.regionStates.getServerNode(serverName);
        if (serverNode == null) {
            return Collections.emptyList();
        }
        return serverNode.getSystemRegionInfoList();
    }

    private void preTransitCheck(RegionStateNode regionNode, RegionState.State[] expectedStates) throws HBaseIOException {
        if (regionNode.getProcedure() != null) {
            throw new HBaseIOException(regionNode + " is currently in transition; pid=" + regionNode.getProcedure().getProcId());
        }
        if (!regionNode.isInState(expectedStates)) {
            throw new DoNotRetryRegionException(UNEXPECTED_STATE_REGION + regionNode);
        }
        if (this.isTableDisabled(regionNode.getTable())) {
            throw new DoNotRetryIOException(regionNode.getTable() + " is disabled for " + regionNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransitRegionStateProcedure createAssignProcedure(RegionInfo regionInfo, ServerName sn, boolean override) throws IOException {
        RegionStateNode regionNode = this.regionStates.getOrCreateRegionStateNode(regionInfo);
        regionNode.lock();
        try {
            if (override) {
                if (regionNode.getProcedure() != null) {
                    regionNode.unsetProcedure(regionNode.getProcedure());
                }
            } else {
                this.preTransitCheck(regionNode, STATES_EXPECTED_ON_ASSIGN);
            }
            assert (regionNode.getProcedure() == null);
            TransitRegionStateProcedure transitRegionStateProcedure = regionNode.setProcedure(TransitRegionStateProcedure.assign(this.getProcedureEnvironment(), regionInfo, sn));
            return transitRegionStateProcedure;
        }
        finally {
            regionNode.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private TransitRegionStateProcedure createAssignProcedure(RegionStateNode regionNode, ServerName targetServer) {
        regionNode.lock();
        try {
            TransitRegionStateProcedure transitRegionStateProcedure = regionNode.setProcedure(TransitRegionStateProcedure.assign(this.getProcedureEnvironment(), regionNode.getRegionInfo(), targetServer));
            return transitRegionStateProcedure;
        }
        finally {
            regionNode.unlock();
        }
    }

    public long assign(RegionInfo regionInfo, ServerName sn) throws IOException {
        TransitRegionStateProcedure proc = this.createAssignProcedure(regionInfo, sn, false);
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), (Procedure<MasterProcedureEnv>)proc);
        return proc.getProcId();
    }

    public long assign(RegionInfo regionInfo) throws IOException {
        return this.assign(regionInfo, null);
    }

    public Future<byte[]> assignAsync(RegionInfo regionInfo, ServerName sn) throws IOException {
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), (Procedure<MasterProcedureEnv>)this.createAssignProcedure(regionInfo, sn, false));
    }

    public Future<byte[]> assignAsync(RegionInfo regionInfo) throws IOException {
        return this.assignAsync(regionInfo, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long unassign(RegionInfo regionInfo) throws IOException {
        TransitRegionStateProcedure proc;
        RegionStateNode regionNode = this.regionStates.getRegionStateNode(regionInfo);
        if (regionNode == null) {
            throw new UnknownRegionException("No RegionState found for " + regionInfo.getEncodedName());
        }
        regionNode.lock();
        try {
            this.preTransitCheck(regionNode, STATES_EXPECTED_ON_UNASSIGN_OR_MOVE);
            proc = TransitRegionStateProcedure.unassign(this.getProcedureEnvironment(), regionInfo);
            regionNode.setProcedure(proc);
        }
        finally {
            regionNode.unlock();
        }
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), (Procedure<MasterProcedureEnv>)proc);
        return proc.getProcId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransitRegionStateProcedure createMoveRegionProcedure(RegionInfo regionInfo, ServerName targetServer) throws HBaseIOException {
        TransitRegionStateProcedure proc;
        RegionStateNode regionNode = this.regionStates.getRegionStateNode(regionInfo);
        if (regionNode == null) {
            throw new UnknownRegionException("No RegionStateNode found for " + regionInfo.getEncodedName() + "(Closed/Deleted?)");
        }
        regionNode.lock();
        try {
            this.preTransitCheck(regionNode, STATES_EXPECTED_ON_UNASSIGN_OR_MOVE);
            regionNode.checkOnline();
            proc = TransitRegionStateProcedure.move(this.getProcedureEnvironment(), regionInfo, targetServer);
            regionNode.setProcedure(proc);
        }
        finally {
            regionNode.unlock();
        }
        return proc;
    }

    public void move(RegionInfo regionInfo) throws IOException {
        TransitRegionStateProcedure proc = this.createMoveRegionProcedure(regionInfo, null);
        ProcedureSyncWait.submitAndWaitProcedure(this.master.getMasterProcedureExecutor(), (Procedure<MasterProcedureEnv>)proc);
    }

    public Future<byte[]> moveAsync(RegionPlan regionPlan) throws HBaseIOException {
        TransitRegionStateProcedure proc = this.createMoveRegionProcedure(regionPlan.getRegionInfo(), regionPlan.getDestination());
        return ProcedureSyncWait.submitProcedure(this.master.getMasterProcedureExecutor(), (Procedure<MasterProcedureEnv>)proc);
    }

    public Future<byte[]> balance(RegionPlan regionPlan) throws HBaseIOException {
        ServerName current = this.getRegionStates().getRegionAssignments().get(regionPlan.getRegionInfo());
        if (!current.equals(regionPlan.getSource())) {
            LOG.debug("Skip region plan {}, source server not match, current region location is {}", (Object)regionPlan, (Object)current);
            return null;
        }
        return this.moveAsync(regionPlan);
    }

    public TransitRegionStateProcedure[] createRoundRobinAssignProcedures(List<RegionInfo> hris, List<ServerName> serversToExclude) {
        if (hris.isEmpty()) {
            return new TransitRegionStateProcedure[0];
        }
        if (serversToExclude != null && this.master.getServerManager().getOnlineServersList().size() == 1) {
            LOG.debug("Only one region server found and hence going ahead with the assignment");
            serversToExclude = null;
        }
        try {
            Map<ServerName, List<RegionInfo>> assignments = this.getBalancer().roundRobinAssignment(hris, this.master.getServerManager().createDestinationServersList(serversToExclude));
            return this.createAssignProcedures(assignments);
        }
        catch (HBaseIOException hioe) {
            LOG.warn("Failed roundRobinAssignment", (Throwable)hioe);
            return this.createAssignProcedures(hris);
        }
    }

    public TransitRegionStateProcedure[] createRoundRobinAssignProcedures(List<RegionInfo> hris) {
        return this.createRoundRobinAssignProcedures(hris, null);
    }

    static int compare(TransitRegionStateProcedure left, TransitRegionStateProcedure right) {
        if (left.getRegion().isMetaRegion()) {
            if (right.getRegion().isMetaRegion()) {
                return RegionInfo.COMPARATOR.compare(left.getRegion(), right.getRegion());
            }
            return -1;
        }
        if (right.getRegion().isMetaRegion()) {
            return 1;
        }
        if (left.getRegion().getTable().isSystemTable()) {
            if (right.getRegion().getTable().isSystemTable()) {
                return RegionInfo.COMPARATOR.compare(left.getRegion(), right.getRegion());
            }
            return -1;
        }
        if (right.getRegion().getTable().isSystemTable()) {
            return 1;
        }
        return RegionInfo.COMPARATOR.compare(left.getRegion(), right.getRegion());
    }

    public TransitRegionStateProcedure createOneAssignProcedure(RegionInfo ri, boolean override) {
        TransitRegionStateProcedure trsp = null;
        try {
            trsp = this.createAssignProcedure(ri, null, override);
        }
        catch (IOException ioe) {
            LOG.info("Failed {} assign, override={}" + (override ? DEFAULT_MIN_VERSION_MOVE_SYS_TABLES_CONFIG : "; set override to by-pass state checks."), new Object[]{ri.getEncodedName(), override, ioe});
        }
        return trsp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransitRegionStateProcedure createOneUnassignProcedure(RegionInfo ri, boolean override) {
        RegionStateNode regionNode = this.regionStates.getOrCreateRegionStateNode(ri);
        TransitRegionStateProcedure trsp = null;
        regionNode.lock();
        try {
            if (override) {
                if (regionNode.getProcedure() != null) {
                    regionNode.unsetProcedure(regionNode.getProcedure());
                }
            } else {
                this.preTransitCheck(regionNode, STATES_EXPECTED_ON_UNASSIGN_OR_MOVE);
            }
            assert (regionNode.getProcedure() == null);
            trsp = TransitRegionStateProcedure.unassign(this.getProcedureEnvironment(), regionNode.getRegionInfo());
            regionNode.setProcedure(trsp);
        }
        catch (IOException ioe) {
            LOG.info("Failed {} unassign, override=false; set override to by-pass state checks.", (Object)ri.getEncodedName(), (Object)ioe);
        }
        finally {
            regionNode.unlock();
        }
        return trsp;
    }

    public TransitRegionStateProcedure[] createAssignProcedures(List<RegionInfo> hris) {
        return (TransitRegionStateProcedure[])hris.stream().map(hri -> this.regionStates.getOrCreateRegionStateNode((RegionInfo)hri)).map(regionNode -> this.createAssignProcedure((RegionStateNode)regionNode, null)).sorted(AssignmentManager::compare).toArray(TransitRegionStateProcedure[]::new);
    }

    private TransitRegionStateProcedure[] createAssignProcedures(Map<ServerName, List<RegionInfo>> assignments) {
        return (TransitRegionStateProcedure[])assignments.entrySet().stream().flatMap(e -> ((List)e.getValue()).stream().map(hri -> this.regionStates.getOrCreateRegionStateNode((RegionInfo)hri)).map(regionNode -> this.createAssignProcedure((RegionStateNode)regionNode, (ServerName)e.getKey()))).sorted(AssignmentManager::compare).toArray(TransitRegionStateProcedure[]::new);
    }

    private TransitRegionStateProcedure forceCreateUnssignProcedure(RegionStateNode regionNode) {
        regionNode.lock();
        try {
            if (regionNode.isInState(RegionState.State.OFFLINE, RegionState.State.CLOSED, RegionState.State.SPLIT)) {
                TransitRegionStateProcedure transitRegionStateProcedure = null;
                return transitRegionStateProcedure;
            }
            if (regionNode.getRegionInfo().isSplit()) {
                LOG.warn("{} is a split parent but not in CLOSED or SPLIT state", (Object)regionNode);
                TransitRegionStateProcedure transitRegionStateProcedure = null;
                return transitRegionStateProcedure;
            }
            if (regionNode.getProcedure() != null) {
                regionNode.unsetProcedure(regionNode.getProcedure());
            }
            TransitRegionStateProcedure transitRegionStateProcedure = regionNode.setProcedure(TransitRegionStateProcedure.unassign(this.getProcedureEnvironment(), regionNode.getRegionInfo()));
            return transitRegionStateProcedure;
        }
        finally {
            regionNode.unlock();
        }
    }

    public TransitRegionStateProcedure[] createUnassignProceduresForDisabling(TableName tableName) {
        return (TransitRegionStateProcedure[])this.regionStates.getTableRegionStateNodes(tableName).stream().map(this::forceCreateUnssignProcedure).filter(p -> p != null).toArray(TransitRegionStateProcedure[]::new);
    }

    public TransitRegionStateProcedure[] createUnassignProceduresForClosingExcessRegionReplicas(TableName tableName, int newReplicaCount) {
        return (TransitRegionStateProcedure[])this.regionStates.getTableRegionStateNodes(tableName).stream().filter(regionNode -> regionNode.getRegionInfo().getReplicaId() >= newReplicaCount).map(this::forceCreateUnssignProcedure).filter(p -> p != null).toArray(TransitRegionStateProcedure[]::new);
    }

    public SplitTableRegionProcedure createSplitProcedure(RegionInfo regionToSplit, byte[] splitKey) throws IOException {
        return new SplitTableRegionProcedure(this.getProcedureEnvironment(), regionToSplit, splitKey);
    }

    public MergeTableRegionsProcedure createMergeProcedure(RegionInfo ... ris) throws IOException {
        return new MergeTableRegionsProcedure(this.getProcedureEnvironment(), ris, false);
    }

    public void deleteTable(TableName tableName) throws IOException {
        ArrayList<RegionInfo> regions = this.regionStates.getTableRegionsInfo(tableName);
        this.regionStateStore.deleteRegions(regions);
        for (int i = 0; i < regions.size(); ++i) {
            RegionInfo regionInfo = regions.get(i);
            this.regionStates.removeFromOfflineRegions(regionInfo);
            this.regionStates.deleteRegion(regionInfo);
        }
    }

    private void reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionResponse.Builder builder, ServerName serverName, List<RegionServerStatusProtos.RegionStateTransition> transitionList) throws IOException {
        for (RegionServerStatusProtos.RegionStateTransition transition : transitionList) {
            switch (transition.getTransitionCode()) {
                case OPENED: 
                case FAILED_OPEN: 
                case CLOSED: {
                    assert (transition.getRegionInfoCount() == 1) : transition;
                    RegionInfo hri = ProtobufUtil.toRegionInfo(transition.getRegionInfo(0));
                    long procId = transition.getProcIdCount() > 0 ? transition.getProcId(0) : -1L;
                    this.updateRegionTransition(serverName, transition.getTransitionCode(), hri, transition.hasOpenSeqNum() ? transition.getOpenSeqNum() : -1L, procId);
                    break;
                }
                case READY_TO_SPLIT: 
                case SPLIT: 
                case SPLIT_REVERTED: {
                    assert (transition.getRegionInfoCount() == 3) : transition;
                    RegionInfo parent = ProtobufUtil.toRegionInfo(transition.getRegionInfo(0));
                    RegionInfo splitA = ProtobufUtil.toRegionInfo(transition.getRegionInfo(1));
                    RegionInfo splitB = ProtobufUtil.toRegionInfo(transition.getRegionInfo(2));
                    this.updateRegionSplitTransition(serverName, transition.getTransitionCode(), parent, splitA, splitB);
                    break;
                }
                case READY_TO_MERGE: 
                case MERGED: 
                case MERGE_REVERTED: {
                    assert (transition.getRegionInfoCount() == 3) : transition;
                    RegionInfo merged = ProtobufUtil.toRegionInfo(transition.getRegionInfo(0));
                    RegionInfo mergeA = ProtobufUtil.toRegionInfo(transition.getRegionInfo(1));
                    RegionInfo mergeB = ProtobufUtil.toRegionInfo(transition.getRegionInfo(2));
                    this.updateRegionMergeTransition(serverName, transition.getTransitionCode(), merged, mergeA, mergeB);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RegionServerStatusProtos.ReportRegionStateTransitionResponse reportRegionStateTransition(RegionServerStatusProtos.ReportRegionStateTransitionRequest req) throws PleaseHoldException {
        RegionServerStatusProtos.ReportRegionStateTransitionResponse.Builder builder;
        block7: {
            builder = RegionServerStatusProtos.ReportRegionStateTransitionResponse.newBuilder();
            ServerName serverName = ProtobufUtil.toServerName(req.getServer());
            ServerStateNode serverNode = this.regionStates.getOrCreateServer(serverName);
            serverNode.readLock().lock();
            try {
                if (serverNode.isInState(ServerState.ONLINE)) {
                    try {
                        this.reportRegionStateTransition(builder, serverName, req.getTransitionList());
                        break block7;
                    }
                    catch (PleaseHoldException e) {
                        LOG.trace("Failed transition ", (Throwable)e);
                        throw e;
                    }
                    catch (IOException | UnsupportedOperationException e) {
                        LOG.warn("Failed transition", (Throwable)e);
                        builder.setErrorMessage("Failed transition " + e.getMessage());
                        break block7;
                    }
                }
                LOG.warn("The region server {} is already dead, skip reportRegionStateTransition call", (Object)serverName);
                builder.setErrorMessage("You are dead");
            }
            finally {
                serverNode.readLock().unlock();
            }
        }
        return builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRegionTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo regionInfo, long seqId, long procId) throws IOException {
        this.checkMetaLoaded(regionInfo);
        RegionStateNode regionNode = this.regionStates.getRegionStateNode(regionInfo);
        if (regionNode == null) {
            throw new UnexpectedStateException(String.format("Server %s was trying to transition region %s to %s. but Region is not known.", serverName, regionInfo, state));
        }
        LOG.trace("Update region transition serverName={} region={} regionState={}", new Object[]{serverName, regionNode, state});
        ServerStateNode serverNode = this.regionStates.getOrCreateServer(serverName);
        regionNode.lock();
        try {
            if (!this.reportTransition(regionNode, serverNode, state, seqId, procId)) {
                if (this.master.getServerManager().isClusterShutdown() && state.equals(RegionServerStatusProtos.RegionStateTransition.TransitionCode.CLOSED)) {
                    LOG.info("RegionServer {} {}", (Object)state, (Object)regionNode.getRegionInfo().getEncodedName());
                } else {
                    LOG.warn("No matching procedure found for {} transition on {} to {}", new Object[]{serverName, regionNode, state});
                }
            }
        }
        finally {
            regionNode.unlock();
        }
    }

    private boolean reportTransition(RegionStateNode regionNode, ServerStateNode serverNode, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, long seqId, long procId) throws IOException {
        ServerName serverName = serverNode.getServerName();
        TransitRegionStateProcedure proc = regionNode.getProcedure();
        if (proc == null) {
            return false;
        }
        proc.reportTransition((MasterProcedureEnv)this.master.getMasterProcedureExecutor().getEnvironment(), regionNode, serverName, state, seqId, procId);
        return true;
    }

    private void updateRegionSplitTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo parent, RegionInfo hriA, RegionInfo hriB) throws IOException {
        RegionState parentState;
        this.checkMetaLoaded(parent);
        if (state != RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_SPLIT) {
            throw new UnexpectedStateException("unsupported split regionState=" + state + " for parent region " + parent + " maybe an old RS (< 2.0) had the operation in progress");
        }
        if (!Bytes.equals(hriA.getEndKey(), hriB.getStartKey())) {
            throw new UnsupportedOperationException("unsupported split request with bad keys: parent=" + parent + " hriA=" + hriA + " hriB=" + hriB);
        }
        if (!this.master.isSplitOrMergeEnabled(MasterSwitchType.SPLIT)) {
            LOG.warn("Split switch is off! skip split of " + parent);
            throw new DoNotRetryIOException("Split region " + parent.getRegionNameAsString() + " failed due to split switch off");
        }
        byte[] splitKey = hriB.getStartKey();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Split request from " + serverName + ", parent=" + parent + " splitKey=" + Bytes.toStringBinary(splitKey));
        }
        if ((parentState = this.regionStates.getRegionState(parent)) == null || !parentState.isOpened()) {
            LOG.info("Ignoring split request from " + serverName + ", parent=" + parent + " because parent is unknown or not open");
            return;
        }
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.createSplitProcedure(parent, splitKey));
        if (this.master.getServerManager().getVersionNumber(serverName) < 0x200000) {
            throw new UnsupportedOperationException(String.format("Split handled by the master: parent=%s hriA=%s hriB=%s", parent.getShortNameToLog(), hriA, hriB));
        }
    }

    private void updateRegionMergeTransition(ServerName serverName, RegionServerStatusProtos.RegionStateTransition.TransitionCode state, RegionInfo merged, RegionInfo hriA, RegionInfo hriB) throws IOException {
        this.checkMetaLoaded(merged);
        if (state != RegionServerStatusProtos.RegionStateTransition.TransitionCode.READY_TO_MERGE) {
            throw new UnexpectedStateException("Unsupported merge regionState=" + state + " for regionA=" + hriA + " regionB=" + hriB + " merged=" + merged + " maybe an old RS (< 2.0) had the operation in progress");
        }
        if (!this.master.isSplitOrMergeEnabled(MasterSwitchType.MERGE)) {
            LOG.warn("Merge switch is off! skip merge of regionA=" + hriA + " regionB=" + hriB);
            throw new DoNotRetryIOException("Merge of regionA=" + hriA + " regionB=" + hriB + " failed because merge switch is off");
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Handling merge request from RS=" + merged + ", merged=" + merged);
        }
        this.master.getMasterProcedureExecutor().submitProcedure((Procedure)this.createMergeProcedure(hriA, hriB));
        if (this.master.getServerManager().getVersionNumber(serverName) < 0x200000) {
            throw new UnsupportedOperationException(String.format("Merge not handled yet: regionState=%s merged=%s hriA=%s hriB=%s", state, merged, hriA, hriB));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reportOnlineRegions(ServerName serverName, Set<byte[]> regionNames) {
        if (!this.isRunning()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("ReportOnlineRegions {} regionCount={}, metaLoaded={} {}", new Object[]{serverName, regionNames.size(), this.isMetaLoaded(), regionNames.stream().map(Bytes::toStringBinary).collect(Collectors.toList())});
        }
        ServerStateNode serverNode = this.regionStates.getOrCreateServer(serverName);
        Object object = serverNode;
        synchronized (object) {
            if (!serverNode.isInState(ServerState.ONLINE)) {
                LOG.warn("Got a report from a server result in state " + (Object)((Object)serverNode.getState()));
                return;
            }
        }
        object = this.rsReports;
        synchronized (object) {
            this.rsReports.put(serverName, regionNames);
        }
        if (regionNames.isEmpty()) {
            LOG.trace("no online region found on {}", (Object)serverName);
            return;
        }
        if (!this.isMetaLoaded()) {
            return;
        }
        this.checkOnlineRegionsReport(serverNode, regionNames);
    }

    private void closeRegionSilently(ServerName sn, byte[] regionName) {
        try {
            RegionInfo ri = MetaTableAccessor.parseRegionInfoFromRegionName(regionName);
            ServerManager.closeRegionSilentlyAndWait(this.master.getClusterConnection(), sn, ri, -1L);
        }
        catch (Exception e) {
            LOG.error("Failed trying to close {} on {}", new Object[]{Bytes.toStringBinary(regionName), sn, e});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkOnlineRegionsReport(ServerStateNode serverNode, Set<byte[]> regionNames) {
        ServerName serverName = serverNode.getServerName();
        for (byte[] regionName : regionNames) {
            if (!this.isRunning()) {
                return;
            }
            RegionStateNode regionNode = this.regionStates.getRegionStateNodeFromName(regionName);
            if (regionNode == null) {
                String regionNameAsStr = Bytes.toStringBinary(regionName);
                LOG.warn("No RegionStateNode for {} but reported as up on {}; closing...", (Object)regionNameAsStr, (Object)serverName);
                this.closeRegionSilently(serverNode.getServerName(), regionName);
                continue;
            }
            long lag = 1000L;
            regionNode.lock();
            try {
                long diff = EnvironmentEdgeManager.currentTime() - regionNode.getLastUpdate();
                if (regionNode.isInState(RegionState.State.OPENING, RegionState.State.OPEN)) {
                    if (regionNode.getRegionLocation().equals(serverName) || diff <= 1000L) continue;
                    LOG.warn("Reporting {} server does not match {} (time since last update={}ms); closing...", new Object[]{serverName, regionNode, diff});
                    this.closeRegionSilently(serverNode.getServerName(), regionName);
                    continue;
                }
                if (regionNode.isInState(RegionState.State.CLOSING, RegionState.State.SPLITTING) || diff <= 1000L) continue;
                LOG.warn("Reporting {} state does not match {} (time since last update={}ms)", new Object[]{serverName, regionNode, diff});
            }
            finally {
                regionNode.unlock();
            }
        }
    }

    public RegionInTransitionStat computeRegionInTransitionStat() {
        RegionInTransitionStat rit = new RegionInTransitionStat(this.getConfiguration());
        rit.update(this);
        return rit;
    }

    private void updateRegionsInTransitionMetrics(RegionInTransitionStat ritStat) {
        this.metrics.updateRITOldestAge(ritStat.getOldestRITTime());
        this.metrics.updateRITCount(ritStat.getTotalRITs());
        this.metrics.updateRITCountOverThreshold(ritStat.getTotalRITsOverThreshold());
    }

    private void updateDeadServerRegionMetrics(int deadRegions, int unknownRegions) {
        this.metrics.updateDeadServerOpenRegions(deadRegions);
        this.metrics.updateUnknownServerOpenRegions(unknownRegions);
    }

    private void handleRegionOverStuckWarningThreshold(RegionInfo regionInfo) {
        RegionStateNode regionNode = this.regionStates.getRegionStateNode(regionInfo);
        LOG.warn("STUCK Region-In-Transition {}", (Object)regionNode);
    }

    public void joinCluster() throws IOException {
        long startTime = System.nanoTime();
        LOG.debug("Joining cluster...");
        this.loadMeta();
        while (this.master.getServerManager().countOfRegionServers() < 1) {
            LOG.info("Waiting for RegionServers to join; current count={}", (Object)this.master.getServerManager().countOfRegionServers());
            Threads.sleep(250L);
        }
        LOG.info("Number of RegionServers={}", (Object)this.master.getServerManager().countOfRegionServers());
        this.master.getMasterProcedureExecutor().addChore((ProcedureInMemoryChore)this.ritChore);
        this.master.getMasterProcedureExecutor().addChore((ProcedureInMemoryChore)this.deadMetricChore);
        long costMs = TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - startTime);
        LOG.info("Joined the cluster in {}", (Object)StringUtils.humanTimeDiff((long)costMs));
    }

    public void processOfflineRegions() {
        TransitRegionStateProcedure[] procs = (TransitRegionStateProcedure[])this.regionStates.getRegionStateNodes().stream().filter(rsn -> rsn.isInState(RegionState.State.OFFLINE)).filter(rsn -> this.isTableEnabled(rsn.getRegionInfo().getTable())).map(rsn -> {
            rsn.lock();
            try {
                if (rsn.getProcedure() != null) {
                    TransitRegionStateProcedure transitRegionStateProcedure = null;
                    return transitRegionStateProcedure;
                }
                TransitRegionStateProcedure transitRegionStateProcedure = rsn.setProcedure(TransitRegionStateProcedure.assign(this.getProcedureEnvironment(), rsn.getRegionInfo(), null));
                return transitRegionStateProcedure;
            }
            finally {
                rsn.unlock();
            }
        }).filter(p -> p != null).toArray(TransitRegionStateProcedure[]::new);
        if (procs.length > 0) {
            this.master.getMasterProcedureExecutor().submitProcedures((Procedure[])procs);
        }
    }

    public RegionInfo loadRegionFromMeta(String regionEncodedName) throws UnknownRegionException {
        try {
            RegionMetaLoadingVisitor visitor = new RegionMetaLoadingVisitor();
            this.regionStateStore.visitMetaForRegion(regionEncodedName, visitor);
            return this.regionStates.getRegionState(regionEncodedName) == null ? null : this.regionStates.getRegionState(regionEncodedName).getRegion();
        }
        catch (IOException e) {
            throw new UnknownRegionException("Error trying to load region " + regionEncodedName + " from META", e);
        }
    }

    private void loadMeta() throws IOException {
        this.regionStateStore.visitMeta(new RegionMetaLoadingVisitor());
    }

    private void checkMetaLoaded(RegionInfo hri) throws PleaseHoldException {
        if (!this.isRunning()) {
            throw new PleaseHoldException("AssignmentManager not running");
        }
        boolean meta = this.isMetaRegion(hri);
        boolean metaLoaded = this.isMetaLoaded();
        if (!meta && !metaLoaded) {
            throw new PleaseHoldException("Master not fully online; hbase:meta=" + meta + ", metaLoaded=" + metaLoaded);
        }
    }

    public int getNumRegionsOpened() {
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long submitServerCrash(ServerName serverName, boolean shouldSplitWal, boolean force) {
        long pid;
        ServerStateNode serverNode = this.regionStates.getServerNode(serverName);
        Map<ServerName, Set<byte[]>> map = this.rsReports;
        synchronized (map) {
            this.rsReports.remove(serverName);
        }
        if (serverNode != null) {
            serverNode.writeLock().lock();
        }
        try {
            ProcedureExecutor<MasterProcedureEnv> procExec = this.master.getMasterProcedureExecutor();
            boolean carryingMeta = this.isCarryingMeta(serverName);
            if (!force && serverNode != null && !serverNode.isInState(ServerState.ONLINE)) {
                LOG.info("Skip adding ServerCrashProcedure for {} (meta={}) -- running?", (Object)serverNode, (Object)carryingMeta);
                long l = -1L;
                return l;
            }
            MasterProcedureEnv mpe = (MasterProcedureEnv)procExec.getEnvironment();
            ServerState oldState = null;
            if (serverNode != null) {
                oldState = serverNode.getState();
                serverNode.setState(ServerState.CRASHED);
            }
            pid = force ? procExec.submitProcedure((Procedure)new HBCKServerCrashProcedure(mpe, serverName, shouldSplitWal, carryingMeta)) : procExec.submitProcedure((Procedure)new ServerCrashProcedure(mpe, serverName, shouldSplitWal, carryingMeta));
            LOG.info("Scheduled ServerCrashProcedure pid={} for {} (carryingMeta={}){}.", new Object[]{pid, serverName, carryingMeta, serverNode == null ? DEFAULT_MIN_VERSION_MOVE_SYS_TABLES_CONFIG : " " + serverNode.toString() + ", oldState=" + (Object)((Object)oldState)});
        }
        finally {
            if (serverNode != null) {
                serverNode.writeLock().unlock();
            }
        }
        return pid;
    }

    public void offlineRegion(RegionInfo regionInfo) {
        RegionStateNode node = this.regionStates.getRegionStateNode(regionInfo);
        if (node != null) {
            node.offline();
        }
    }

    public void onlineRegion(RegionInfo regionInfo, ServerName serverName) {
    }

    public Map<ServerName, List<RegionInfo>> getSnapShotOfAssignment(Collection<RegionInfo> regions) {
        return this.regionStates.getSnapShotOfAssignment(regions);
    }

    public Pair<Integer, Integer> getReopenStatus(TableName tableName) {
        if (this.isTableDisabled(tableName)) {
            return new Pair<Integer, Integer>(0, 0);
        }
        ArrayList<RegionState> states = this.regionStates.getTableRegionStates(tableName);
        int ritCount = 0;
        for (RegionState regionState : states) {
            if (regionState.isOpened() || regionState.isSplit()) continue;
            ++ritCount;
        }
        return new Pair<Integer, Integer>(ritCount, states.size());
    }

    public boolean hasRegionsInTransition() {
        return this.regionStates.hasRegionsInTransition();
    }

    public List<RegionStateNode> getRegionsInTransition() {
        return this.regionStates.getRegionsInTransition();
    }

    public List<RegionInfo> getAssignedRegions() {
        return this.regionStates.getAssignedRegions();
    }

    public RegionInfo getRegionInfo(byte[] regionName) {
        RegionStateNode regionState = this.regionStates.getRegionStateNodeFromName(regionName);
        return regionState != null ? regionState.getRegionInfo() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void transitStateAndUpdate(RegionStateNode regionNode, RegionState.State newState, RegionState.State ... expectedStates) throws IOException {
        RegionState.State state = regionNode.getState();
        regionNode.transitionState(newState, expectedStates);
        boolean succ = false;
        try {
            this.regionStateStore.updateRegionLocation(regionNode);
            succ = true;
        }
        finally {
            if (!succ) {
                regionNode.setState(state, new RegionState.State[0]);
            }
        }
    }

    void regionOpening(RegionStateNode regionNode) throws IOException {
        this.transitStateAndUpdate(regionNode, RegionState.State.OPENING, new RegionState.State[0]);
        this.regionStates.addRegionToServer(regionNode);
        this.metrics.incrementOperationCounter();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void regionFailedOpen(RegionStateNode regionNode, boolean giveUp) throws IOException {
        RegionState.State state = regionNode.getState();
        ServerName regionLocation = regionNode.getRegionLocation();
        if (giveUp) {
            regionNode.setState(RegionState.State.FAILED_OPEN, new RegionState.State[0]);
            regionNode.setRegionLocation(null);
            boolean succ = false;
            try {
                this.regionStateStore.updateRegionLocation(regionNode);
                succ = true;
            }
            finally {
                if (!succ) {
                    regionNode.setState(state, new RegionState.State[0]);
                    regionNode.setRegionLocation(regionLocation);
                }
            }
        }
        if (regionLocation != null) {
            this.regionStates.removeRegionFromServer(regionLocation, regionNode);
        }
    }

    void regionClosing(RegionStateNode regionNode) throws IOException {
        this.transitStateAndUpdate(regionNode, RegionState.State.CLOSING, STATES_EXPECTED_ON_CLOSING);
        RegionInfo hri = regionNode.getRegionInfo();
        if (this.isMetaRegion(hri)) {
            this.setMetaAssigned(hri, false);
        }
        this.regionStates.addRegionToServer(regionNode);
        this.metrics.incrementOperationCounter();
    }

    void regionOpenedWithoutPersistingToMeta(RegionStateNode regionNode) throws IOException {
        regionNode.transitionState(RegionState.State.OPEN, STATES_EXPECTED_ON_OPEN);
        RegionInfo regionInfo = regionNode.getRegionInfo();
        this.regionStates.addRegionToServer(regionNode);
        this.regionStates.removeFromFailedOpen(regionInfo);
    }

    void regionClosedWithoutPersistingToMeta(RegionStateNode regionNode) throws IOException {
        ServerName regionLocation = regionNode.getRegionLocation();
        regionNode.transitionState(RegionState.State.CLOSED, STATES_EXPECTED_ON_CLOSED);
        regionNode.setRegionLocation(null);
        if (regionLocation != null) {
            regionNode.setLastHost(regionLocation);
            this.regionStates.removeRegionFromServer(regionLocation, regionNode);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void regionClosedAbnormally(RegionStateNode regionNode) throws IOException {
        RegionState.State state = regionNode.getState();
        ServerName regionLocation = regionNode.getRegionLocation();
        regionNode.transitionState(RegionState.State.ABNORMALLY_CLOSED, new RegionState.State[0]);
        regionNode.setRegionLocation(null);
        boolean succ = false;
        try {
            this.regionStateStore.updateRegionLocation(regionNode);
            succ = true;
        }
        finally {
            if (!succ) {
                regionNode.setState(state, new RegionState.State[0]);
                regionNode.setRegionLocation(regionLocation);
            }
        }
        if (regionLocation != null) {
            regionNode.setLastHost(regionLocation);
            this.regionStates.removeRegionFromServer(regionLocation, regionNode);
        }
    }

    void persistToMeta(RegionStateNode regionNode) throws IOException {
        this.regionStateStore.updateRegionLocation(regionNode);
        RegionInfo regionInfo = regionNode.getRegionInfo();
        if (this.isMetaRegion(regionInfo) && regionNode.getState() == RegionState.State.OPEN) {
            this.setMetaAssigned(regionInfo, true);
        }
    }

    public void markRegionAsSplit(RegionInfo parent, ServerName serverName, RegionInfo daughterA, RegionInfo daughterB) throws IOException {
        RegionStateNode node = this.regionStates.getOrCreateRegionStateNode(parent);
        node.setState(RegionState.State.SPLIT, new RegionState.State[0]);
        RegionStateNode nodeA = this.regionStates.getOrCreateRegionStateNode(daughterA);
        nodeA.setState(RegionState.State.SPLITTING_NEW, new RegionState.State[0]);
        RegionStateNode nodeB = this.regionStates.getOrCreateRegionStateNode(daughterB);
        nodeB.setState(RegionState.State.SPLITTING_NEW, new RegionState.State[0]);
        this.regionStateStore.splitRegion(parent, daughterA, daughterB, serverName);
        if (this.shouldAssignFavoredNodes(parent)) {
            List<ServerName> onlineServers = this.master.getServerManager().getOnlineServersList();
            ((FavoredNodesPromoter)((Object)this.getBalancer())).generateFavoredNodesForDaughter(onlineServers, parent, daughterA, daughterB);
        }
    }

    public void markRegionAsMerged(RegionInfo child, ServerName serverName, RegionInfo[] mergeParents) throws IOException {
        RegionStateNode node = this.regionStates.getOrCreateRegionStateNode(child);
        node.setState(RegionState.State.MERGED, new RegionState.State[0]);
        for (RegionInfo ri : mergeParents) {
            this.regionStates.deleteRegion(ri);
        }
        this.regionStateStore.mergeRegions(child, mergeParents, serverName);
        if (this.shouldAssignFavoredNodes(child)) {
            ((FavoredNodesPromoter)((Object)this.getBalancer())).generateFavoredNodesForMergedRegion(child, mergeParents);
        }
    }

    private boolean shouldAssignFavoredNodes(RegionInfo region) {
        return this.shouldAssignRegionsWithFavoredNodes && FavoredNodesManager.isFavoredNodeApplicable(region);
    }

    protected void queueAssign(RegionStateNode regionNode) {
        regionNode.getProcedureEvent().suspend();
        this.assignQueueLock.lock();
        try {
            this.pendingAssignQueue.add(regionNode);
            if (regionNode.isSystemTable() || this.pendingAssignQueue.size() == 1 || this.pendingAssignQueue.size() >= this.assignDispatchWaitQueueMaxSize) {
                this.assignQueueFullCond.signal();
            }
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    private void startAssignmentThread() {
        this.assignThread = new Thread(this.master.getServerName().toShortString()){

            @Override
            public void run() {
                while (AssignmentManager.this.isRunning()) {
                    AssignmentManager.this.processAssignQueue();
                }
                AssignmentManager.this.pendingAssignQueue.clear();
            }
        };
        this.assignThread.setDaemon(true);
        this.assignThread.start();
    }

    private void stopAssignmentThread() {
        this.assignQueueSignal();
        try {
            while (this.assignThread.isAlive()) {
                this.assignQueueSignal();
                this.assignThread.join(250L);
            }
        }
        catch (InterruptedException e) {
            LOG.warn("join interrupted", (Throwable)e);
            Thread.currentThread().interrupt();
        }
    }

    private void assignQueueSignal() {
        this.assignQueueLock.lock();
        try {
            this.assignQueueFullCond.signal();
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SuppressWarnings(value={"WA_AWAIT_NOT_IN_LOOP"})
    private HashMap<RegionInfo, RegionStateNode> waitOnAssignQueue() {
        HashMap<RegionInfo, RegionStateNode> regions = null;
        this.assignQueueLock.lock();
        try {
            if (this.pendingAssignQueue.isEmpty() && this.isRunning()) {
                this.assignQueueFullCond.await();
            }
            if (!this.isRunning()) {
                HashMap<RegionInfo, RegionStateNode> hashMap = null;
                return hashMap;
            }
            this.assignQueueFullCond.await(this.assignDispatchWaitMillis, TimeUnit.MILLISECONDS);
            regions = new HashMap<RegionInfo, RegionStateNode>(this.pendingAssignQueue.size());
            for (RegionStateNode regionNode : this.pendingAssignQueue) {
                regions.put(regionNode.getRegionInfo(), regionNode);
            }
            this.pendingAssignQueue.clear();
        }
        catch (InterruptedException e) {
            LOG.warn("got interrupted ", (Throwable)e);
            Thread.currentThread().interrupt();
        }
        finally {
            this.assignQueueLock.unlock();
        }
        return regions;
    }

    private void processAssignQueue() {
        HashMap<RegionInfo, RegionStateNode> regions = this.waitOnAssignQueue();
        if (regions == null || regions.size() == 0 || !this.isRunning()) {
            return;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("PROCESS ASSIGN QUEUE regionCount=" + regions.size());
        }
        HashMap<RegionInfo, ServerName> retainMap = new HashMap<RegionInfo, ServerName>();
        ArrayList<RegionInfo> userHRIs = new ArrayList<RegionInfo>(regions.size());
        ArrayList<RegionInfo> systemHRIs = new ArrayList<RegionInfo>();
        for (RegionStateNode regionStateNode : regions.values()) {
            ArrayList<RegionInfo> hris;
            boolean sysTable = regionStateNode.isSystemTable();
            ArrayList<RegionInfo> arrayList = hris = sysTable ? systemHRIs : userHRIs;
            if (regionStateNode.getRegionLocation() != null) {
                retainMap.put(regionStateNode.getRegionInfo(), regionStateNode.getRegionLocation());
                continue;
            }
            hris.add(regionStateNode.getRegionInfo());
        }
        List<ServerName> servers = this.master.getServerManager().createDestinationServersList();
        int i = 0;
        while (servers.size() < 1) {
            if (i % 4 == 0) {
                LOG.warn("No servers available; cannot place " + regions.size() + " unassigned regions.");
            }
            if (!this.isRunning()) {
                LOG.debug("Stopped! Dropping assign of " + regions.size() + " queued regions.");
                return;
            }
            Threads.sleep(250L);
            servers = this.master.getServerManager().createDestinationServersList();
            ++i;
        }
        if (!systemHRIs.isEmpty()) {
            List<ServerName> excludeServers = this.getExcludedServersForSystemTable();
            List<ServerName> serversForSysTables = servers.stream().filter(s -> !excludeServers.contains(s)).collect(Collectors.toList());
            if (serversForSysTables.isEmpty()) {
                LOG.warn("Filtering old server versions and the excluded produced an empty set; instead considering all candidate servers!");
            }
            LOG.debug("Processing assignQueue; systemServersCount=" + serversForSysTables.size() + ", allServersCount=" + servers.size());
            this.processAssignmentPlans(regions, null, systemHRIs, serversForSysTables.isEmpty() && !this.containsBogusAssignments(regions, systemHRIs) ? servers : serversForSysTables);
        }
        this.processAssignmentPlans(regions, retainMap, userHRIs, servers);
    }

    private boolean containsBogusAssignments(Map<RegionInfo, RegionStateNode> regions, List<RegionInfo> hirs) {
        for (RegionInfo ri : hirs) {
            if (regions.get(ri).getRegionLocation() == null || !regions.get(ri).getRegionLocation().equals(LoadBalancer.BOGUS_SERVER_NAME)) continue;
            return true;
        }
        return false;
    }

    private void processAssignmentPlans(HashMap<RegionInfo, RegionStateNode> regions, HashMap<RegionInfo, ServerName> retainMap, List<RegionInfo> hris, List<ServerName> servers) {
        boolean isTraceEnabled = LOG.isTraceEnabled();
        if (isTraceEnabled) {
            LOG.trace("Available servers count=" + servers.size() + ": " + servers);
        }
        LoadBalancer balancer = this.getBalancer();
        if (retainMap != null && !retainMap.isEmpty()) {
            if (isTraceEnabled) {
                LOG.trace("retain assign regions=" + retainMap);
            }
            try {
                this.acceptPlan(regions, balancer.retainAssignment(retainMap, servers));
            }
            catch (HBaseIOException e) {
                LOG.warn("unable to retain assignment", (Throwable)e);
                this.addToPendingAssignment(regions, retainMap.keySet());
            }
        }
        if (!hris.isEmpty()) {
            Collections.sort(hris, RegionInfo.COMPARATOR);
            if (isTraceEnabled) {
                LOG.trace("round robin regions=" + hris);
            }
            try {
                this.acceptPlan(regions, balancer.roundRobinAssignment(hris, servers));
            }
            catch (HBaseIOException e) {
                LOG.warn("unable to round-robin assignment", (Throwable)e);
                this.addToPendingAssignment(regions, hris);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void acceptPlan(HashMap<RegionInfo, RegionStateNode> regions, Map<ServerName, List<RegionInfo>> plan) throws HBaseIOException {
        ProcedureEvent[] events = new ProcedureEvent[regions.size()];
        long st = System.currentTimeMillis();
        if (plan.isEmpty()) {
            throw new HBaseIOException("unable to compute plans for regions=" + regions.size());
        }
        int evcount = 0;
        for (Map.Entry<ServerName, List<RegionInfo>> entry : plan.entrySet()) {
            ServerName server = entry.getKey();
            for (RegionInfo hri : entry.getValue()) {
                RegionStateNode regionNode = regions.get(hri);
                regionNode.setRegionLocation(server);
                if (server.equals(LoadBalancer.BOGUS_SERVER_NAME) && regionNode.isSystemTable()) {
                    this.assignQueueLock.lock();
                    try {
                        this.pendingAssignQueue.add(regionNode);
                        continue;
                    }
                    finally {
                        this.assignQueueLock.unlock();
                        continue;
                    }
                }
                events[evcount++] = regionNode.getProcedureEvent();
            }
        }
        ProcedureEvent.wakeEvents((AbstractProcedureScheduler)this.getProcedureScheduler(), (ProcedureEvent[])events);
        long et = System.currentTimeMillis();
        if (LOG.isTraceEnabled()) {
            LOG.trace("ASSIGN ACCEPT " + events.length + " -> " + StringUtils.humanTimeDiff((long)(et - st)));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addToPendingAssignment(HashMap<RegionInfo, RegionStateNode> regions, Collection<RegionInfo> pendingRegions) {
        this.assignQueueLock.lock();
        try {
            for (RegionInfo hri : pendingRegions) {
                this.pendingAssignQueue.add(regions.get(hri));
            }
        }
        finally {
            this.assignQueueLock.unlock();
        }
    }

    public List<ServerName> getExcludedServersForSystemTable() {
        int comparedValue;
        List serverList = this.master.getServerManager().getOnlineServersList().stream().map(s -> new Pair<ServerName, String>((ServerName)s, this.master.getRegionServerVersion((ServerName)s))).collect(Collectors.toList());
        if (serverList.isEmpty()) {
            return new ArrayList<ServerName>();
        }
        String highestVersion = (String)((Pair)Collections.max(serverList, (o1, o2) -> VersionInfo.compareVersion((String)o1.getSecond(), (String)o2.getSecond()))).getSecond();
        if (!DEFAULT_MIN_VERSION_MOVE_SYS_TABLES_CONFIG.equals(this.minVersionToMoveSysTables) && (comparedValue = VersionInfo.compareVersion(this.minVersionToMoveSysTables, highestVersion)) > 0) {
            return new ArrayList<ServerName>();
        }
        return serverList.stream().filter(pair -> !((String)pair.getSecond()).equals(highestVersion)).map(Pair::getFirst).collect(Collectors.toList());
    }

    MasterServices getMaster() {
        return this.master;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<ServerName, Set<byte[]>> getRSReports() {
        HashMap<ServerName, Set<byte[]>> rsReportsSnapshot = new HashMap<ServerName, Set<byte[]>>();
        Map<ServerName, Set<byte[]>> map = this.rsReports;
        synchronized (map) {
            this.rsReports.entrySet().forEach(e -> {
                Set cfr_ignored_0 = (Set)rsReportsSnapshot.put((ServerName)e.getKey(), (Set<byte[]>)e.getValue());
            });
        }
        return rsReportsSnapshot;
    }

    public RegionStatesCount getRegionStatesCount(TableName tableName) {
        int openRegionsCount = 0;
        int closedRegionCount = 0;
        int ritCount = 0;
        int splitRegionCount = 0;
        int totalRegionCount = 0;
        if (!this.isTableDisabled(tableName)) {
            ArrayList<RegionState> states = this.regionStates.getTableRegionStates(tableName);
            for (RegionState regionState : states) {
                if (regionState.isOpened()) {
                    ++openRegionsCount;
                    continue;
                }
                if (regionState.isClosed()) {
                    ++closedRegionCount;
                    continue;
                }
                if (!regionState.isSplit()) continue;
                ++splitRegionCount;
            }
            totalRegionCount = states.size();
            ritCount = totalRegionCount - openRegionsCount - splitRegionCount;
        }
        return new RegionStatesCount.RegionStatesCountBuilder().setOpenRegions(openRegionsCount).setClosedRegions(closedRegionCount).setSplitRegions(splitRegionCount).setRegionsInTransition(ritCount).setTotalRegions(totalRegionCount).build();
    }

    private class RegionMetaLoadingVisitor
    implements RegionStateStore.RegionStateVisitor {
        private RegionMetaLoadingVisitor() {
        }

        @Override
        public void visitRegionState(Result result, RegionInfo regionInfo, RegionState.State state, ServerName regionLocation, ServerName lastHost, long openSeqNum) {
            if (state == null && regionLocation == null && lastHost == null && openSeqNum == -1L) {
                LOG.warn("Skipping empty row={}", (Object)result);
                return;
            }
            RegionState.State localState = state;
            if (localState == null) {
                LOG.info(regionInfo.getEncodedName() + " regionState=null; presuming " + (Object)((Object)RegionState.State.OFFLINE));
                localState = RegionState.State.OFFLINE;
            }
            RegionStateNode regionNode = AssignmentManager.this.regionStates.getOrCreateRegionStateNode(regionInfo);
            regionNode.setState(localState, new RegionState.State[0]);
            regionNode.setLastHost(lastHost);
            regionNode.setRegionLocation(regionLocation);
            regionNode.setOpenSeqNum(openSeqNum);
            if (localState.matches(RegionState.State.OPEN, RegionState.State.OPENING, RegionState.State.CLOSING, RegionState.State.SPLITTING, RegionState.State.MERGING)) {
                assert (regionLocation != null) : "found null region location for " + regionNode;
                AssignmentManager.this.regionStates.addRegionToServer(regionNode);
            } else if (localState == RegionState.State.OFFLINE || regionInfo.isOffline()) {
                AssignmentManager.this.regionStates.addToOfflineRegions(regionNode);
            }
            if (regionNode.getProcedure() != null) {
                regionNode.getProcedure().stateLoaded(AssignmentManager.this, regionNode);
            }
        }
    }

    public static class RegionInTransitionStat {
        private final int ritThreshold;
        private HashMap<String, RegionState> ritsOverThreshold = null;
        private long statTimestamp;
        private long oldestRITTime = 0L;
        private int totalRITsTwiceThreshold = 0;
        private int totalRITs = 0;

        public RegionInTransitionStat(Configuration conf) {
            this.ritThreshold = conf.getInt(AssignmentManager.METRICS_RIT_STUCK_WARNING_THRESHOLD, 60000);
        }

        public int getRITThreshold() {
            return this.ritThreshold;
        }

        public long getTimestamp() {
            return this.statTimestamp;
        }

        public int getTotalRITs() {
            return this.totalRITs;
        }

        public long getOldestRITTime() {
            return this.oldestRITTime;
        }

        public int getTotalRITsOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null ? m.size() : 0;
        }

        public boolean hasRegionsTwiceOverThreshold() {
            return this.totalRITsTwiceThreshold > 0;
        }

        public boolean hasRegionsOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null && !m.isEmpty();
        }

        public Collection<RegionState> getRegionOverThreshold() {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null ? m.values() : Collections.emptySet();
        }

        public boolean isRegionOverThreshold(RegionInfo regionInfo) {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            return m != null && m.containsKey(regionInfo.getEncodedName());
        }

        public boolean isRegionTwiceOverThreshold(RegionInfo regionInfo) {
            HashMap<String, RegionState> m = this.ritsOverThreshold;
            if (m == null) {
                return false;
            }
            RegionState state = (RegionState)m.get(regionInfo.getEncodedName());
            if (state == null) {
                return false;
            }
            return this.statTimestamp - state.getStamp() > (long)(this.ritThreshold * 2);
        }

        protected void update(AssignmentManager am) {
            RegionStates regionStates = am.getRegionStates();
            this.statTimestamp = EnvironmentEdgeManager.currentTime();
            this.update(regionStates.getRegionsStateInTransition(), this.statTimestamp);
            this.update(regionStates.getRegionFailedOpen(), this.statTimestamp);
            if (LOG.isDebugEnabled() && this.ritsOverThreshold != null && !this.ritsOverThreshold.isEmpty()) {
                LOG.debug("RITs over threshold: {}", (Object)this.ritsOverThreshold.entrySet().stream().map(e -> (String)e.getKey() + ":" + ((RegionState)e.getValue()).getState().name()).collect(Collectors.joining("\n")));
            }
        }

        private void update(Collection<RegionState> regions, long currentTime) {
            for (RegionState state : regions) {
                ++this.totalRITs;
                long ritTime = currentTime - state.getStamp();
                if (ritTime > (long)this.ritThreshold) {
                    if (this.ritsOverThreshold == null) {
                        this.ritsOverThreshold = new HashMap();
                    }
                    this.ritsOverThreshold.put(state.getRegion().getEncodedName(), state);
                    this.totalRITsTwiceThreshold += ritTime > (long)(this.ritThreshold * 2) ? 1 : 0;
                }
                if (this.oldestRITTime >= ritTime) continue;
                this.oldestRITTime = ritTime;
            }
        }
    }

    private static class DeadServerMetricRegionChore
    extends ProcedureInMemoryChore<MasterProcedureEnv> {
        public DeadServerMetricRegionChore(int timeoutMsec) {
            super(timeoutMsec);
        }

        protected void periodicExecute(MasterProcedureEnv env) {
            ServerManager sm = env.getMasterServices().getServerManager();
            AssignmentManager am = env.getAssignmentManager();
            HashSet<ServerName> recentlyLiveServers = new HashSet<ServerName>();
            int deadRegions = 0;
            int unknownRegions = 0;
            block5: for (RegionStateNode rsn : am.getRegionStates().getRegionStateNodes()) {
                if (rsn.getState() != RegionState.State.OPEN) continue;
                ServerName sn = rsn.getRegionLocation();
                RegionState.State state = rsn.getState();
                if (state != RegionState.State.OPEN) continue;
                if (sn == null) {
                    ++unknownRegions;
                    continue;
                }
                if (recentlyLiveServers.contains(sn)) continue;
                ServerManager.ServerLiveState sls = sm.isServerKnownAndOnline(sn);
                switch (sls) {
                    case LIVE: {
                        recentlyLiveServers.add(sn);
                        continue block5;
                    }
                    case DEAD: {
                        ++deadRegions;
                        continue block5;
                    }
                    case UNKNOWN: {
                        ++unknownRegions;
                        continue block5;
                    }
                }
                throw new AssertionError((Object)("Unexpected " + (Object)((Object)sls)));
            }
            if (deadRegions > 0 || unknownRegions > 0) {
                LOG.info("Found {} OPEN regions on dead servers and {} OPEN regions on unknown servers", (Object)deadRegions, (Object)unknownRegions);
            }
            am.updateDeadServerRegionMetrics(deadRegions, unknownRegions);
        }
    }

    private static class RegionInTransitionChore
    extends ProcedureInMemoryChore<MasterProcedureEnv> {
        public RegionInTransitionChore(int timeoutMsec) {
            super(timeoutMsec);
        }

        protected void periodicExecute(MasterProcedureEnv env) {
            AssignmentManager am = env.getAssignmentManager();
            RegionInTransitionStat ritStat = am.computeRegionInTransitionStat();
            if (ritStat.hasRegionsOverThreshold()) {
                for (RegionState hri : ritStat.getRegionOverThreshold()) {
                    am.handleRegionOverStuckWarningThreshold(hri.getRegion());
                }
            }
            am.updateRegionsInTransitionMetrics(ritStat);
        }
    }
}

