/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.IMetaStoreClient;
import org.apache.hadoop.hive.metastore.api.NoSuchObjectException;
import org.apache.hadoop.hive.metastore.api.Partition;
import org.apache.hadoop.hive.metastore.api.Table;
import org.apache.hadoop.hive.ql.metadata.Hive;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.common.util.Option;
import org.apache.hudi.common.util.StringUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.HoodieHiveSyncException;
import org.apache.hudi.hive.PartitionValueExtractor;
import org.apache.hudi.hive.ddl.DDLExecutor;
import org.apache.hudi.hive.ddl.HMSDDLExecutor;
import org.apache.hudi.hive.ddl.HiveQueryDDLExecutor;
import org.apache.hudi.hive.ddl.HiveSyncMode;
import org.apache.hudi.hive.ddl.JDBCExecutor;
import org.apache.hudi.sync.common.AbstractSyncHoodieClient;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.apache.parquet.schema.MessageType;
import org.apache.thrift.TException;

public class HoodieHiveClient
extends AbstractSyncHoodieClient {
    private static final String HOODIE_LAST_COMMIT_TIME_SYNC = "last_commit_time_sync";
    private static final String HIVE_ESCAPE_CHARACTER = "`";
    private static final Logger LOG = LogManager.getLogger(HoodieHiveClient.class);
    private final PartitionValueExtractor partitionValueExtractor;
    private final HoodieTimeline activeTimeline;
    DDLExecutor ddlExecutor;
    private IMetaStoreClient client;
    private final HiveSyncConfig syncConfig;

    public HoodieHiveClient(HiveSyncConfig cfg, HiveConf configuration, FileSystem fs) {
        super(cfg.basePath, cfg.assumeDatePartitioning.booleanValue(), cfg.useFileListingFromMetadata.booleanValue(), cfg.withOperationField.booleanValue(), fs);
        this.syncConfig = cfg;
        try {
            if (!StringUtils.isNullOrEmpty((String)cfg.syncMode)) {
                HiveSyncMode syncMode = HiveSyncMode.of(cfg.syncMode);
                switch (syncMode) {
                    case HMS: {
                        this.ddlExecutor = new HMSDDLExecutor(configuration, cfg, fs);
                        break;
                    }
                    case HIVEQL: {
                        this.ddlExecutor = new HiveQueryDDLExecutor(cfg, fs, configuration);
                        break;
                    }
                    case JDBC: {
                        this.ddlExecutor = new JDBCExecutor(cfg, fs);
                        break;
                    }
                    default: {
                        throw new HoodieHiveSyncException("Invalid sync mode given " + cfg.syncMode);
                    }
                }
            } else {
                this.ddlExecutor = cfg.useJdbc != false ? new JDBCExecutor(cfg, fs) : new HiveQueryDDLExecutor(cfg, fs, configuration);
            }
            this.client = Hive.get((HiveConf)configuration).getMSC();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to create HiveMetaStoreClient", e);
        }
        try {
            this.partitionValueExtractor = (PartitionValueExtractor)Class.forName(cfg.partitionValueExtractorClass).newInstance();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to initialize PartitionValueExtractor class " + cfg.partitionValueExtractorClass, e);
        }
        this.activeTimeline = this.metaClient.getActiveTimeline().getCommitsTimeline().filterCompletedInstants();
    }

    public HoodieTimeline getActiveTimeline() {
        return this.activeTimeline;
    }

    public void addPartitionsToTable(String tableName, List<String> partitionsToAdd) {
        this.ddlExecutor.addPartitionsToTable(tableName, partitionsToAdd);
    }

    public void updatePartitionsToTable(String tableName, List<String> changedPartitions) {
        this.ddlExecutor.updatePartitionsToTable(tableName, changedPartitions);
    }

    public void dropPartitionsToTable(String tableName, List<String> partitionsToDrop) {
        this.ddlExecutor.dropPartitionsToTable(tableName, partitionsToDrop);
    }

    public void updateTableProperties(String tableName, Map<String, String> tableProperties) {
        if (tableProperties == null || tableProperties.isEmpty()) {
            return;
        }
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            for (Map.Entry<String, String> entry : tableProperties.entrySet()) {
                table.putToParameters(entry.getKey(), entry.getValue());
            }
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update table properties for table: " + tableName, e);
        }
    }

    List<AbstractSyncHoodieClient.PartitionEvent> getPartitionEvents(List<Partition> tablePartitions, List<String> partitionStoragePartitions) {
        return this.getPartitionEvents(tablePartitions, partitionStoragePartitions, false);
    }

    List<AbstractSyncHoodieClient.PartitionEvent> getPartitionEvents(List<Partition> tablePartitions, List<String> partitionStoragePartitions, boolean isDropPartition) {
        HashMap<String, String> paths = new HashMap<String, String>();
        for (Partition tablePartition : tablePartitions) {
            List hivePartitionValues = tablePartition.getValues();
            String fullTablePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)new Path(tablePartition.getSd().getLocation())).toUri().getPath();
            paths.put(String.join((CharSequence)", ", hivePartitionValues), fullTablePartitionPath);
        }
        ArrayList<AbstractSyncHoodieClient.PartitionEvent> events = new ArrayList<AbstractSyncHoodieClient.PartitionEvent>();
        for (String storagePartition : partitionStoragePartitions) {
            Path storagePartitionPath = FSUtils.getPartitionPath((String)this.syncConfig.basePath, (String)storagePartition);
            String fullStoragePartitionPath = Path.getPathWithoutSchemeAndAuthority((Path)storagePartitionPath).toUri().getPath();
            List<String> storagePartitionValues = this.partitionValueExtractor.extractPartitionValuesInPath(storagePartition);
            if (isDropPartition) {
                events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionDropEvent((String)storagePartition));
                continue;
            }
            if (storagePartitionValues.isEmpty()) continue;
            String storageValue = String.join((CharSequence)", ", storagePartitionValues);
            if (!paths.containsKey(storageValue)) {
                events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionAddEvent((String)storagePartition));
                continue;
            }
            if (((String)paths.get(storageValue)).equals(fullStoragePartitionPath)) continue;
            events.add(AbstractSyncHoodieClient.PartitionEvent.newPartitionUpdateEvent((String)storagePartition));
        }
        return events;
    }

    public List<Partition> scanTablePartitions(String tableName) throws TException {
        return this.client.listPartitions(this.syncConfig.databaseName, tableName, (short)-1);
    }

    void updateTableDefinition(String tableName, MessageType newSchema) {
        this.ddlExecutor.updateTableDefinition(tableName, newSchema);
    }

    public void createTable(String tableName, MessageType storageSchema, String inputFormatClass, String outputFormatClass, String serdeClass, Map<String, String> serdeProperties, Map<String, String> tableProperties) {
        this.ddlExecutor.createTable(tableName, storageSchema, inputFormatClass, outputFormatClass, serdeClass, serdeProperties, tableProperties);
    }

    public Map<String, String> getTableSchema(String tableName) {
        if (!this.doesTableExist(tableName)) {
            throw new IllegalArgumentException("Failed to get schema for table " + tableName + " does not exist");
        }
        return this.ddlExecutor.getTableSchema(tableName);
    }

    public boolean doesTableExist(String tableName) {
        try {
            return this.client.tableExists(this.syncConfig.databaseName, tableName);
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if table exists " + tableName, e);
        }
    }

    public boolean doesDataBaseExist(String databaseName) {
        try {
            this.client.getDatabase(databaseName);
            return true;
        }
        catch (NoSuchObjectException noSuchObjectException) {
            return false;
        }
        catch (TException e) {
            throw new HoodieHiveSyncException("Failed to check if database exists " + databaseName, e);
        }
    }

    public void createDatabase(String databaseName) {
        this.ddlExecutor.createDatabase(databaseName);
    }

    public Option<String> getLastCommitTimeSynced(String tableName) {
        try {
            Table database = this.client.getTable(this.syncConfig.databaseName, tableName);
            return Option.ofNullable(database.getParameters().getOrDefault(HOODIE_LAST_COMMIT_TIME_SYNC, null));
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last commit time synced from the database", e);
        }
    }

    public Option<String> getLastReplicatedTime(String tableName) {
        try {
            Table database = this.client.getTable(this.syncConfig.databaseName, tableName);
            return Option.ofNullable(database.getParameters().getOrDefault("last_replication_timestamp", null));
        }
        catch (NoSuchObjectException e) {
            LOG.warn((Object)("the said table not found in hms " + this.syncConfig.databaseName + "." + tableName));
            return Option.empty();
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to get the last replicated time from the database", e);
        }
    }

    public void updateLastReplicatedTimeStamp(String tableName, String timeStamp) {
        if (!this.activeTimeline.filterCompletedInstants().getInstants().anyMatch(i -> i.getTimestamp().equals(timeStamp))) {
            throw new HoodieHiveSyncException("Not a valid completed timestamp " + timeStamp + " for table " + tableName);
        }
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            table.putToParameters("last_replication_timestamp", timeStamp);
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to update last replicated time to " + timeStamp + " for " + tableName, e);
        }
    }

    public void deleteLastReplicatedTimeStamp(String tableName) {
        try {
            Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
            String timestamp = (String)table.getParameters().remove("last_replication_timestamp");
            this.client.alter_table(this.syncConfig.databaseName, tableName, table);
            if (timestamp != null) {
                LOG.info((Object)("deleted last replicated timestamp " + timestamp + " for table " + tableName));
            }
        }
        catch (NoSuchObjectException table) {
        }
        catch (Exception e) {
            throw new HoodieHiveSyncException("Failed to delete last replicated timestamp for " + tableName, e);
        }
    }

    public void close() {
        try {
            this.ddlExecutor.close();
            if (this.client != null) {
                Hive.closeCurrent();
                this.client = null;
            }
        }
        catch (Exception e) {
            LOG.error((Object)"Could not close connection ", (Throwable)e);
        }
    }

    List<String> getAllTables(String db) throws Exception {
        return this.client.getAllTables(db);
    }

    public void updateLastCommitTimeSynced(String tableName) {
        Option lastCommitSynced = this.activeTimeline.lastInstant().map(HoodieInstant::getTimestamp);
        if (lastCommitSynced.isPresent()) {
            try {
                Table table = this.client.getTable(this.syncConfig.databaseName, tableName);
                table.putToParameters(HOODIE_LAST_COMMIT_TIME_SYNC, (String)lastCommitSynced.get());
                this.client.alter_table(this.syncConfig.databaseName, tableName, table);
            }
            catch (Exception e) {
                throw new HoodieHiveSyncException("Failed to get update last commit time synced to " + lastCommitSynced, e);
            }
        }
    }
}

