/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.hive.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.hudi.common.util.PartitionPathEncodeUtils;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.hive.HiveSyncConfig;
import org.apache.hudi.hive.PartitionValueExtractor;

public class HivePartitionUtil {
    public static String getPartitionClauseForDrop(String partition, PartitionValueExtractor partitionValueExtractor, HiveSyncConfig config) {
        List<String> partitionValues = partitionValueExtractor.extractPartitionValuesInPath(partition);
        ValidationUtils.checkArgument((config.partitionFields.size() == partitionValues.size() ? 1 : 0) != 0, (String)("Partition key parts " + config.partitionFields + " does not match with partition values " + partitionValues + ". Check partition strategy. "));
        ArrayList<String> partBuilder = new ArrayList<String>();
        for (int i = 0; i < config.partitionFields.size(); ++i) {
            String partitionValue = partitionValues.get(i);
            if (config.decodePartition.booleanValue()) {
                partitionValue = PartitionPathEncodeUtils.unescapePathName((String)partitionValue);
            }
            partBuilder.add(config.partitionFields.get(i) + "=" + partitionValue);
        }
        return String.join((CharSequence)"/", partBuilder);
    }
}

