/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.client.clustering.run.strategy;

import java.util.List;
import java.util.Map;
import org.apache.avro.Schema;
import org.apache.hudi.client.WriteStatus;
import org.apache.hudi.client.clustering.run.strategy.JavaExecutionStrategy;
import org.apache.hudi.common.engine.EngineType;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.model.HoodieFileGroupId;
import org.apache.hudi.common.model.HoodieRecord;
import org.apache.hudi.common.model.HoodieRecordPayload;
import org.apache.hudi.config.HoodieStorageConfig;
import org.apache.hudi.config.HoodieWriteConfig;
import org.apache.hudi.io.CreateHandleFactory;
import org.apache.hudi.io.WriteHandleFactory;
import org.apache.hudi.table.HoodieTable;
import org.apache.hudi.table.action.commit.JavaBulkInsertHelper;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class JavaSortAndSizeExecutionStrategy<T extends HoodieRecordPayload<T>>
extends JavaExecutionStrategy<T> {
    private static final Logger LOG = LogManager.getLogger(JavaSortAndSizeExecutionStrategy.class);

    public JavaSortAndSizeExecutionStrategy(HoodieTable table, HoodieEngineContext engineContext, HoodieWriteConfig writeConfig) {
        super(table, engineContext, writeConfig);
    }

    @Override
    public List<WriteStatus> performClusteringWithRecordList(List<HoodieRecord<T>> inputRecords, int numOutputGroups, String instantTime, Map<String, String> strategyParams, Schema schema, List<HoodieFileGroupId> fileGroupIdList, boolean preserveHoodieMetadata) {
        LOG.info((Object)("Starting clustering for a group, parallelism:" + numOutputGroups + " commit:" + instantTime));
        HoodieWriteConfig newConfig = HoodieWriteConfig.newBuilder().withBulkInsertParallelism(numOutputGroups).withEngineType(EngineType.JAVA).withProps((Map)this.getWriteConfig().getProps()).build();
        newConfig.setValue(HoodieStorageConfig.PARQUET_MAX_FILE_SIZE, String.valueOf(this.getWriteConfig().getClusteringTargetFileMaxBytes()));
        return JavaBulkInsertHelper.newInstance().bulkInsert(inputRecords, instantTime, this.getHoodieTable(), newConfig, false, this.getPartitioner(strategyParams, schema), true, numOutputGroups, (WriteHandleFactory)new CreateHandleFactory(preserveHoodieMetadata));
    }
}

