/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.common.util.hash;

import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import net.jpountz.xxhash.XXHash32;
import net.jpountz.xxhash.XXHash64;
import net.jpountz.xxhash.XXHashFactory;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

public class HashID
implements Serializable {
    private static final String MD5_ALGORITHM_NAME = "MD5";
    private static final int HASH_SEED = -625288518;

    public static byte[] hash(String message, Size bits) {
        return HashID.hash(message.getBytes(StandardCharsets.UTF_8), bits);
    }

    public static byte[] hash(byte[] messageBytes, Size bits) {
        switch (bits) {
            case BITS_32: 
            case BITS_64: {
                return HashID.getXXHash(messageBytes, bits);
            }
            case BITS_128: {
                return HashID.getMD5Hash(messageBytes);
            }
        }
        throw new IllegalArgumentException("Unexpected Hash size bits: " + (Object)((Object)bits));
    }

    private static byte[] getXXHash(byte[] message, Size bits) {
        XXHashFactory factory = XXHashFactory.fastestInstance();
        switch (bits) {
            case BITS_32: {
                XXHash32 hash32 = factory.hash32();
                return Bytes.toBytes(hash32.hash(message, 0, message.length, -625288518));
            }
            case BITS_64: {
                XXHash64 hash64 = factory.hash64();
                return Bytes.toBytes(hash64.hash(message, 0, message.length, -625288518L));
            }
        }
        throw new HoodieIOException("XX" + (Object)((Object)bits) + " hash is unsupported!");
    }

    private static byte[] getMD5Hash(byte[] message) throws HoodieIOException {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance(MD5_ALGORITHM_NAME);
            messageDigest.update(message);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException e) {
            throw new HoodieIOException("Failed to create MD5 Hash: " + e);
        }
    }

    public static enum Size {
        BITS_32(32),
        BITS_64(64),
        BITS_128(128);

        private final int bits;

        private Size(int bitCount) {
            this.bits = bitCount;
        }

        public int byteSize() {
            return (this.bits - 1) / 8 + 1;
        }

        public int bits() {
            return this.bits;
        }

        public String toString() {
            return "HashSize{" + this.bits + "}";
        }
    }
}

