/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.metadata;

import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.hudi.common.metrics.Registry;
import org.apache.hudi.common.model.FileSlice;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.HoodieTableMetaClient;
import org.apache.hudi.common.table.view.HoodieTableFileSystemView;
import org.apache.hudi.exception.HoodieIOException;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.hudi.metadata.MetadataPartitionType;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;

public class HoodieMetadataMetrics
implements Serializable {
    public static final String LOOKUP_PARTITIONS_STR = "lookup_partitions";
    public static final String LOOKUP_FILES_STR = "lookup_files";
    public static final String SCAN_STR = "scan";
    public static final String BASEFILE_READ_STR = "basefile_read";
    public static final String INITIALIZE_STR = "initialize";
    public static final String REBOOTSTRAP_STR = "rebootstrap";
    public static final String BOOTSTRAP_ERR_STR = "bootstrap_error";
    public static final String STAT_TOTAL_BASE_FILE_SIZE = "totalBaseFileSizeInBytes";
    public static final String STAT_TOTAL_LOG_FILE_SIZE = "totalLogFileSizeInBytes";
    public static final String STAT_COUNT_BASE_FILES = "baseFileCount";
    public static final String STAT_COUNT_LOG_FILES = "logFileCount";
    public static final String STAT_COUNT_PARTITION = "partitionCount";
    public static final String STAT_LAST_COMPACTION_TIMESTAMP = "lastCompactionTimestamp";
    private static final Logger LOG = LogManager.getLogger(HoodieMetadataMetrics.class);
    private final Registry metricsRegistry;

    public HoodieMetadataMetrics(Registry metricsRegistry) {
        this.metricsRegistry = metricsRegistry;
    }

    public Map<String, String> getStats(boolean detailed, HoodieTableMetaClient metaClient, HoodieTableMetadata metadata) {
        try {
            metaClient.reloadActiveTimeline();
            HoodieTableFileSystemView fsView = new HoodieTableFileSystemView(metaClient, metaClient.getActiveTimeline());
            return this.getStats(fsView, detailed, metadata);
        }
        catch (IOException ioe) {
            throw new HoodieIOException("Unable to get metadata stats.", ioe);
        }
    }

    private Map<String, String> getStats(HoodieTableFileSystemView fsView, boolean detailed, HoodieTableMetadata tableMetadata) throws IOException {
        HashMap<String, String> stats = new HashMap<String, String>();
        for (String metadataPartition : MetadataPartitionType.all()) {
            List latestSlices = fsView.getLatestFileSlices(metadataPartition).collect(Collectors.toList());
            long totalBaseFileSizeInBytes = 0L;
            long totalLogFileSizeInBytes = 0L;
            int baseFileCount = 0;
            int logFileCount = 0;
            for (FileSlice slice : latestSlices) {
                if (slice.getBaseFile().isPresent()) {
                    totalBaseFileSizeInBytes += slice.getBaseFile().get().getFileStatus().getLen();
                    ++baseFileCount;
                }
                Iterator it = slice.getLogFiles().iterator();
                while (it.hasNext()) {
                    totalLogFileSizeInBytes += ((HoodieLogFile)it.next()).getFileSize();
                    ++logFileCount;
                }
            }
            stats.put(metadataPartition + "." + STAT_TOTAL_BASE_FILE_SIZE, String.valueOf(totalBaseFileSizeInBytes));
            stats.put(metadataPartition + "." + STAT_TOTAL_LOG_FILE_SIZE, String.valueOf(totalLogFileSizeInBytes));
            stats.put(metadataPartition + "." + STAT_COUNT_BASE_FILES, String.valueOf(baseFileCount));
            stats.put(metadataPartition + "." + STAT_COUNT_LOG_FILES, String.valueOf(logFileCount));
        }
        if (detailed) {
            stats.put(STAT_COUNT_PARTITION, String.valueOf(tableMetadata.getAllPartitionPaths().size()));
        }
        return stats;
    }

    protected void updateMetrics(String action, long durationInMs) {
        if (this.metricsRegistry == null) {
            return;
        }
        String countKey = action + ".count";
        String durationKey = action + ".totalDuration";
        this.incrementMetric(countKey, 1L);
        this.incrementMetric(durationKey, durationInMs);
    }

    public void updateSizeMetrics(HoodieTableMetaClient metaClient, HoodieBackedTableMetadata metadata) {
        Map<String, String> stats = this.getStats(false, metaClient, (HoodieTableMetadata)metadata);
        for (Map.Entry<String, String> e : stats.entrySet()) {
            this.incrementMetric(e.getKey(), Long.parseLong(e.getValue()));
        }
    }

    protected void incrementMetric(String action, long value) {
        LOG.info((Object)String.format("Updating metadata metrics (%s=%d) in %s", action, value, this.metricsRegistry));
        this.metricsRegistry.add(action, value);
    }

    public Registry registry() {
        return this.metricsRegistry;
    }
}

