/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.io.IOException;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.SettableSequenceId;
import org.apache.hudi.org.apache.hadoop.hbase.SettableTimestamp;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.io.HeapSize;
import org.apache.hudi.org.apache.hadoop.hbase.util.ClassSize;

@InterfaceAudience.Private
public class TagRewriteCell
implements Cell,
SettableSequenceId,
SettableTimestamp,
HeapSize {
    private Cell cell;
    private byte[] tags;

    public TagRewriteCell(Cell cell, byte[] tags) {
        assert (cell instanceof SettableSequenceId);
        assert (cell instanceof SettableTimestamp);
        assert (tags != null);
        this.cell = cell;
        this.tags = tags;
        if (this.cell instanceof TagRewriteCell) {
            ((TagRewriteCell)this.cell).tags = null;
        }
    }

    @Override
    public byte[] getRowArray() {
        return this.cell.getRowArray();
    }

    @Override
    public int getRowOffset() {
        return this.cell.getRowOffset();
    }

    @Override
    public short getRowLength() {
        return this.cell.getRowLength();
    }

    @Override
    public byte[] getFamilyArray() {
        return this.cell.getFamilyArray();
    }

    @Override
    public int getFamilyOffset() {
        return this.cell.getFamilyOffset();
    }

    @Override
    public byte getFamilyLength() {
        return this.cell.getFamilyLength();
    }

    @Override
    public byte[] getQualifierArray() {
        return this.cell.getQualifierArray();
    }

    @Override
    public int getQualifierOffset() {
        return this.cell.getQualifierOffset();
    }

    @Override
    public int getQualifierLength() {
        return this.cell.getQualifierLength();
    }

    @Override
    public long getTimestamp() {
        return this.cell.getTimestamp();
    }

    @Override
    public byte getTypeByte() {
        return this.cell.getTypeByte();
    }

    @Override
    @Deprecated
    public long getMvccVersion() {
        return this.getSequenceId();
    }

    @Override
    public long getSequenceId() {
        return this.cell.getSequenceId();
    }

    @Override
    public byte[] getValueArray() {
        return this.cell.getValueArray();
    }

    @Override
    public int getValueOffset() {
        return this.cell.getValueOffset();
    }

    @Override
    public int getValueLength() {
        return this.cell.getValueLength();
    }

    @Override
    public byte[] getTagsArray() {
        return this.tags;
    }

    @Override
    public int getTagsOffset() {
        return 0;
    }

    @Override
    public int getTagsLength() {
        if (null == this.tags) {
            return 0;
        }
        return this.tags.length;
    }

    @Override
    @Deprecated
    public byte[] getValue() {
        return this.cell.getValue();
    }

    @Override
    @Deprecated
    public byte[] getFamily() {
        return this.cell.getFamily();
    }

    @Override
    @Deprecated
    public byte[] getQualifier() {
        return this.cell.getQualifier();
    }

    @Override
    @Deprecated
    public byte[] getRow() {
        return this.cell.getRow();
    }

    @Override
    public long heapSize() {
        long sum = CellUtil.estimatedHeapSizeOf(this.cell) - (long)this.cell.getTagsLength();
        sum += (long)ClassSize.OBJECT;
        sum += (long)(2 * ClassSize.REFERENCE);
        if (this.tags != null) {
            sum += (long)ClassSize.align(ClassSize.ARRAY);
            sum += (long)this.tags.length;
        }
        return sum;
    }

    @Override
    public void setTimestamp(long ts) throws IOException {
        CellUtil.setTimestamp(this.cell, ts);
    }

    @Override
    public void setTimestamp(byte[] ts, int tsOffset) throws IOException {
        CellUtil.setTimestamp(this.cell, ts, tsOffset);
    }

    @Override
    public void setSequenceId(long seqId) throws IOException {
        CellUtil.setSequenceId(this.cell, seqId);
    }
}

