/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import org.apache.hudi.org.apache.hadoop.hbase.Cell;
import org.apache.hudi.org.apache.hadoop.hbase.CellScannable;
import org.apache.hudi.org.apache.hadoop.hbase.CellScanner;
import org.apache.hudi.org.apache.hadoop.hbase.CellUtil;
import org.apache.hudi.org.apache.hadoop.hbase.HConstants;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestCellUtil {
    @Test
    public void testCreateCellScannerOverflow() throws IOException {
        this.consume(this.doCreateCellScanner(1, 1), 1);
        this.consume(this.doCreateCellScanner(3, 0), 0);
        this.consume(this.doCreateCellScanner(3, 3), 9);
        this.consume(this.doCreateCellScanner(0, 1), 0);
        int hundredK = 100000;
        this.consume(this.doCreateCellScanner(100000, 0), 0);
        this.consume(this.doCreateCellArray(1), 1);
        this.consume(this.doCreateCellArray(0), 0);
        this.consume(this.doCreateCellArray(3), 3);
        ArrayList<TestCellScannable> cells = new ArrayList<TestCellScannable>(100000);
        for (int i = 0; i < 100000; ++i) {
            cells.add(new TestCellScannable(1));
        }
        this.consume(CellUtil.createCellScanner(cells), 100000);
        TreeMap<byte[], List<Cell>> m = new TreeMap<byte[], List<Cell>>(Bytes.BYTES_COMPARATOR);
        ArrayList<TestCell> cellArray = new ArrayList<TestCell>(100000);
        for (int i = 0; i < 100000; ++i) {
            cellArray.add(new TestCell(i));
        }
        m.put(new byte[]{102}, cellArray);
        this.consume(CellUtil.createCellScanner(m), 100000);
    }

    private CellScanner doCreateCellArray(int itemsPerList) {
        Cell[] cells = new Cell[itemsPerList];
        for (int i = 0; i < itemsPerList; ++i) {
            cells[i] = new TestCell(i);
        }
        return CellUtil.createCellScanner(cells);
    }

    private CellScanner doCreateCellScanner(int listsCount, final int itemsPerList) throws IOException {
        ArrayList<1> cells = new ArrayList<1>(listsCount);
        for (int i = 0; i < listsCount; ++i) {
            CellScannable cs = new CellScannable(){

                @Override
                public CellScanner cellScanner() {
                    return new TestCellScanner(itemsPerList);
                }
            };
            cells.add(cs);
        }
        return CellUtil.createCellScanner(cells);
    }

    private void consume(CellScanner scanner, int expected) throws IOException {
        int count = 0;
        while (scanner.advance()) {
            ++count;
        }
        Assert.assertEquals((long)expected, (long)count);
    }

    @Test
    public void testOverlappingKeys() {
        byte[] empty = HConstants.EMPTY_BYTE_ARRAY;
        byte[] a = Bytes.toBytes("a");
        byte[] b = Bytes.toBytes("b");
        byte[] c = Bytes.toBytes("c");
        byte[] d = Bytes.toBytes("d");
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, c, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, d, b, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(b, c, a, d));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, b, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, b));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, empty, a, c));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(a, b, empty, empty));
        Assert.assertTrue((boolean)CellUtil.overlappingKeys(empty, empty, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, d));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, c, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, d, empty));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, d, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(c, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(d, empty, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, a, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, b));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(b, c, empty, a));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(a, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, b, b, c));
        Assert.assertFalse((boolean)CellUtil.overlappingKeys(empty, a, b, c));
    }

    @Test
    public void testFindCommonPrefixInFlatKey() {
        KeyValue kv1 = new KeyValue("r1".getBytes(), "f1".getBytes(), "q1".getBytes(), null);
        Assert.assertEquals((long)kv1.getKeyLength(), (long)CellUtil.findCommonPrefixInFlatKey(kv1, kv1, true, true));
        Assert.assertEquals((long)kv1.getKeyLength(), (long)CellUtil.findCommonPrefixInFlatKey(kv1, kv1, false, true));
        Assert.assertEquals((long)(kv1.getKeyLength() - 9), (long)CellUtil.findCommonPrefixInFlatKey(kv1, kv1, true, false));
        KeyValue kv2 = new KeyValue("r12".getBytes(), "f1".getBytes(), "q1".getBytes(), null);
        Assert.assertEquals((long)1L, (long)CellUtil.findCommonPrefixInFlatKey(kv1, kv2, true, true));
        KeyValue kv3 = new KeyValue("r14".getBytes(), "f1".getBytes(), "q1".getBytes(), null);
        Assert.assertEquals((long)(2 + "r1".getBytes().length), (long)CellUtil.findCommonPrefixInFlatKey(kv2, kv3, true, true));
        KeyValue kv4 = new KeyValue("r14".getBytes(), "f2".getBytes(), "q1".getBytes(), null);
        Assert.assertEquals((long)(2 + kv3.getRowLength() + 1 + "f".getBytes().length), (long)CellUtil.findCommonPrefixInFlatKey(kv3, kv4, false, true));
        KeyValue kv5 = new KeyValue("r14".getBytes(), "f2".getBytes(), "q123".getBytes(), null);
        Assert.assertEquals((long)(2 + kv3.getRowLength() + 1 + kv4.getFamilyLength() + kv4.getQualifierLength()), (long)CellUtil.findCommonPrefixInFlatKey(kv4, kv5, true, true));
        KeyValue kv6 = new KeyValue("rk".getBytes(), 1234L);
        KeyValue kv7 = new KeyValue("rk".getBytes(), 1235L);
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength() + 7), (long)CellUtil.findCommonPrefixInFlatKey(kv6, kv7, true, true));
        KeyValue kv8 = new KeyValue("rk".getBytes(), 1234L, KeyValue.Type.Delete);
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength() + 8), (long)CellUtil.findCommonPrefixInFlatKey(kv6, kv8, true, true));
        Assert.assertEquals((long)(2 + kv6.getRowLength() + 1 + kv6.getFamilyLength() + kv6.getQualifierLength()), (long)CellUtil.findCommonPrefixInFlatKey(kv6, kv8, true, false));
    }

    @Test
    public void testToString() {
        byte[] row = Bytes.toBytes("row");
        long ts = 123L;
        KeyValue kv = new KeyValue(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, ts, KeyValue.Type.Minimum, HConstants.EMPTY_BYTE_ARRAY);
        Cell cell = CellUtil.createCell(row, HConstants.EMPTY_BYTE_ARRAY, HConstants.EMPTY_BYTE_ARRAY, ts, KeyValue.Type.Minimum.getCode(), HConstants.EMPTY_BYTE_ARRAY);
        String cellToString = CellUtil.getCellKeyAsString(cell);
        Assert.assertEquals((Object)kv.toString(), (Object)cellToString);
        byte[] f = new byte[]{102};
        byte[] q = new byte[]{113};
        kv = new KeyValue(row, f, q, ts, KeyValue.Type.Minimum, HConstants.EMPTY_BYTE_ARRAY);
        cell = CellUtil.createCell(row, f, q, ts, KeyValue.Type.Minimum.getCode(), HConstants.EMPTY_BYTE_ARRAY);
        cellToString = CellUtil.getCellKeyAsString(cell);
        Assert.assertEquals((Object)kv.toString(), (Object)cellToString);
    }

    @Test
    public void testToString1() {
        String row = "test.row";
        String family = "test.family";
        String qualifier = "test.qualifier";
        long timestamp = 42L;
        KeyValue.Type type = KeyValue.Type.Put;
        String value = "test.value";
        long seqId = 1042L;
        Cell cell = CellUtil.createCell(Bytes.toBytes(row), Bytes.toBytes(family), Bytes.toBytes(qualifier), timestamp, type.getCode(), Bytes.toBytes(value), seqId);
        String nonVerbose = CellUtil.toString(cell, false);
        String verbose = CellUtil.toString(cell, true);
        System.out.println("nonVerbose=" + nonVerbose);
        System.out.println("verbose=" + verbose);
        Assert.assertEquals((Object)String.format("%s/%s:%s/%d/%s/vlen=%s/seqid=%s", row, family, qualifier, timestamp, type.toString(), Bytes.toBytes(value).length, seqId), (Object)nonVerbose);
        Assert.assertEquals((Object)String.format("%s/%s:%s/%d/%s/vlen=%s/seqid=%s/%s", row, family, qualifier, timestamp, type.toString(), Bytes.toBytes(value).length, seqId, value), (Object)verbose);
    }

    private class TestCell
    implements Cell {
        private final byte[] row;

        TestCell(int i) {
            this.row = Bytes.toBytes(i);
        }

        @Override
        public byte[] getRowArray() {
            return this.row;
        }

        @Override
        public int getRowOffset() {
            return 0;
        }

        @Override
        public short getRowLength() {
            return (short)this.row.length;
        }

        @Override
        public byte[] getFamilyArray() {
            return null;
        }

        @Override
        public int getFamilyOffset() {
            return 0;
        }

        @Override
        public byte getFamilyLength() {
            return 0;
        }

        @Override
        public byte[] getQualifierArray() {
            return null;
        }

        @Override
        public int getQualifierOffset() {
            return 0;
        }

        @Override
        public int getQualifierLength() {
            return 0;
        }

        @Override
        public long getTimestamp() {
            return 0L;
        }

        @Override
        public byte getTypeByte() {
            return 0;
        }

        @Override
        public long getMvccVersion() {
            return 0L;
        }

        @Override
        public byte[] getValueArray() {
            return null;
        }

        @Override
        public int getValueOffset() {
            return 0;
        }

        @Override
        public int getValueLength() {
            return 0;
        }

        @Override
        public byte[] getTagsArray() {
            return null;
        }

        @Override
        public int getTagsOffset() {
            return 0;
        }

        @Override
        public byte[] getValue() {
            return null;
        }

        @Override
        public byte[] getFamily() {
            return null;
        }

        @Override
        public byte[] getQualifier() {
            return null;
        }

        @Override
        public byte[] getRow() {
            return null;
        }

        @Override
        public long getSequenceId() {
            return 0L;
        }

        @Override
        public int getTagsLength() {
            return 0;
        }
    }

    private class TestCellScanner
    implements CellScanner {
        private int count = 0;
        private Cell current = null;
        private final int cellsCount;

        TestCellScanner(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        @Override
        public Cell current() {
            return this.current;
        }

        @Override
        public boolean advance() throws IOException {
            if (this.count < this.cellsCount) {
                this.current = new TestCell(this.count);
                ++this.count;
                return true;
            }
            return false;
        }
    }

    private class TestCellScannable
    implements CellScannable {
        private final int cellsCount;

        TestCellScannable(int cellsCount) {
            this.cellsCount = cellsCount;
        }

        @Override
        public CellScanner cellScanner() {
            return new TestCellScanner(this.cellsCount);
        }
    }
}

