/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.io;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import org.apache.hudi.org.apache.hadoop.hbase.KeyValue;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.io.TagCompressionContext;
import org.apache.hudi.org.apache.hadoop.hbase.io.util.LRUDictionary;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestTagCompressionContext {
    private static final byte[] ROW = Bytes.toBytes("r1");
    private static final byte[] CF = Bytes.toBytes("f");
    private static final byte[] Q = Bytes.toBytes("q");
    private static final byte[] V = Bytes.toBytes("v");

    @Test
    public void testCompressUncompressTags1() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        KeyValue kv1 = this.createKVWithTags(2);
        int tagsLength1 = kv1.getTagsLength();
        ByteBuffer ib = ByteBuffer.wrap(kv1.getTagsArray(), kv1.getTagsOffset(), tagsLength1);
        context.compressTags(baos, ib, tagsLength1);
        KeyValue kv2 = this.createKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        ib = ByteBuffer.wrap(kv2.getTagsArray(), kv2.getTagsOffset(), tagsLength2);
        context.compressTags(baos, ib, tagsLength2);
        context.clear();
        byte[] dest = new byte[tagsLength1];
        ByteBuffer ob = ByteBuffer.wrap(baos.toByteArray());
        context.uncompressTags(ob, dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals(kv1.getTagsArray(), kv1.getTagsOffset(), tagsLength1, dest, 0, tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags(ob, dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals(kv2.getTagsArray(), kv2.getTagsOffset(), tagsLength2, dest, 0, tagsLength2));
    }

    @Test
    public void testCompressUncompressTags2() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        TagCompressionContext context = new TagCompressionContext(LRUDictionary.class, 127);
        KeyValue kv1 = this.createKVWithTags(1);
        int tagsLength1 = kv1.getTagsLength();
        context.compressTags(baos, kv1.getTagsArray(), kv1.getTagsOffset(), tagsLength1);
        KeyValue kv2 = this.createKVWithTags(3);
        int tagsLength2 = kv2.getTagsLength();
        context.compressTags(baos, kv2.getTagsArray(), kv2.getTagsOffset(), tagsLength2);
        context.clear();
        ByteArrayInputStream bais = new ByteArrayInputStream(baos.toByteArray());
        byte[] dest = new byte[tagsLength1];
        context.uncompressTags(bais, dest, 0, tagsLength1);
        Assert.assertTrue((boolean)Bytes.equals(kv1.getTagsArray(), kv1.getTagsOffset(), tagsLength1, dest, 0, tagsLength1));
        dest = new byte[tagsLength2];
        context.uncompressTags(bais, dest, 0, tagsLength2);
        Assert.assertTrue((boolean)Bytes.equals(kv2.getTagsArray(), kv2.getTagsOffset(), tagsLength2, dest, 0, tagsLength2));
    }

    private KeyValue createKVWithTags(int noOfTags) {
        ArrayList<Tag> tags = new ArrayList<Tag>();
        for (int i = 0; i < noOfTags; ++i) {
            tags.add(new Tag((byte)i, "tagValue" + i));
        }
        KeyValue kv = new KeyValue(ROW, CF, Q, 1234L, V, tags);
        return kv;
    }
}

