/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.ipc;

import org.apache.hudi.org.apache.hadoop.hbase.ipc.MetricsHBaseServerWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.ipc.RpcServer;

public class MetricsHBaseServerWrapperImpl
implements MetricsHBaseServerWrapper {
    private RpcServer server;

    MetricsHBaseServerWrapperImpl(RpcServer server) {
        this.server = server;
    }

    private boolean isServerStarted() {
        return this.server != null && this.server.isStarted();
    }

    public long getTotalQueueSize() {
        if (!this.isServerStarted()) {
            return 0L;
        }
        return this.server.callQueueSize.get();
    }

    public int getGeneralQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getGeneralQueueLength();
    }

    public int getReplicationQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getReplicationQueueLength();
    }

    public int getPriorityQueueLength() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getPriorityQueueLength();
    }

    public int getNumOpenConnections() {
        if (!this.isServerStarted() || this.server.connectionList == null) {
            return 0;
        }
        return this.server.connectionList.size();
    }

    public int getActiveRpcHandlerCount() {
        if (!this.isServerStarted() || this.server.getScheduler() == null) {
            return 0;
        }
        return this.server.getScheduler().getActiveRpcHandlerCount();
    }
}

