/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hudi.org.apache.hadoop.hbase.Tag;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.Connection;
import org.apache.hudi.org.apache.hadoop.hbase.client.ConnectionFactory;
import org.apache.hudi.org.apache.hadoop.hbase.client.Result;
import org.apache.hudi.org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hudi.org.apache.hadoop.hbase.client.Scan;
import org.apache.hudi.org.apache.hadoop.hbase.client.Table;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.VisibilityExpressionResolver;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityConstants;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityLabelOrdinalProvider;
import org.apache.hudi.org.apache.hadoop.hbase.security.visibility.VisibilityUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;

@InterfaceAudience.Private
public class DefaultVisibilityExpressionResolver
implements VisibilityExpressionResolver {
    private static final Log LOG = LogFactory.getLog(DefaultVisibilityExpressionResolver.class);
    private Configuration conf;
    private final Map<String, Integer> labels = new HashMap<String, Integer>();

    public Configuration getConf() {
        return this.conf;
    }

    public void setConf(Configuration conf) {
        this.conf = conf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void init() {
        block43: {
            Table labelsTable = null;
            Connection connection = null;
            try {
                connection = ConnectionFactory.createConnection(this.conf);
                try {
                    labelsTable = connection.getTable(VisibilityConstants.LABELS_TABLE_NAME);
                }
                catch (TableNotFoundException e) {
                    if (labelsTable != null) {
                        try {
                            labelsTable.close();
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                        }
                    }
                    return;
                }
                catch (IOException e) {
                    block42: {
                        LOG.error((Object)"Error opening 'labels' table", (Throwable)e);
                        if (labelsTable == null) break block42;
                        try {
                            labelsTable.close();
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                        }
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (IOException ioe) {
                            LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                        }
                    }
                    return;
                }
                Scan scan = new Scan();
                scan.setAuthorizations(new Authorizations("system"));
                scan.addColumn(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                try (ResultScanner scanner = null;){
                    scanner = labelsTable.getScanner(scan);
                    Result next = null;
                    while ((next = scanner.next()) != null) {
                        byte[] row = next.getRow();
                        byte[] value = next.getValue(VisibilityConstants.LABELS_TABLE_FAMILY, VisibilityConstants.LABEL_QUALIFIER);
                        this.labels.put(Bytes.toString(value), Bytes.toInt(row));
                    }
                    break block43;
                }
                {
                    catch (IOException ioe) {
                        LOG.error((Object)"Failed reading 'labels' tags", (Throwable)ioe);
                        return;
                    }
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
            finally {
                if (labelsTable != null) {
                    try {
                        labelsTable.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)"Error closing 'labels' table", (Throwable)ioe);
                    }
                }
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (IOException ioe) {
                        LOG.warn((Object)"Failed close of temporary connection", (Throwable)ioe);
                    }
                }
            }
        }
    }

    @Override
    public List<Tag> createVisibilityExpTags(String visExpression) throws IOException {
        VisibilityLabelOrdinalProvider provider = new VisibilityLabelOrdinalProvider(){

            @Override
            public int getLabelOrdinal(String label) {
                Integer ordinal = null;
                ordinal = (Integer)DefaultVisibilityExpressionResolver.this.labels.get(label);
                if (ordinal != null) {
                    return ordinal;
                }
                return 0;
            }

            @Override
            public String getLabel(int ordinal) {
                throw new UnsupportedOperationException("getLabel should not be used in VisibilityExpressionResolver");
            }
        };
        return VisibilityUtils.createVisibilityExpTags(visExpression, true, false, null, provider);
    }
}

