/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.mapreduce;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hudi.org.apache.hadoop.hbase.mapreduce.ImportTsv;
import org.apache.hudi.org.apache.hadoop.hbase.util.Base64;
import org.apache.hudi.org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class TsvImporterTextMapper
extends Mapper<LongWritable, Text, ImmutableBytesWritable, Text> {
    private String separator;
    private boolean skipBadLines;
    private Counter badLineCount;
    private ImportTsv.TsvParser parser;

    public boolean getSkipBadLines() {
        return this.skipBadLines;
    }

    public Counter getBadLineCount() {
        return this.badLineCount;
    }

    public void incrementBadLineCount(int count) {
        this.badLineCount.increment((long)count);
    }

    protected void setup(Mapper.Context context) {
        this.doSetup(context);
        Configuration conf = context.getConfiguration();
        this.parser = new ImportTsv.TsvParser(conf.get("importtsv.columns"), this.separator);
        if (this.parser.getRowKeyColumnIndex() == -1) {
            throw new RuntimeException("No row key column specified");
        }
    }

    protected void doSetup(Mapper.Context context) {
        Configuration conf = context.getConfiguration();
        this.separator = conf.get("importtsv.separator");
        this.separator = this.separator == null ? "\t" : new String(Base64.decode(this.separator));
        this.skipBadLines = context.getConfiguration().getBoolean("importtsv.skip.bad.lines", true);
        this.badLineCount = context.getCounter("ImportTsv", "Bad Lines");
    }

    public void map(LongWritable offset, Text value, Mapper.Context context) throws IOException {
        try {
            Pair<Integer, Integer> rowKeyOffests = this.parser.parseRowKey(value.getBytes(), value.getLength());
            ImmutableBytesWritable rowKey = new ImmutableBytesWritable(value.getBytes(), rowKeyOffests.getFirst(), rowKeyOffests.getSecond());
            context.write((Object)rowKey, (Object)value);
        }
        catch (ImportTsv.TsvParser.BadTsvLineException badLine) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + badLine.getMessage());
                this.incrementBadLineCount(1);
                return;
            }
            throw new IOException(badLine);
        }
        catch (IllegalArgumentException e) {
            if (this.skipBadLines) {
                System.err.println("Bad line at offset: " + offset.get() + ":\n" + e.getMessage());
                this.incrementBadLineCount(1);
                return;
            }
            throw new IOException(e);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
            Thread.currentThread().interrupt();
        }
    }
}

