/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.master.HMaster;
import org.apache.hudi.org.apache.hadoop.hbase.master.ServerManager;
import org.apache.hudi.org.apache.hadoop.hbase.tmpl.master.MasterStatusTmpl;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.MetaTableLocator;

@InterfaceAudience.Private
public class MasterStatusServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HMaster master = (HMaster)this.getServletContext().getAttribute("master");
        assert (master != null) : "No Master in context!";
        response.setContentType("text/html");
        Configuration conf = master.getConfiguration();
        Map<String, Integer> frags = this.getFragmentationInfo(master, conf);
        ServerName metaLocation = null;
        List<ServerName> servers = null;
        Set<ServerName> deadServers = null;
        if (master.isActiveMaster()) {
            metaLocation = this.getMetaLocationOrNull(master);
            ServerManager serverManager = master.getServerManager();
            if (serverManager != null) {
                deadServers = serverManager.getDeadServers().copyServerNames();
                servers = serverManager.getOnlineServersList();
            }
        }
        MasterStatusTmpl tmpl = new MasterStatusTmpl().setFrags(frags).setMetaLocation(metaLocation).setServers(servers).setDeadServers(deadServers).setCatalogJanitorEnabled(master.isCatalogJanitorEnabled());
        if (request.getParameter("filter") != null) {
            tmpl.setFilter(request.getParameter("filter"));
        }
        if (request.getParameter("format") != null) {
            tmpl.setFormat(request.getParameter("format"));
        }
        tmpl.render(response.getWriter(), master);
    }

    private ServerName getMetaLocationOrNull(HMaster master) {
        MetaTableLocator metaTableLocator = master.getMetaTableLocator();
        return metaTableLocator == null ? null : metaTableLocator.getMetaRegionLocation(master.getZooKeeper());
    }

    private Map<String, Integer> getFragmentationInfo(HMaster master, Configuration conf) throws IOException {
        boolean showFragmentation = conf.getBoolean("hbase.master.ui.fragmentation.enabled", false);
        if (showFragmentation) {
            return FSUtils.getTableFragmentation(master);
        }
        return null;
    }
}

