/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master;

import java.io.Serializable;
import java.util.Comparator;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;

@InterfaceAudience.LimitedPrivate(value={"Coprocessors"})
@InterfaceStability.Evolving
public class RegionPlan
implements Comparable<RegionPlan> {
    private final HRegionInfo hri;
    private final ServerName source;
    private ServerName dest;

    public RegionPlan(HRegionInfo hri, ServerName source, ServerName dest) {
        this.hri = hri;
        this.source = source;
        this.dest = dest;
    }

    public void setDestination(ServerName dest) {
        this.dest = dest;
    }

    public ServerName getSource() {
        return this.source;
    }

    public ServerName getDestination() {
        return this.dest;
    }

    public String getRegionName() {
        return this.hri.getEncodedName();
    }

    public HRegionInfo getRegionInfo() {
        return this.hri;
    }

    @Override
    public int compareTo(RegionPlan o) {
        return this.getRegionName().compareTo(o.getRegionName());
    }

    public int hashCode() {
        return this.getRegionName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RegionPlan other = (RegionPlan)obj;
        return this.compareTo(other) == 0;
    }

    public String toString() {
        return "hri=" + this.hri.getRegionNameAsString() + ", src=" + (this.source == null ? "" : this.source.toString()) + ", dest=" + (this.dest == null ? "" : this.dest.toString());
    }

    public static class RegionPlanComparator
    implements Comparator<RegionPlan>,
    Serializable {
        private static final long serialVersionUID = 4213207330485734853L;

        @Override
        public int compare(RegionPlan l, RegionPlan r) {
            long diff = r.getRegionInfo().getRegionId() - l.getRegionInfo().getRegionId();
            if (diff < 0L) {
                return -1;
            }
            if (diff > 0L) {
                return 1;
            }
            return 0;
        }
    }
}

