/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.handler;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.NamespaceDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.coordination.OpenRegionCoordination;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.master.handler.TotesHRegionInfo;

@InterfaceAudience.Private
public class OpenedRegionHandler
extends EventHandler
implements TotesHRegionInfo {
    private static final Log LOG = LogFactory.getLog(OpenedRegionHandler.class);
    private final AssignmentManager assignmentManager;
    private final HRegionInfo regionInfo;
    private final OpenedPriority priority;
    private OpenRegionCoordination coordination;
    private OpenRegionCoordination.OpenRegionDetails ord;

    public OpenedRegionHandler(Server server, AssignmentManager assignmentManager, HRegionInfo regionInfo, OpenRegionCoordination coordination, OpenRegionCoordination.OpenRegionDetails ord) {
        super(server, EventType.RS_ZK_REGION_OPENED);
        this.assignmentManager = assignmentManager;
        this.regionInfo = regionInfo;
        this.coordination = coordination;
        this.ord = ord;
        this.priority = regionInfo.isMetaRegion() ? OpenedPriority.META : (regionInfo.getTable().getNamespaceAsString().equals(NamespaceDescriptor.SYSTEM_NAMESPACE_NAME_STR) ? OpenedPriority.SYSTEM : OpenedPriority.USER);
    }

    @Override
    public int getPriority() {
        return this.priority.getValue();
    }

    @Override
    public HRegionInfo getHRegionInfo() {
        return this.regionInfo;
    }

    @Override
    public String toString() {
        String name = "UnknownServerName";
        if (this.server != null && this.server.getServerName() != null) {
            name = this.server.getServerName().toString();
        }
        return this.getClass().getSimpleName() + "-" + name + "-" + this.getSeqid();
    }

    @Override
    public void process() {
        if (!this.coordination.commitOpenOnMasterSide(this.assignmentManager, this.regionInfo, this.ord)) {
            this.assignmentManager.unassign(this.regionInfo);
        }
    }

    private static enum OpenedPriority {
        META(1),
        SYSTEM(2),
        USER(3);

        private final int value;

        private OpenedPriority(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

