/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.master.handler;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.com.google.common.collect.Lists;
import org.apache.hudi.com.google.common.collect.Maps;
import org.apache.hudi.org.apache.hadoop.hbase.CoordinatedStateException;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.InvalidFamilyOperationException;
import org.apache.hudi.org.apache.hadoop.hbase.MetaTableAccessor;
import org.apache.hudi.org.apache.hadoop.hbase.Server;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.TableNotDisabledException;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hudi.org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventHandler;
import org.apache.hudi.org.apache.hadoop.hbase.executor.EventType;
import org.apache.hudi.org.apache.hadoop.hbase.master.BulkReOpen;
import org.apache.hudi.org.apache.hadoop.hbase.master.MasterServices;
import org.apache.hudi.org.apache.hadoop.hbase.master.TableLockManager;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.zookeeper.MetaTableLocator;

@InterfaceAudience.Private
public abstract class TableEventHandler
extends EventHandler {
    private static final Log LOG = LogFactory.getLog(TableEventHandler.class);
    protected final MasterServices masterServices;
    protected final TableName tableName;
    protected TableLockManager.TableLock tableLock;
    private boolean isPrepareCalled = false;

    public TableEventHandler(EventType eventType, TableName tableName, Server server, MasterServices masterServices) {
        super(server, eventType);
        this.masterServices = masterServices;
        this.tableName = tableName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TableEventHandler prepare() throws IOException {
        this.tableLock = this.masterServices.getTableLockManager().writeLock(this.tableName, this.eventType.toString());
        this.tableLock.acquire();
        boolean success = false;
        try {
            try {
                this.masterServices.checkTableModifiable(this.tableName);
            }
            catch (TableNotDisabledException ex) {
                if (this.isOnlineSchemaChangeAllowed() && this.eventType.isOnlineSchemaChangeSupported()) {
                    LOG.debug((Object)"Ignoring table not disabled exception for supporting online schema changes.");
                }
                throw ex;
            }
            this.prepareWithTableLock();
            success = true;
        }
        finally {
            if (!success) {
                this.releaseTableLock();
            }
        }
        this.isPrepareCalled = true;
        return this;
    }

    protected void prepareWithTableLock() throws IOException {
    }

    private boolean isOnlineSchemaChangeAllowed() {
        return this.server.getConfiguration().getBoolean("hbase.online.schema.update.enable", false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void process() {
        if (!this.isPrepareCalled) {
            throw new RuntimeException("Implementation should have called prepare() first");
        }
        try {
            LOG.info((Object)("Handling table operation " + (Object)((Object)this.eventType) + " on table " + this.tableName));
            List<HRegionInfo> hris = TableName.META_TABLE_NAME.equals(this.tableName) ? new MetaTableLocator().getMetaRegions(this.server.getZooKeeper()) : MetaTableAccessor.getTableRegions(this.server.getZooKeeper(), this.server.getConnection(), this.tableName);
            this.handleTableOperation(hris);
            if (this.eventType.isOnlineSchemaChangeSupported() && this.masterServices.getAssignmentManager().getTableStateManager().isTableState(this.tableName, ZooKeeperProtos.Table.State.ENABLED)) {
                if (this.reOpenAllRegions(hris)) {
                    LOG.info((Object)("Completed table operation " + (Object)((Object)this.eventType) + " on table " + this.tableName));
                } else {
                    LOG.warn((Object)"Error on reopening the regions");
                }
            }
            this.completed(null);
        }
        catch (IOException e) {
            LOG.error((Object)("Error manipulating table " + this.tableName), (Throwable)e);
            this.completed(e);
        }
        catch (CoordinatedStateException e) {
            LOG.error((Object)("Error manipulating table " + this.tableName), (Throwable)e);
            this.completed(e);
        }
        finally {
            this.releaseTableLock();
        }
    }

    protected void releaseTableLock() {
        if (this.tableLock != null) {
            try {
                this.tableLock.release();
            }
            catch (IOException ex) {
                LOG.warn((Object)"Could not release the table lock", (Throwable)ex);
            }
        }
    }

    protected void completed(Throwable exception) {
    }

    public boolean reOpenAllRegions(List<HRegionInfo> regions) throws IOException {
        boolean done = false;
        LOG.info((Object)"Bucketing regions by region server...");
        List<HRegionLocation> regionLocations = null;
        ClusterConnection connection = this.masterServices.getConnection();
        try (RegionLocator locator = connection.getRegionLocator(this.tableName);){
            regionLocations = locator.getAllRegionLocations();
        }
        TreeMap<HRegionInfo, ServerName> hri2Sn = new TreeMap<HRegionInfo, ServerName>();
        for (HRegionLocation location : regionLocations) {
            hri2Sn.put(location.getRegionInfo(), location.getServerName());
        }
        TreeMap<ServerName, List<HRegionInfo>> serverToRegions = Maps.newTreeMap();
        ArrayList<HRegionInfo> reRegions = new ArrayList<HRegionInfo>();
        for (HRegionInfo hri : regions) {
            ServerName sn = (ServerName)hri2Sn.get(hri);
            if (null == sn) {
                LOG.info((Object)("Skip " + hri));
                continue;
            }
            if (!serverToRegions.containsKey(sn)) {
                LinkedList hriList = Lists.newLinkedList();
                serverToRegions.put(sn, hriList);
            }
            reRegions.add(hri);
            ((List)serverToRegions.get(sn)).add(hri);
        }
        LOG.info((Object)("Reopening " + reRegions.size() + " regions on " + serverToRegions.size() + " region servers."));
        this.masterServices.getAssignmentManager().setRegionsToReopen(reRegions);
        BulkReOpen bulkReopen = new BulkReOpen(this.server, serverToRegions, this.masterServices.getAssignmentManager());
        try {
            while (true) {
                if (bulkReopen.bulkReOpen()) {
                    done = true;
                    break;
                }
                LOG.warn((Object)"Timeout before reopening all regions");
            }
        }
        catch (InterruptedException e) {
            LOG.warn((Object)"Reopen was interrupted");
            Thread.currentThread().interrupt();
        }
        return done;
    }

    public HTableDescriptor getTableDescriptor() throws FileNotFoundException, IOException {
        HTableDescriptor htd = this.masterServices.getTableDescriptors().get(this.tableName);
        if (htd == null) {
            throw new IOException("HTableDescriptor missing for " + this.tableName);
        }
        return htd;
    }

    byte[] hasColumnFamily(HTableDescriptor htd, byte[] cf) throws InvalidFamilyOperationException {
        if (!htd.hasFamily(cf)) {
            throw new InvalidFamilyOperationException("Column family '" + Bytes.toString(cf) + "' does not exist");
        }
        return cf;
    }

    protected abstract void handleTableOperation(List<HRegionInfo> var1) throws IOException, CoordinatedStateException;
}

