/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.quotas;

import java.util.concurrent.TimeUnit;
import org.apache.hudi.org.apache.hadoop.hbase.TableName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hudi.org.apache.hadoop.hbase.protobuf.generated.MasterProtos;
import org.apache.hudi.org.apache.hadoop.hbase.quotas.QuotaType;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public abstract class QuotaSettings {
    private final String userName;
    private final String namespace;
    private final TableName tableName;

    protected QuotaSettings(String userName, TableName tableName, String namespace) {
        this.userName = userName;
        this.namespace = namespace;
        this.tableName = tableName;
    }

    public abstract QuotaType getQuotaType();

    public String getUserName() {
        return this.userName;
    }

    public TableName getTableName() {
        return this.tableName;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public static MasterProtos.SetQuotaRequest buildSetQuotaRequestProto(QuotaSettings settings) {
        MasterProtos.SetQuotaRequest.Builder builder = MasterProtos.SetQuotaRequest.newBuilder();
        if (settings.getUserName() != null) {
            builder.setUserName(settings.getUserName());
        }
        if (settings.getTableName() != null) {
            builder.setTableName(ProtobufUtil.toProtoTableName(settings.getTableName()));
        }
        if (settings.getNamespace() != null) {
            builder.setNamespace(settings.getNamespace());
        }
        settings.setupSetQuotaRequest(builder);
        return builder.build();
    }

    protected abstract void setupSetQuotaRequest(MasterProtos.SetQuotaRequest.Builder var1);

    protected String ownerToString() {
        StringBuilder builder = new StringBuilder();
        if (this.userName != null) {
            builder.append("USER => '");
            builder.append(this.userName);
            builder.append("', ");
        }
        if (this.tableName != null) {
            builder.append("TABLE => '");
            builder.append(this.tableName.toString());
            builder.append("', ");
        }
        if (this.namespace != null) {
            builder.append("NAMESPACE => '");
            builder.append(this.namespace);
            builder.append("', ");
        }
        return builder.toString();
    }

    protected static String sizeToString(long size) {
        if (size >= 0x4000000000000L) {
            return String.format("%dP", size / 0x4000000000000L);
        }
        if (size >= 0x10000000000L) {
            return String.format("%dT", size / 0x10000000000L);
        }
        if (size >= 0x40000000L) {
            return String.format("%dG", size / 0x40000000L);
        }
        if (size >= 0x100000L) {
            return String.format("%dM", size / 0x100000L);
        }
        if (size >= 1024L) {
            return String.format("%dK", size / 1024L);
        }
        return String.format("%dB", size);
    }

    protected static String timeToString(TimeUnit timeUnit) {
        switch (timeUnit) {
            case NANOSECONDS: {
                return "nsec";
            }
            case MICROSECONDS: {
                return "usec";
            }
            case MILLISECONDS: {
                return "msec";
            }
            case SECONDS: {
                return "sec";
            }
            case MINUTES: {
                return "min";
            }
            case HOURS: {
                return "hour";
            }
            case DAYS: {
                return "day";
            }
        }
        throw new RuntimeException("Invalid TimeUnit " + (Object)((Object)timeUnit));
    }
}

