/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.regionserver;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.StoreConfigInformation;

@InterfaceAudience.Private
public class StripeStoreConfig {
    private static final Log LOG = LogFactory.getLog(StripeStoreConfig.class);
    public static final String MAX_FILES_KEY = "hbase.store.stripe.compaction.maxFiles";
    public static final String MIN_FILES_KEY = "hbase.store.stripe.compaction.minFiles";
    public static final String MIN_FILES_L0_KEY = "hbase.store.stripe.compaction.minFilesL0";
    public static final String SIZE_TO_SPLIT_KEY = "hbase.store.stripe.sizeToSplit";
    public static final String SPLIT_PARTS_KEY = "hbase.store.stripe.splitPartCount";
    public static final String INITIAL_STRIPE_COUNT_KEY = "hbase.store.stripe.initialStripeCount";
    public static final String FLUSH_TO_L0_KEY = "hbase.store.stripe.compaction.flushToL0";
    public static final String MAX_REGION_SPLIT_IMBALANCE_KEY = "hbase.store.stripe.region.split.max.imbalance";
    private final float maxRegionSplitImbalance;
    private final int level0CompactMinFiles;
    private final int stripeCompactMinFiles;
    private final int stripeCompactMaxFiles;
    private final int initialCount;
    private final long sizeToSplitAt;
    private final float splitPartCount;
    private final boolean flushIntoL0;
    private final long splitPartSize;
    private static final double EPSILON = 0.001;

    public StripeStoreConfig(Configuration config, StoreConfigInformation sci) {
        this.level0CompactMinFiles = config.getInt(MIN_FILES_L0_KEY, 4);
        this.flushIntoL0 = config.getBoolean(FLUSH_TO_L0_KEY, false);
        int minMinFiles = this.flushIntoL0 ? 3 : 4;
        int minFiles = config.getInt("hbase.hstore.compaction.min", -1);
        this.stripeCompactMinFiles = config.getInt(MIN_FILES_KEY, Math.max(minMinFiles, minFiles));
        this.stripeCompactMaxFiles = config.getInt(MAX_FILES_KEY, config.getInt("hbase.hstore.compaction.max", 10));
        this.maxRegionSplitImbalance = StripeStoreConfig.getFloat(config, MAX_REGION_SPLIT_IMBALANCE_KEY, 1.5f, true);
        float splitPartCount = StripeStoreConfig.getFloat(config, SPLIT_PARTS_KEY, 2.0f, true);
        if (Math.abs((double)splitPartCount - 1.0) < 0.001) {
            LOG.error((Object)("Split part count cannot be 1 (" + splitPartCount + "), using the default"));
            splitPartCount = 2.0f;
        }
        this.splitPartCount = splitPartCount;
        double flushSize = sci.getMemstoreFlushSize();
        if (flushSize == 0.0) {
            flushSize = 1.34217728E8;
        }
        long defaultSplitSize = (long)(flushSize * (double)this.getLevel0MinFiles() * 4.0 * (double)splitPartCount);
        this.sizeToSplitAt = config.getLong(SIZE_TO_SPLIT_KEY, defaultSplitSize);
        int initialCount = config.getInt(INITIAL_STRIPE_COUNT_KEY, 1);
        if (initialCount == 0) {
            LOG.error((Object)"Initial stripe count is 0, using the default");
            initialCount = 1;
        }
        this.initialCount = initialCount;
        this.splitPartSize = (long)((float)this.sizeToSplitAt / this.splitPartCount);
    }

    private static float getFloat(Configuration config, String key, float defaultValue, boolean moreThanOne) {
        float value = config.getFloat(key, defaultValue);
        if ((double)value < 0.001) {
            LOG.warn((Object)String.format("%s is set to 0 or negative; using default value of %f", key, Float.valueOf(defaultValue)));
            value = defaultValue;
        } else if (value > 1.0f != moreThanOne) {
            value = 1.0f / value;
        }
        return value;
    }

    public float getMaxSplitImbalance() {
        return this.maxRegionSplitImbalance;
    }

    public int getLevel0MinFiles() {
        return this.level0CompactMinFiles;
    }

    public int getStripeCompactMinFiles() {
        return this.stripeCompactMinFiles;
    }

    public int getStripeCompactMaxFiles() {
        return this.stripeCompactMaxFiles;
    }

    public boolean isUsingL0Flush() {
        return this.flushIntoL0;
    }

    public long getSplitSize() {
        return this.sizeToSplitAt;
    }

    public int getInitialCount() {
        return this.initialCount;
    }

    public float getSplitCount() {
        return this.splitPartCount;
    }

    public long getSplitPartSize() {
        return this.splitPartSize;
    }
}

