/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.replication;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hudi.org.apache.hadoop.hbase.ServerName;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;

@InterfaceAudience.Private
public class ReplicationQueueInfo {
    private static final Log LOG = LogFactory.getLog(ReplicationQueueInfo.class);
    private final String peerId;
    private final String peerClusterZnode;
    private boolean queueRecovered;
    private List<String> deadRegionServers = new ArrayList<String>();

    public ReplicationQueueInfo(String znode) {
        this.peerClusterZnode = znode;
        String[] parts = znode.split("-", 2);
        this.queueRecovered = parts.length != 1;
        String string = this.peerId = this.queueRecovered ? parts[0] : this.peerClusterZnode;
        if (parts.length >= 2) {
            ReplicationQueueInfo.extractDeadServersFromZNodeString(parts[1], this.deadRegionServers);
        }
    }

    private static void extractDeadServersFromZNodeString(String deadServerListStr, List<String> result) {
        if (deadServerListStr == null || result == null || deadServerListStr.isEmpty()) {
            return;
        }
        int seenCommaCnt = 0;
        int startIndex = 0;
        int len = deadServerListStr.length();
        block4: for (int i = 0; i < len; ++i) {
            switch (deadServerListStr.charAt(i)) {
                case ',': {
                    ++seenCommaCnt;
                    continue block4;
                }
                case '-': {
                    if (seenCommaCnt < 2) continue block4;
                    if (i > startIndex) {
                        String serverName = deadServerListStr.substring(startIndex, i);
                        if (ServerName.isFullServerName(serverName)) {
                            result.add(serverName);
                        } else {
                            LOG.error((Object)("Found invalid server name:" + serverName));
                        }
                        startIndex = i + 1;
                    }
                    seenCommaCnt = 0;
                    continue block4;
                }
            }
        }
        if (startIndex < len - 1) {
            String serverName = deadServerListStr.substring(startIndex, len);
            if (ServerName.isFullServerName(serverName)) {
                result.add(serverName);
            } else {
                LOG.error((Object)("Found invalid server name at the end:" + serverName));
            }
        }
        LOG.debug((Object)("Found dead servers:" + result));
    }

    public List<String> getDeadRegionServers() {
        return Collections.unmodifiableList(this.deadRegionServers);
    }

    public String getPeerId() {
        return this.peerId;
    }

    public String getPeerClusterZnode() {
        return this.peerClusterZnode;
    }

    public boolean isQueueRecovered() {
        return this.queueRecovered;
    }
}

