/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.types.OrderedBytesBase;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.OrderedBytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.PositionedByteRange;

@InterfaceAudience.Public
@InterfaceStability.Evolving
public class OrderedFloat64
extends OrderedBytesBase<Double> {
    public static final OrderedFloat64 ASCENDING = new OrderedFloat64(Order.ASCENDING);
    public static final OrderedFloat64 DESCENDING = new OrderedFloat64(Order.DESCENDING);

    protected OrderedFloat64(Order order) {
        super(order);
    }

    @Override
    public boolean isNullable() {
        return false;
    }

    @Override
    public int encodedLength(Double val) {
        return 9;
    }

    @Override
    public Class<Double> encodedClass() {
        return Double.class;
    }

    @Override
    public Double decode(PositionedByteRange src) {
        return OrderedBytes.decodeFloat64(src);
    }

    @Override
    public int encode(PositionedByteRange dst, Double val) {
        if (null == val) {
            throw new IllegalArgumentException("Null values not supported.");
        }
        return OrderedBytes.encodeFloat64(dst, val, this.order);
    }

    public double decodeDouble(PositionedByteRange src) {
        return OrderedBytes.decodeFloat64(src);
    }

    public int encodeDouble(PositionedByteRange dst, double val) {
        return OrderedBytes.encodeFloat64(dst, val, this.order);
    }
}

