/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.types;

import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.types.FixedLengthWrapper;
import org.apache.hudi.org.apache.hadoop.hbase.types.RawBytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Bytes;
import org.apache.hudi.org.apache.hadoop.hbase.util.Order;
import org.apache.hudi.org.apache.hadoop.hbase.util.SimplePositionedMutableByteRange;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestFixedLengthWrapper {
    static final byte[][] VALUES = new byte[][]{Bytes.toBytes(""), Bytes.toBytes("1"), Bytes.toBytes("22"), Bytes.toBytes("333"), Bytes.toBytes("4444"), Bytes.toBytes("55555"), Bytes.toBytes("666666"), Bytes.toBytes("7777777"), Bytes.toBytes("88888888"), Bytes.toBytes("999999999")};
    static final int[] limits = new int[]{9, 12, 15};

    @Test
    public void testReadWrite() {
        for (int limit : limits) {
            SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(limit);
            for (Order ord : new Order[]{Order.ASCENDING, Order.DESCENDING}) {
                for (byte[] val : VALUES) {
                    buff.setPosition(0);
                    FixedLengthWrapper<byte[]> type = new FixedLengthWrapper<byte[]>(new RawBytes(ord), limit);
                    Assert.assertEquals((long)limit, (long)type.encode(buff, val));
                    buff.setPosition(0);
                    byte[] actual = (byte[])type.decode(buff);
                    Assert.assertTrue((String)"Decoding output differs from expected", (boolean)Bytes.equals(val, 0, val.length, actual, 0, val.length));
                    buff.setPosition(0);
                    Assert.assertEquals((long)limit, (long)type.skip(buff));
                }
            }
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingRead() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(0);
        FixedLengthWrapper<byte[]> type = new FixedLengthWrapper<byte[]>(new RawBytes(), 3);
        type.decode(buff);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInsufficientRemainingWrite() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(0);
        FixedLengthWrapper<byte[]> type = new FixedLengthWrapper<byte[]>(new RawBytes(), 3);
        type.encode(buff, Bytes.toBytes(""));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testOverflowPassthrough() {
        SimplePositionedMutableByteRange buff = new SimplePositionedMutableByteRange(3);
        FixedLengthWrapper<byte[]> type = new FixedLengthWrapper<byte[]>(new RawBytes(), 0);
        type.encode(buff, Bytes.toBytes("foo"));
    }
}

