/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hudi.org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.master.AssignmentManager;
import org.apache.hudi.org.apache.hadoop.hbase.regionserver.HRegion;
import org.apache.hudi.org.apache.hadoop.hbase.util.FSUtils;
import org.apache.hudi.org.apache.hadoop.hbase.util.Threads;

@InterfaceAudience.Private
public abstract class ModifyRegionUtils {
    private static final Log LOG = LogFactory.getLog(ModifyRegionUtils.class);

    private ModifyRegionUtils() {
    }

    public static HRegionInfo[] createHRegionInfos(HTableDescriptor hTableDescriptor, byte[][] splitKeys) {
        long regionId = System.currentTimeMillis();
        HRegionInfo[] hRegionInfos = null;
        if (splitKeys == null || splitKeys.length == 0) {
            hRegionInfos = new HRegionInfo[]{new HRegionInfo(hTableDescriptor.getTableName(), null, null, false, regionId)};
        } else {
            int numRegions = splitKeys.length + 1;
            hRegionInfos = new HRegionInfo[numRegions];
            byte[] startKey = null;
            byte[] endKey = null;
            for (int i = 0; i < numRegions; ++i) {
                endKey = i == splitKeys.length ? null : splitKeys[i];
                hRegionInfos[i] = new HRegionInfo(hTableDescriptor.getTableName(), startKey, endKey, false, regionId);
                startKey = endKey;
            }
        }
        return hRegionInfos;
    }

    public static List<HRegionInfo> createRegions(Configuration conf, Path rootDir, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions) throws IOException {
        return ModifyRegionUtils.createRegions(conf, rootDir, hTableDescriptor, newRegions, null);
    }

    public static List<HRegionInfo> createRegions(Configuration conf, Path rootDir, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions, RegionFillTask task) throws IOException {
        Path tableDir = FSUtils.getTableDir(rootDir, hTableDescriptor.getTableName());
        return ModifyRegionUtils.createRegions(conf, rootDir, tableDir, hTableDescriptor, newRegions, task);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<HRegionInfo> createRegions(Configuration conf, Path rootDir, Path tableDir, HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions, RegionFillTask task) throws IOException {
        if (newRegions == null) {
            return null;
        }
        int regionNumber = newRegions.length;
        ThreadPoolExecutor exec = ModifyRegionUtils.getRegionOpenAndInitThreadPool(conf, "RegionOpenAndInitThread-" + hTableDescriptor.getTableName(), regionNumber);
        try {
            List<HRegionInfo> list = ModifyRegionUtils.createRegions(exec, conf, rootDir, tableDir, hTableDescriptor, newRegions, task);
            return list;
        }
        finally {
            exec.shutdownNow();
        }
    }

    public static List<HRegionInfo> createRegions(ThreadPoolExecutor exec, final Configuration conf, final Path rootDir, final Path tableDir, final HTableDescriptor hTableDescriptor, HRegionInfo[] newRegions, final RegionFillTask task) throws IOException {
        if (newRegions == null) {
            return null;
        }
        int regionNumber = newRegions.length;
        ExecutorCompletionService<HRegionInfo> completionService = new ExecutorCompletionService<HRegionInfo>(exec);
        ArrayList<HRegionInfo> regionInfos = new ArrayList<HRegionInfo>();
        for (final HRegionInfo newRegion : newRegions) {
            completionService.submit(new Callable<HRegionInfo>(){

                @Override
                public HRegionInfo call() throws IOException {
                    return ModifyRegionUtils.createRegion(conf, rootDir, tableDir, hTableDescriptor, newRegion, task);
                }
            });
        }
        try {
            for (int i = 0; i < regionNumber; ++i) {
                regionInfos.add((HRegionInfo)completionService.take().get());
            }
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Caught " + e + " during region creation"));
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            throw new IOException(e);
        }
        return regionInfos;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HRegionInfo createRegion(Configuration conf, Path rootDir, Path tableDir, HTableDescriptor hTableDescriptor, HRegionInfo newRegion, RegionFillTask task) throws IOException {
        try (HRegion region = HRegion.createHRegion(newRegion, rootDir, tableDir, conf, hTableDescriptor, null, false, true);){
            if (task != null) {
                task.fillRegion(region);
            }
        }
        return region.getRegionInfo();
    }

    public static void editRegions(ThreadPoolExecutor exec, Collection<HRegionInfo> regions, final RegionEditTask task) throws IOException {
        ExecutorCompletionService<Void> completionService = new ExecutorCompletionService<Void>(exec);
        for (final HRegionInfo hri : regions) {
            completionService.submit(new Callable<Void>(){

                @Override
                public Void call() throws IOException {
                    task.editRegion(hri);
                    return null;
                }
            });
        }
        try {
            for (final HRegionInfo hri : regions) {
                completionService.take().get();
            }
        }
        catch (InterruptedException e) {
            throw new InterruptedIOException(e.getMessage());
        }
        catch (ExecutionException e) {
            IOException ex = new IOException();
            ex.initCause(e.getCause());
            throw ex;
        }
    }

    static ThreadPoolExecutor getRegionOpenAndInitThreadPool(Configuration conf, final String threadNamePrefix, int regionNumber) {
        int maxThreads = Math.min(regionNumber, conf.getInt("hbase.hregion.open.and.init.threads.max", 10));
        ThreadPoolExecutor regionOpenAndInitThreadPool = Threads.getBoundedCachedThreadPool(maxThreads, 30L, TimeUnit.SECONDS, new ThreadFactory(){
            private int count = 1;

            @Override
            public Thread newThread(Runnable r) {
                Thread t = new Thread(r, threadNamePrefix + "-" + this.count++);
                return t;
            }
        });
        return regionOpenAndInitThreadPool;
    }

    public static void assignRegions(AssignmentManager assignmentManager, List<HRegionInfo> regionInfos) throws IOException {
        try {
            assignmentManager.getRegionStates().createRegionStates(regionInfos);
            assignmentManager.assign(regionInfos);
        }
        catch (InterruptedException e) {
            LOG.error((Object)("Caught " + e + " during round-robin assignment"));
            InterruptedIOException ie = new InterruptedIOException(e.getMessage());
            ie.initCause(e);
            throw ie;
        }
    }

    public static interface RegionEditTask {
        public void editRegion(HRegionInfo var1) throws IOException;
    }

    public static interface RegionFillTask {
        public void fillRegion(HRegion var1) throws IOException;
    }
}

