/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hudi.org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hudi.org.apache.hadoop.hbase.util.Hash;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class MurmurHash
extends Hash {
    private static MurmurHash _instance = new MurmurHash();

    public static Hash getInstance() {
        return _instance;
    }

    @Override
    public int hash(byte[] data, int offset, int length, int seed) {
        int m = 1540483477;
        int r = 24;
        int h = seed ^ length;
        int len_4 = length >> 2;
        for (int i = 0; i < len_4; ++i) {
            int i_4 = (i << 2) + offset;
            int k = data[i_4 + 3];
            k <<= 8;
            k |= data[i_4 + 2] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 1] & 0xFF;
            k <<= 8;
            k |= data[i_4 + 0] & 0xFF;
            k *= m;
            k ^= k >>> r;
            h *= m;
            h ^= (k *= m);
        }
        int len_m = len_4 << 2;
        int left = length - len_m;
        int i_m = len_m + offset;
        if (left != 0) {
            if (left >= 3) {
                h ^= data[i_m + 2] << 16;
            }
            if (left >= 2) {
                h ^= data[i_m + 1] << 8;
            }
            if (left >= 1) {
                h ^= data[i_m];
            }
            h *= m;
        }
        h ^= h >>> 13;
        h *= m;
        h ^= h >>> 15;
        return h;
    }
}

