/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.BoundedArrayQueue;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestBoundedArrayQueue {
    private int qMaxElements = 5;
    private BoundedArrayQueue<Integer> queue = new BoundedArrayQueue(this.qMaxElements);

    @Test
    public void testBoundedArrayQueueOperations() throws Exception {
        int i;
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertNull((Object)this.queue.poll());
        Assert.assertNull((Object)this.queue.peek());
        for (i = 0; i < this.qMaxElements; ++i) {
            Assert.assertTrue((boolean)this.queue.offer(i));
        }
        Assert.assertEquals((long)this.qMaxElements, (long)this.queue.size());
        Assert.assertFalse((boolean)this.queue.offer(0));
        Assert.assertEquals((long)0L, (long)this.queue.peek().intValue());
        Assert.assertEquals((long)0L, (long)this.queue.peek().intValue());
        for (i = 0; i < this.qMaxElements; ++i) {
            Assert.assertEquals((long)i, (long)this.queue.poll().intValue());
        }
        Assert.assertEquals((long)0L, (long)this.queue.size());
        Assert.assertNull((Object)this.queue.poll());
        Assert.assertTrue((boolean)this.queue.offer(100));
        Assert.assertTrue((boolean)this.queue.offer(1000));
        Assert.assertEquals((long)100L, (long)this.queue.peek().intValue());
        Assert.assertEquals((long)100L, (long)this.queue.poll().intValue());
        Assert.assertEquals((long)1000L, (long)this.queue.poll().intValue());
    }
}

