/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.hadoop.hbase.util;

import java.util.concurrent.locks.ReentrantLock;
import org.apache.hudi.org.apache.hadoop.hbase.testclassification.SmallTests;
import org.apache.hudi.org.apache.hadoop.hbase.util.KeyLocker;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;

@Category(value={SmallTests.class})
public class TestKeyLocker {
    @Test
    public void testLocker() {
        KeyLocker<String> locker = new KeyLocker<String>();
        ReentrantLock lock1 = locker.acquireLock("l1");
        Assert.assertTrue((boolean)lock1.isHeldByCurrentThread());
        ReentrantLock lock2 = locker.acquireLock("l2");
        Assert.assertTrue((boolean)lock2.isHeldByCurrentThread());
        Assert.assertTrue((lock1 != lock2 ? 1 : 0) != 0);
        ReentrantLock lock20 = locker.acquireLock("l2");
        Assert.assertTrue((lock20 == lock2 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)lock2.isHeldByCurrentThread());
        Assert.assertTrue((boolean)lock20.isHeldByCurrentThread());
        lock20.unlock();
        Assert.assertTrue((boolean)lock20.isHeldByCurrentThread());
        lock2.unlock();
        Assert.assertFalse((boolean)lock20.isHeldByCurrentThread());
        int lock2Hash = System.identityHashCode(lock2);
        lock2 = null;
        lock20 = null;
        System.gc();
        System.gc();
        System.gc();
        ReentrantLock lock200 = locker.acquireLock("l2");
        Assert.assertNotEquals((long)lock2Hash, (long)System.identityHashCode(lock200));
        lock200.unlock();
        Assert.assertFalse((boolean)lock200.isHeldByCurrentThread());
        Assert.assertTrue((boolean)lock1.isHeldByCurrentThread());
        lock1.unlock();
        Assert.assertFalse((boolean)lock1.isHeldByCurrentThread());
    }
}

