/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace;

import java.lang.reflect.Constructor;
import org.apache.hudi.org.apache.htrace.HTraceConfiguration;
import org.apache.hudi.org.apache.htrace.Sampler;
import org.apache.hudi.org.apache.htrace.commons.logging.Log;
import org.apache.hudi.org.apache.htrace.commons.logging.LogFactory;
import org.apache.hudi.org.apache.htrace.impl.NeverSampler;

public class SamplerBuilder {
    public static final String SAMPLER_CONF_KEY = "sampler";
    private static final String DEFAULT_PACKAGE = "org.apache.hudi.org.apache.htrace.impl";
    private static final ClassLoader classLoader = SamplerBuilder.class.getClassLoader();
    private final HTraceConfiguration conf;
    private static final Log LOG = LogFactory.getLog(SamplerBuilder.class);

    public SamplerBuilder(HTraceConfiguration conf) {
        this.conf = conf;
    }

    public Sampler build() {
        String str = this.conf.get(SAMPLER_CONF_KEY);
        if (str.isEmpty()) {
            return NeverSampler.INSTANCE;
        }
        if (!str.contains(".")) {
            str = "org.apache.hudi.org.apache.htrace.impl." + str;
        }
        Class<?> cls = null;
        try {
            cls = classLoader.loadClass(str);
        }
        catch (ClassNotFoundException e) {
            LOG.error("SamplerBuilder cannot find sampler class " + str + ": falling back on NeverSampler.");
            return NeverSampler.INSTANCE;
        }
        Constructor<?> ctor = null;
        try {
            ctor = cls.getConstructor(HTraceConfiguration.class);
        }
        catch (NoSuchMethodException e) {
            LOG.error("SamplerBuilder cannot find a constructor for class " + str + "which takes an HTraceConfiguration.  Falling back on " + "NeverSampler.");
            return NeverSampler.INSTANCE;
        }
        try {
            return (Sampler)ctor.newInstance(this.conf);
        }
        catch (ReflectiveOperationException e) {
            LOG.error("SamplerBuilder reflection error when constructing " + str + ".  Falling back on NeverSampler.", e);
            return NeverSampler.INSTANCE;
        }
        catch (Throwable e) {
            LOG.error("SamplerBuilder constructor error when constructing " + str + ".  Falling back on NeverSampler.", e);
            return NeverSampler.INSTANCE;
        }
    }
}

