/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.ser;

import java.util.Map;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.core.JsonGenerator;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.BeanProperty;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.JsonMappingException;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.SerializerProvider;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.introspect.AnnotatedMember;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.ser.PropertyFilter;
import org.apache.hudi.org.apache.htrace.fasterxml.jackson.databind.ser.std.MapSerializer;

public class AnyGetterWriter {
    protected final BeanProperty _property;
    protected final AnnotatedMember _accessor;
    protected MapSerializer _serializer;

    public AnyGetterWriter(BeanProperty property, AnnotatedMember accessor, MapSerializer serializer) {
        this._accessor = accessor;
        this._property = property;
        this._serializer = serializer;
    }

    public void getAndSerialize(Object bean, JsonGenerator jgen, SerializerProvider provider) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw new JsonMappingException("Value returned by 'any-getter' (" + this._accessor.getName() + "()) not java.util.Map but " + value.getClass().getName());
        }
        this._serializer.serializeFields((Map)value, jgen, provider);
    }

    public void getAndFilter(Object bean, JsonGenerator jgen, SerializerProvider provider, PropertyFilter filter) throws Exception {
        Object value = this._accessor.getValue(bean);
        if (value == null) {
            return;
        }
        if (!(value instanceof Map)) {
            throw new JsonMappingException("Value returned by 'any-getter' (" + this._accessor.getName() + "()) not java.util.Map but " + value.getClass().getName());
        }
        this._serializer.serializeFilteredFields((Map)value, jgen, provider, filter);
    }

    public void resolve(SerializerProvider provider) throws JsonMappingException {
        this._serializer = (MapSerializer)provider.handlePrimaryContextualization(this._serializer, this._property);
    }
}

