/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hudi.AvroConversionUtils$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieTableSchema;
import org.apache.hudi.SparkAdapterSupport;
import org.apache.hudi.common.config.SerializableConfiguration;
import org.apache.hudi.common.util.ValidationUtils;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.internal.schema.convert.AvroInternalSchemaConverter;
import org.apache.hudi.internal.schema.utils.InternalSchemaUtils;
import org.apache.hudi.io.storage.HoodieHFileReader;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.HoodieCatalystExpressionUtils$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.avro.HoodieAvroSchemaConverters;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.catalyst.expressions.UnsafeProjection;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import org.apache.spark.sql.hudi.SparkAdapter;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.GenSet;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.mutable.Buffer$;
import scala.reflect.ClassTag$;
import scala.util.Either;
import scala.util.Left;
import scala.util.Right;

public final class HoodieBaseRelation$
implements SparkAdapterSupport {
    public static final HoodieBaseRelation$ MODULE$;
    private final SparkAdapter sparkAdapter;
    private volatile boolean bitmap$0;

    static {
        new HoodieBaseRelation$();
    }

    private SparkAdapter sparkAdapter$lzycompute() {
        HoodieBaseRelation$ hoodieBaseRelation$ = this;
        synchronized (hoodieBaseRelation$) {
            if (!this.bitmap$0) {
                this.sparkAdapter = SparkAdapterSupport.class.sparkAdapter((SparkAdapterSupport)this);
                this.bitmap$0 = true;
            }
            return this.sparkAdapter;
        }
    }

    public SparkAdapter sparkAdapter() {
        return this.bitmap$0 ? this.sparkAdapter : this.sparkAdapter$lzycompute();
    }

    public UnsafeProjection generateUnsafeProjection(StructType from, StructType to) {
        return HoodieCatalystExpressionUtils$.MODULE$.generateUnsafeProjection(from, to);
    }

    public Schema convertToAvroSchema(StructType structSchema) {
        HoodieAvroSchemaConverters qual$1 = this.sparkAdapter().getAvroSchemaConverters();
        StructType x$20 = structSchema;
        boolean x$21 = false;
        String x$22 = "Record";
        String x$23 = qual$1.toAvroType$default$4();
        return qual$1.toAvroType((DataType)x$20, x$21, x$22, x$23);
    }

    public Path getPartitionPath(FileStatus fileStatus) {
        return fileStatus.getPath().getParent();
    }

    public HoodieBaseRelation.BaseFileReader projectReader(HoodieBaseRelation.BaseFileReader reader, StructType requiredSchema) {
        HoodieBaseRelation.BaseFileReader baseFileReader;
        ValidationUtils.checkState((((TraversableOnce)Predef$.MODULE$.refArrayOps((Object[])reader.schema().fields()).toSet().intersect((GenSet)Predef$.MODULE$.refArrayOps((Object[])requiredSchema.fields()).toSet())).size() == requiredSchema.size() ? 1 : 0) != 0);
        StructType structType = reader.schema();
        StructType structType2 = requiredSchema;
        if (!(structType != null ? !structType.equals(structType2) : structType2 != null)) {
            baseFileReader = reader;
        } else {
            Serializable read = new Serializable(reader){
                public static final long serialVersionUID = 0L;
                private final HoodieBaseRelation.BaseFileReader reader$1;

                public final Iterator<InternalRow> apply(PartitionedFile x$19) {
                    return this.reader$1.apply(x$19);
                }
                {
                    this.reader$1 = reader$1;
                }
            };
            Serializable projectedRead = new Serializable(reader, requiredSchema, (Function1)read){
                public static final long serialVersionUID = 0L;
                private final HoodieBaseRelation.BaseFileReader reader$1;
                private final StructType requiredSchema$1;
                private final Function1 read$2;

                public final Iterator<InternalRow> apply(PartitionedFile file) {
                    UnsafeProjection unsafeProjection = HoodieBaseRelation$.MODULE$.generateUnsafeProjection(this.reader$1.schema(), this.requiredSchema$1);
                    return ((Iterator)this.read$2.apply((Object)file)).map((Function1)unsafeProjection);
                }
                {
                    this.reader$1 = reader$1;
                    this.requiredSchema$1 = requiredSchema$1;
                    this.read$2 = read$2;
                }
            };
            baseFileReader = new HoodieBaseRelation.BaseFileReader((Function1<PartitionedFile, Iterator<InternalRow>>)projectedRead, requiredSchema);
        }
        return baseFileReader;
    }

    public Tuple3<Schema, StructType, InternalSchema> projectSchema(Either<Schema, InternalSchema> tableSchema, String[] requiredColumns) {
        Either<Schema, InternalSchema> either;
        block4: {
            Tuple3 tuple3;
            block3: {
                block2: {
                    either = tableSchema;
                    if (!(either instanceof Right)) break block2;
                    Right right = (Right)either;
                    InternalSchema internalSchema = (InternalSchema)right.b();
                    ValidationUtils.checkState((!internalSchema.isEmptySchema() ? 1 : 0) != 0);
                    InternalSchema prunedInternalSchema = InternalSchemaUtils.pruneInternalSchema((InternalSchema)internalSchema, (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Predef$.MODULE$.refArrayOps((Object[])requiredColumns).toList()).asJava()));
                    Schema requiredAvroSchema = AvroInternalSchemaConverter.convert((InternalSchema)prunedInternalSchema, (String)"schema");
                    StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
                    tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)prunedInternalSchema);
                    break block3;
                }
                if (!(either instanceof Left)) break block4;
                Left left = (Left)either;
                Schema avroSchema = (Schema)left.a();
                Map fieldMap = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(avroSchema.getFields()).asScala()).map((Function1)new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final Tuple2<String, Schema.Field> apply(Schema.Field f) {
                        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)f.name()), (Object)f);
                    }
                }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                List requiredFields = Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])requiredColumns).map((Function1)new Serializable(fieldMap){
                    public static final long serialVersionUID = 0L;
                    private final Map fieldMap$1;

                    public final Schema.Field apply(String col) {
                        Schema.Field f = (Schema.Field)this.fieldMap$1.apply((Object)col);
                        return new Schema.Field(f.name(), f.schema(), f.doc(), f.defaultVal(), f.order());
                    }
                    {
                        this.fieldMap$1 = fieldMap$1;
                    }
                }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Schema.Field.class)))).toList();
                Schema requiredAvroSchema = Schema.createRecord((String)avroSchema.getName(), (String)avroSchema.getDoc(), (String)avroSchema.getNamespace(), (boolean)avroSchema.isError(), (java.util.List)((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)requiredFields).asJava()));
                StructType requiredStructSchema = AvroConversionUtils$.MODULE$.convertAvroSchemaToStructType(requiredAvroSchema);
                tuple3 = new Tuple3((Object)requiredAvroSchema, (Object)requiredStructSchema, (Object)InternalSchema.getEmptyInternalSchema());
            }
            return tuple3;
        }
        throw new MatchError(either);
    }

    public Function1<PartitionedFile, Iterator<InternalRow>> org$apache$hudi$HoodieBaseRelation$$createHFileReader(SparkSession spark, HoodieTableSchema dataSchema2, HoodieTableSchema requiredDataSchema, Seq<Filter> filters, Map<String, String> options, Configuration hadoopConf) {
        Broadcast hadoopConfBroadcast = spark.sparkContext().broadcast((Object)new SerializableConfiguration(hadoopConf), ClassTag$.MODULE$.apply(SerializableConfiguration.class));
        return new Serializable(requiredDataSchema, hadoopConfBroadcast){
            public static final long serialVersionUID = 0L;
            private final HoodieTableSchema requiredDataSchema$1;
            private final Broadcast hadoopConfBroadcast$1;

            public final Iterator<InternalRow> apply(PartitionedFile partitionedFile) {
                Configuration hadoopConf = ((SerializableConfiguration)this.hadoopConfBroadcast$1.value()).get();
                HoodieHFileReader reader = new HoodieHFileReader(hadoopConf, new Path(partitionedFile.filePath()), new CacheConfig(hadoopConf));
                StructType requiredRowSchema = this.requiredDataSchema$1.structTypeSchema();
                Schema requiredAvroSchema = new Schema.Parser().parse(this.requiredDataSchema$1.avroSchemaStr());
                Function1 avroToRowConverter = AvroConversionUtils$.MODULE$.createAvroToInternalRowConverter(requiredAvroSchema, requiredRowSchema);
                return ((Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter((java.util.Iterator)reader.getRecordIterator(requiredAvroSchema)).asScala()).map((Function1)new Serializable(this, avroToRowConverter){
                    public static final long serialVersionUID = 0L;
                    private final Function1 avroToRowConverter$1;

                    public final InternalRow apply(GenericRecord record) {
                        return (InternalRow)((Option)this.avroToRowConverter$1.apply((Object)record)).get();
                    }
                    {
                        this.avroToRowConverter$1 = avroToRowConverter$1;
                    }
                });
            }
            {
                this.requiredDataSchema$1 = requiredDataSchema$1;
                this.hadoopConfBroadcast$1 = hadoopConfBroadcast$1;
            }
        };
    }

    private HoodieBaseRelation$() {
        MODULE$ = this;
        SparkAdapterSupport.class.$init$((SparkAdapterSupport)this);
    }
}

