/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.DataSourceReadOptions$;
import org.apache.hudi.HoodieBaseRelation;
import org.apache.hudi.HoodieIncrementalRelationTrait;
import org.apache.hudi.common.model.HoodieCommitMetadata;
import org.apache.hudi.common.table.timeline.HoodieInstant;
import org.apache.hudi.common.table.timeline.HoodieTimeline;
import org.apache.hudi.exception.HoodieException;
import org.apache.hudi.hadoop.utils.HoodieInputFormatUtils;
import org.apache.spark.sql.sources.Filter;
import org.apache.spark.sql.sources.GreaterThan;
import org.apache.spark.sql.sources.IsNotNull;
import org.apache.spark.sql.sources.LessThanOrEqual;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.Nothing$;

public abstract class HoodieIncrementalRelationTrait$class {
    public static String startTimestamp(HoodieIncrementalRelationTrait $this) {
        return (String)((HoodieBaseRelation)((Object)$this)).optParams().apply((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key());
    }

    public static String endTimestamp(HoodieIncrementalRelationTrait $this) {
        return (String)((HoodieBaseRelation)((Object)$this)).optParams().getOrElse((Object)DataSourceReadOptions$.MODULE$.END_INSTANTTIME().key(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieIncrementalRelationTrait $outer;

            public final String apply() {
                return ((HoodieInstant)this.$outer.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().lastInstant().get()).getTimestamp();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public static boolean startInstantArchived(HoodieIncrementalRelationTrait $this) {
        return $this.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().isBeforeTimelineStarts($this.startTimestamp());
    }

    public static boolean endInstantArchived(HoodieIncrementalRelationTrait $this) {
        return $this.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().isBeforeTimelineStarts($this.endTimestamp());
    }

    public static boolean fullTableScan(HoodieIncrementalRelationTrait $this) {
        boolean fallbackToFullTableScan = new StringOps(Predef$.MODULE$.augmentString((String)((HoodieBaseRelation)((Object)$this)).optParams().getOrElse((Object)DataSourceReadOptions$.MODULE$.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().key(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)DataSourceReadOptions$.MODULE$.INCREMENTAL_FALLBACK_TO_FULL_TABLE_SCAN_FOR_NON_EXISTING_FILES().defaultValue();
            }
        }))).toBoolean();
        return fallbackToFullTableScan && ($this.startInstantArchived() || $this.endInstantArchived() || Predef$.MODULE$.refArrayOps((Object[])$this.affectedFilesInCommits()).exists((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieIncrementalRelationTrait $outer;

            public final boolean apply(FileStatus fileStatus) {
                return !((HoodieBaseRelation)((Object)this.$outer)).metaClient().getFs().exists(fileStatus.getPath());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public static scala.collection.immutable.Seq includedCommits(HoodieIncrementalRelationTrait $this) {
        return $this.startInstantArchived() && $this.endInstantArchived() ? ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter($this.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().getInstants().iterator()).asScala()).toList() : ((TraversableOnce)JavaConverters$.MODULE$.asScalaIteratorConverter($this.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().findInstantsInRange($this.startTimestamp(), $this.endTimestamp()).getInstants().iterator()).asScala()).toList();
    }

    public static List commitsMetadata(HoodieIncrementalRelationTrait $this) {
        return (List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)$this.includedCommits().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ HoodieIncrementalRelationTrait $outer;

            public final HoodieCommitMetadata apply(HoodieInstant x$3) {
                return HoodieInputFormatUtils.getCommitMetadata((HoodieInstant)x$3, (HoodieTimeline)this.$outer.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Seq$.MODULE$.canBuildFrom())).asJava();
    }

    public static FileStatus[] affectedFilesInCommits(HoodieIncrementalRelationTrait $this) {
        return HoodieInputFormatUtils.listAffectedFilesForCommits((Configuration)((HoodieBaseRelation)((Object)$this)).conf(), (Path)new Path(((HoodieBaseRelation)((Object)$this)).metaClient().getBasePath()), $this.commitsMetadata());
    }

    public static Seq incrementalSpanRecordFilters(HoodieIncrementalRelationTrait $this) {
        IsNotNull isNotNullFilter = new IsNotNull("_hoodie_commit_time");
        GreaterThan largerThanFilter = new GreaterThan("_hoodie_commit_time", (Object)$this.startTimestamp());
        LessThanOrEqual lessThanFilter = new LessThanOrEqual("_hoodie_commit_time", (Object)($this.endInstantArchived() ? $this.endTimestamp() : ((HoodieInstant)$this.includedCommits().last()).getTimestamp()));
        return (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Filter[]{isNotNullFilter, largerThanFilter, lessThanFilter}));
    }

    public static Seq mandatoryFields(HoodieIncrementalRelationTrait $this) {
        return (Seq)((TraversableLike)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"_hoodie_record_key", "_hoodie_commit_time"}))).$plus$plus((GenTraversableOnce)((HoodieBaseRelation)((Object)$this)).preCombineFieldOpt().map((Function1)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<String> apply(String x$4) {
                return (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{x$4}));
            }
        }).getOrElse((Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final Seq<Nothing$> apply() {
                return (Seq)scala.collection.Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
            }
        }), scala.collection.Seq$.MODULE$.canBuildFrom());
    }

    public static void validate(HoodieIncrementalRelationTrait $this) {
        if ($this.org$apache$hudi$HoodieIncrementalRelationTrait$$super$timeline().empty()) {
            throw new HoodieException("No instants to incrementally pull");
        }
        if (((HoodieBaseRelation)((Object)$this)).optParams().contains((Object)DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key())) {
            if (((HoodieBaseRelation)((Object)$this)).tableConfig().populateMetaFields()) {
                return;
            }
            throw new HoodieException("Incremental queries are not supported when meta fields are disabled");
        }
        throw new HoodieException(new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Specify the begin instant time to pull from using "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"option ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{DataSourceReadOptions$.MODULE$.BEGIN_INSTANTTIME().key()}))).toString());
    }

    public static String globPattern(HoodieIncrementalRelationTrait $this) {
        return (String)((HoodieBaseRelation)((Object)$this)).optParams().getOrElse((Object)DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().key(), (Function0)new Serializable($this){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return (String)DataSourceReadOptions$.MODULE$.INCR_PATH_GLOB().defaultValue();
            }
        });
    }

    public static void $init$(HoodieIncrementalRelationTrait $this) {
        $this.validate();
    }
}

