/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hudi;

import java.util.Properties;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hudi.HoodieConversionUtils$;
import org.apache.hudi.HoodieMergeOnReadFileSplit;
import org.apache.hudi.HoodieTableState;
import org.apache.hudi.common.config.HoodieCommonConfig;
import org.apache.hudi.common.config.HoodieMetadataConfig;
import org.apache.hudi.common.engine.HoodieEngineContext;
import org.apache.hudi.common.engine.HoodieLocalEngineContext;
import org.apache.hudi.common.fs.FSUtils;
import org.apache.hudi.common.model.HoodieLogFile;
import org.apache.hudi.common.table.log.HoodieMergedLogRecordScanner;
import org.apache.hudi.common.util.collection.ExternalSpillableMap;
import org.apache.hudi.internal.schema.InternalSchema;
import org.apache.hudi.metadata.HoodieBackedTableMetadata;
import org.apache.hudi.metadata.HoodieTableMetadata;
import org.apache.spark.sql.execution.datasources.PartitionedFile;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;

public final class HoodieMergeOnReadRDD$
implements Serializable {
    public static final HoodieMergeOnReadRDD$ MODULE$;
    private final Object CONFIG_INSTANTIATION_LOCK;

    static {
        new HoodieMergeOnReadRDD$();
    }

    public Object CONFIG_INSTANTIATION_LOCK() {
        return this.CONFIG_INSTANTIATION_LOCK;
    }

    public HoodieMergedLogRecordScanner scanLog(List<HoodieLogFile> logFiles, Path partitionPath, Schema logSchema, HoodieTableState tableState, long maxCompactionMemoryInBytes, Configuration hadoopConf, InternalSchema internalSchema) {
        HoodieMergedLogRecordScanner hoodieMergedLogRecordScanner;
        String tablePath = tableState.tablePath();
        FileSystem fs = FSUtils.getFs((String)tablePath, (Configuration)hadoopConf);
        if (HoodieTableMetadata.isMetadataTable((String)tablePath)) {
            HoodieMetadataConfig metadataConfig = HoodieMetadataConfig.newBuilder().fromProperties((Properties)tableState.metadataConfig().getProps()).enable(true).build();
            String dataTableBasePath = HoodieTableMetadata.getDataTableBasePathFromMetadataTable((String)tablePath);
            HoodieBackedTableMetadata metadataTable = new HoodieBackedTableMetadata((HoodieEngineContext)new HoodieLocalEngineContext(hadoopConf), metadataConfig, dataTableBasePath, hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/"));
            boolean forceFullScan = true;
            String relativePartitionPath = FSUtils.getRelativePartitionPath((Path)new Path(tablePath), (Path)partitionPath);
            hoodieMergedLogRecordScanner = (HoodieMergedLogRecordScanner)metadataTable.getLogRecordScanner((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter(logFiles).asJava(), relativePartitionPath, HoodieConversionUtils$.MODULE$.toJavaOption((Option)new Some((Object)Predef$.MODULE$.boolean2Boolean(forceFullScan)))).getLeft();
        } else {
            HoodieMergedLogRecordScanner.Builder logRecordScannerBuilder = HoodieMergedLogRecordScanner.newBuilder().withFileSystem(fs).withBasePath(tablePath).withLogFilePaths((java.util.List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)logFiles.map((Function1)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(HoodieLogFile logFile) {
                    return logFile.getPath().toString();
                }
            }, List$.MODULE$.canBuildFrom())).asJava()).withReaderSchema(logSchema).withLatestInstantTime(tableState.latestCommitTimestamp()).withReadBlocksLazily(BoxesRunTime.unboxToBoolean((Object)Try$.MODULE$.apply((Function0)new Serializable(hadoopConf){
                public static final long serialVersionUID = 0L;
                private final Configuration hadoopConf$1;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return new StringOps(Predef$.MODULE$.augmentString(this.hadoopConf$1.get("compaction.lazy.block.read.enabled", "true"))).toBoolean();
                }
                {
                    this.hadoopConf$1 = hadoopConf$1;
                }
            }).getOrElse((Function0)new Serializable(){
                public static final long serialVersionUID = 0L;

                public final boolean apply() {
                    return this.apply$mcZ$sp();
                }

                public boolean apply$mcZ$sp() {
                    return false;
                }
            }))).withReverseReader(false).withInternalSchema(internalSchema).withBufferSize(hadoopConf.getInt("hoodie.memory.dfs.buffer.max.size", 0x100000)).withMaxMemorySizeInBytes(Predef$.MODULE$.long2Long(maxCompactionMemoryInBytes)).withSpillableMapBasePath(hadoopConf.get("hoodie.memory.spillable.map.path", "/tmp/")).withDiskMapType((ExternalSpillableMap.DiskMapType)hadoopConf.getEnum(HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.key(), (Enum)HoodieCommonConfig.SPILLABLE_DISK_MAP_TYPE.defaultValue())).withBitCaskDiskMapCompressionEnabled(hadoopConf.getBoolean(HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.key(), Predef$.MODULE$.Boolean2boolean((Boolean)HoodieCommonConfig.DISK_MAP_BITCASK_COMPRESSION_ENABLED.defaultValue())));
            Object object = logFiles.nonEmpty() ? logRecordScannerBuilder.withPartition(FSUtils.getRelativePartitionPath((Path)new Path(tableState.tablePath()), (Path)((HoodieLogFile)logFiles.head()).getPath().getParent())) : BoxedUnit.UNIT;
            hoodieMergedLogRecordScanner = logRecordScannerBuilder.build();
        }
        return hoodieMergedLogRecordScanner;
    }

    public InternalSchema scanLog$default$7() {
        return InternalSchema.getEmptyInternalSchema();
    }

    public GenericRecord org$apache$hudi$HoodieMergeOnReadRDD$$projectAvroUnsafe(GenericRecord record, Schema projectedSchema, GenericRecordBuilder reusableRecordBuilder) {
        Buffer fields = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(projectedSchema.getFields()).asScala();
        fields.foreach((Function1)new Serializable(record, reusableRecordBuilder){
            public static final long serialVersionUID = 0L;
            private final GenericRecord record$2;
            private final GenericRecordBuilder reusableRecordBuilder$1;

            public final GenericRecordBuilder apply(Schema.Field field) {
                return this.reusableRecordBuilder$1.set(field, this.record$2.get(field.name()));
            }
            {
                this.record$2 = record$2;
                this.reusableRecordBuilder$1 = reusableRecordBuilder$1;
            }
        });
        return reusableRecordBuilder.build();
    }

    public Path org$apache$hudi$HoodieMergeOnReadRDD$$getPartitionPath(HoodieMergeOnReadFileSplit split) {
        return ((Path)split.dataFile().map((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Path apply(PartitionedFile baseFile) {
                return new Path(baseFile.filePath());
            }
        }).getOrElse((Function0)new Serializable(split){
            public static final long serialVersionUID = 0L;
            private final HoodieMergeOnReadFileSplit split$1;

            public final Path apply() {
                return ((HoodieLogFile)this.split$1.logFiles().head()).getPath();
            }
            {
                this.split$1 = split$1;
            }
        })).getParent();
    }

    private Object readResolve() {
        return MODULE$;
    }

    private HoodieMergeOnReadRDD$() {
        MODULE$ = this;
        this.CONFIG_INSTANTIATION_LOCK = new Object();
    }
}

